# Úvod
Tento soubor obsahuje informace důležité pro použití nástroje **na_detector**
zajišťující  automatizovanou detekci síťových útoků ze zachycené síťové komunikace. 
Nástroj detekuje útoky pomocí jejich deklarativních zápisů v serializačním 
formátu YAML. Součástí tohoto README souboru jsou informace o tom, jak nástroj
spustit a jaké knihovny je zapotřebí nainstalovat pro jeho korektní běh. Zároveň
obsahuje neformální popis pro vytvoření deklarativních zápisů útoků.

# Spuštění programu:

Program se spouští pomocí následujícího příkazu:
```
python na_detector.py -i cesta_k_souboru -d cesta_k_adresari [-s]
```

Přepínače mají následující význam:
* *-i* specifikuje cestu ke vstupnímu souboru se zachycenou síťovou komunikací
* *-d* specifikuje cestu k adresáři, ve kterém jsou obsaženy deklarativní zápisy útoků
       (v této složce by měly být pouze deklarativní popisy v YAML)
* *-s* zapíná strukturovaný výpis pomocí XML, bez něj je výstup v lidsky čitelnější podobě

Pro běh nástroje je zapotřebí nainstalovat následující knihovny a nástroje:
* Nástroj [tshark](https://www.wireshark.org/docs/man-pages/tshark.html) 
(testováno na verzi 2.2.6, která je minimální nutnou verzí pro běh nástroje)
* Knihovna [PyYAML](http://pyyaml.org/wiki/PyYAMLDocumentation) pro parsování 
souborů typu YAML (testováno na verzi 3.12)
* Knihovna [cElementTree](http://effbot.org/zone/celementtree.htm) pro rychlé 
parsování XML souborů (testováno na verzi 1.0.5) 
  
Pro automatickou instalaci potřebných knihoven a nástrojů jsou ve složce 
**instalacni_skripty** umístěny skripty v jazyce bash. Názvy těchto skriptů a
operační systémy, pro které jsou určeny jsou následující:
* *install_debian.sh*: Pro automatickou instalaci knihoven a nástrojů na operačních
systémech založených na Debianu (*Mint*, *Ubuntu*, ...)
* *install_centos.sh*: Pro automatickou instalaci knihoven a nástrojů na operačním
systému *CentOS*
* *install_fedora.sh*: Pro automatickou instalaci knihoven a nástrojů na operačním
systému *Fedora*

Nástroj byl vyvíjen a testován na operačním systému **Linux Mint 18.2** (64-bit) s 
interpretem jazyka Python ve verzi 2.7.12.
 
# Návod na vytváření deklarativního popisu útoku

Tento README soubor se rovněž zabývá popisem postupu, jenž je zapotřebí dodržet při 
tvorbě nového deklarativního popisu útoku, který je možné interpretovat
nástrojem pro detekci síťových útoků, jehož je tento README soubor součástí. 

Deklarativní zápis je realizován pomocí serializačního formátu YAML ve verzi 
1.1, jehož popis je možné nalézt v [oficiální dokumentaci](http://yaml.org/spec/1.1/).
Serializační formát YAML byl zvolen především z důvodu jeho snadné čitelnosti a 
možnosti rychlé tvorby nových deklarativních popisů. V následujícím textu budou 
využívany pojmy "struktura" a "kolekce", jejichž významy korespondují s
definicemi uvedenými ve výše zmíněné dokumentaci.

## Začátek

Prvním krokem při vytváření nového útoku je stanovení jeho jména, které je 
využíváno v konečném výpisu pozitivních či negativních detekcí útoku, nebo
v případných chybových hlášeních. Jméno útoku je specifikováno v popisu pomocí
atributu **name**, jenž očekává řetězcovou hodnotu specifikující právě jméno
útoku. Tato hodnota by měla být unikátní, aby nedocházelo k nejednoznačnostem
u příslušných výstupů.

V dalším kroku je nutné specifikovat hodnotu atributu **scope**, který může
nabývat tří řetězcových hodnot a to jest: *atomic*, *stream* a *group*. Výběr 
hodnoty tohoto atributu má vliv na způsob zpracování paketů v průběhu detekce 
útoku. Hodnota atributu se určí následně:

* Pokud je zapotřebí při útoku zkoumat jednotlivé TCP/UDP streamy mezi dvěma 
komunikujícími entitami a útok hledat v těchto jednotlivých streamech (útok se
vyznačuje přítomností specifických paketů ve streamu), zvolíme hodnotu *stream*. 

* Pokud je podobně jako v přechozím případě zapotřebí hledat útok ve skupině
paketů, které ovšem není možné seskupit jako v přechozím případě pomocí TCP/UDP
streamů, použijeme hodnotu *group*. V tomto typu útoku jsou pakety rozmístěny do 
jednotlivých skupin na základě stejných hodnot určitého pole (či polí) 
specifikovaných uživatelem. Útoky jsou pak vyhledávány v takto vytvořených skupinách 
na základě výskytu specifických paketů ve skupině.

* Pokud nevyhovuje ani jedna z přechozích hodnot, použijeme hodnotu *atomic*. 
Tento typ útoku vyhledává útoky v jednotlivých paketech (tzn. útok lze detekovat
z jednoho paketu), nebo při detekci bere v potaz nějákou ze statistik paketů z 
celého vstupního souboru (např. počet všech paketů v souboru, počet unikátních
hodnot určitého pole paketu, poměr dvou typů paketů, atp., podrobnosti viz. dále). 
Podstatné je, že při detekci nejsou pakety jakkoliv rozčleňovány do skupin a 
detekce probíhá v rámci paketů v celém vstupním souboru, pomocí dostupných detekčních 
podmínek (viz. dále).

Po specifikování typu útoku je vhodné určit, které pakety nás budou při vyhledávání 
útoku ve vstupním souboru zajímat. Toho lze docílit pomocí atributu **properties**,
který je sice **nepovinný**, nicméně je vhodné jej specifikovat, čímž dojde k 
redukci prohledávaných paketů a zrychlení samotné detekce. Atribut **properties** 
je kolekcí jednotlivých pravidel, které slouží pro filtrování paketů před průběhem
samotného procesu detekce. Filtrovací pravidla jsou *jednoduchá* a *složená*:

* Jednoduché pravidlo sestává pouze ze dvou **povinných** atributů **field-name**,
očekávajícího řetězec a **valid** očekávajícího datový typ boolean. Příkladem může 
být následující pravidlo, které vyfiltruje všechny pakety obsahující pole s názvem 
"arp":

```
field-name: arp
valid: true
```
* Hodnota atributu **valid** určuje, zda má paket obsahovat pole specifikované
atributem **field-name**, následující pravidlo tedy naopak vyfiltruje všechny
pakety, které pole "arp" neobsahují:
```
field-name: arp
valid: false
```
* Složené pravidlo se již vztahuje na konrétní hodnoty specifikovaného pole. 
Kromě výše uvedených atributů **field-name** a **valid** tedy navíc obsahuje
atribut **value**, který určuje požadovanou hodnotu specifikovaného pole. 
Vždy očekává hodnotu řetězcového typu, i když se jedná o hodnotu číselného
charakteru. Příkladem může být následující pravidlo, filtrující všechny pakety s 
hodnotou pole "icmpv6.type" rovné hodnotě "130":
```
field-name: icmpv6.type
value: '130'
valid: true
```
* V případě, že je hodnota atributu **valid** nastavena ve složeném pravidlu na 
false, jsou vyfiltrovány všechny pakety, které toto pole sice obsahují, nicméně 
jeho hodnota je rozdílná od hodnoty specifikované atributem **value**. Pokud paket 
toto pole vůbec neobsahuje, je pravidlo pro takový paket vyhodnoceno jako 
nepravdivé.

Pokud je v kolekci **properties** uvedeno více než jedno pravidlo, musí pro daný
paket platit všechna pravidla současně, aby byl takový paket uvažován při samotném 
procesu detekce. Pokud by pouze jedno z těchto pravidel neplatilo, bude paket 
odfiltrován a nedojde k jeho následnému zpracování.

Další postup při vytváření deklarativního popisu útoku se liší podle zvolené
hodnoty atributu **scope**. V následujících sekcích bude pro každou možnou hodnotu
tohoto atributu vysvětlen další postup.

### Postup pro hodnotu atributu *stream*
Jak již bylo zmíněno výše, tento typ útoku před samotnou detekcí rozdělí jednotlivé
pakety ve vstupním souboru do jednotlivých TCP/UDP streamů (na základě indexu streamu,
doplněného nástrojem tshark), ve kterých se pak snaží útok detekovat. Tvůrce popisu 
v tomto případě musí specifikovat, jaké pakety musí být v daném streamu nalezeny 
(včetně dalších informací, které budou zmíněny dále), aby mohl být stream označen 
za pozitivní detekci. 

V první části je tedy nezbytné takové pakety specifikovat. Všechny následující
atributy v této sekci, které budou zmíněny jsou **povinné**, pokud nebude explicitně 
řečeno jinak. Specifikace paketů je možná prostřednictvím atributu
**packets-specification**, jehož hodnotou je struktura sestávající ze tří atributů
a to jest **specification**, **follow** a **specified-only**.

První z nich slouží k již výše zmíněné specifikaci paketů. Tento atribut je 
kolekcí struktur, kde jedna struktura reprezentuje popis právě jednoho typu
paketu. U popisu každého typu paketu (jedna struktura ve výše zmíněné kolekci) je 
nutné specifikovat kolikrát se daný paket může ve streamu vyskytovat, což je možné
určit buď pomocí atributu **count**, který jako hodnotu očekává celé číslo. Tento
atribut se použije, pokud je možné přesně specifikovat počet daného typu paketů 
v daném streamu. Pokud toto možné není, lze využít dvojici atributů **min-count** 
a **max-count**, kterými lze vymezit interval, ve kterém skutečný počet paketů ve 
streamu musí ležet. Oba atributy očekávají celé číslo, nicméně atribut **max-count** 
může obsahovat hodnotu '*', která značí neomezenou horní hranici intervalu.

Následně je nezbytné specifikovat konkrétní vlastnosti daného typu paketů. To 
lze pomocí atributu **packet-properties**, což je kolekce pravidel, jejichž
syntaxe a sémantika je identická s filtrovacími pravidly uvedenými v kolekci
**properties**, jenž je popsána v sekci Úvod. Pomocí těchto pravidel lze tedy
identifikovat pakety na základě obsahu (či naopak absence - atribut valid) 
specifického pole, nebo na základě konkrétní hodnoty nějákého z polí. Opět jako
u kolekce **properties** platí, že pokud je uvedeno více pravidel, musí platit
všechna uvedená. 

V tuto chvíli jsou tedy již popsány všechny typy paketů, které se mají vyskytovat
v daném streamu, včetně jejich počtu. Posledním krokem je specifikace hodnot
výše zmíněných atributů **follow** a **specified-only**. Pokud je zapotřebí, 
aby se specifikované typy paketů vyskytovaly v daném streamu bezprostředně za
sebou, je zapotřebí nastavit atribut **follow** na true. V tomto případě je tedy
kontrolováno, zda specifikované pakety následují hned za sebou ve stejném pořadí,
jako jsou uvedeny v kolekci **specification**, včetně jejich odpovídajících počtů.
Pokud je hodnota atributu **follow** nastavena na false, je u paketů pouze zkontrolován
jejich počet a samotný výskyt ve streamu, nicméně jejich pořadí není nikterak
kontrolováno. 

Pokud mají být pakety specifikované v kolekci **specification** jedinými pakety
ve streamu (tzn. ve streamu se nesmí vyskytovat žádné jiné pakety, než ty v 
této kolekci specifikované) je nutné nastavit atribut **specified-only** na hodnotu
true. Pokud je tento atribut nastaven na hodnotu false, mohou se kromě specifikovaných
paketů vyskytovat ve streamu i jiné pakety, nicméně jsou ignorovány a nejsou
nikterak zkoumány. Uvažujme tedy následující příklad, popisující skenování
portů metodou SYN/TCP:

```
packets-specification:
  follow: true
  specified-only: false
  specification:
    - count: 1
      packet-properties:
        - field-name: tcp.flags
          value: '0x00000002' # SYN paket
          valid: true
    - count: 1
      packet-properties:
        - field-name: tcp.flags
          value: '0x00000014' #RST ACK paket - znaci uzavreny port
          valid: true
```
Výše uvedený popis reprezentuje útok, který je specifikován výskytem dvou typů
paketů popsaných v sekci **specification**. První z nich musí mít nastavený
příznak SYN (hodnota tcp.flags == 0x00000002) a druhý příznaky RST a ACK 
(tcp.flags == 0x00000014). Od každého typu paketu se ve streamu musí vyskytovat
právě jeden paket (atribut **count**). Specifikované pakety se ve streamu
musí vyskytovat bezprostředně za sebou, díky parametru follow nastaveného na
hodnotu true (tzn. nejdříve SYN paket a bezprostředně za ním RST/ACK paket) a
ve streamu se mohou vyskytovat i jiné pakety, než specifikované v sekci 
**specification** (specified-only == false).

Aby byl popis útoku kompletní je nutné ještě definovat kolik pozitivních
detekcí (tzn. streamů, ve kterých jsou specifikované pakety detekovány) je nutné
nalézt, aby bylo vypsáno varovné, či chybové hlášení. K tomu slouží dva atributy
**threshold-warning** a **threshold-error**. Oba očekavají celočíslenou hodnotu
a je zapotřebí definovat alespoň jeden z nich. Pokud jsou zadány oba, očekává se,
že hodnota atributu **threshold-error** je ostře větší, než hodnota 
**threshold-warning**. Při vyhodnocení útoku je pak počet pozitivních detekcí 
porovnáván s hodnotami těchto atributů a v případě, že jejich počet je větší, nebo
roven hodotám těchto atributů, dojde k vypsání příslušného varovného, či
chybového hlášení. Tím je popis útoku kompletní.

### Postup pro hodnotu atributu *group*
Postup pro vytvoření popisu útoku typu *group* je naprosto identický jako v případě
útoku typu *bidirectional-flow*. Kromě všech atributů uvedených v předchozí sekci 
je zde ale oproti předchozímu typu útoku nutné specifikovat pole, na základě jejichž 
identických hodnot budou pakety zařazovány do stejných skupin (narozdíl od předchozího 
typu útoku, kde byly pakety rozčleňovány podle TCP/UDP streamu, do kterého patřily).
To je možné realizovat pomocí atributu group-by, který je v popisu uveden na stejné 
úrovni zanoření, jako atribut name, scope apod. Atribut group-by je kolekce struktur, 
kde jedna struktura reprezentuje jedno pole a sestává pouze z atributu field-name, 
který očekává řetězcovou hodnotu s názvem pole, na základě jehož společné hodnoty mají 
být pakety seskupeny. Při procesu vytváření skupin paketů je pak tato kolekce
sekvenčně procházena a je zkontrolováno, zda se aktuálně zkoumané pole vyskytuje
v paketu. Pokud ano, je paket zařazen do skupiny dle hodnoty pole. V případě, že
nikoliv, pokračuje se dalším polem uvedeným v kolekci. Pokud žádné z uvedených polí 
není nalezeno, paket je ignorován. Příkladem může být následující kolekce, ve které
jsou pakety rozčleňovány do skupin na základě stejné hodnoty polí 
"icmpv6.nd.ns.target_address" nebo "icmpv6.nd.na.target_address".
```
group-by:
  - field-name: icmpv6.nd.ns.target_address
  - field-name: icmpv6.nd.na.target_address
```

### Postup pro hodnotu atributu *atomic*
Tento typ útoku na rozdíl od předchozích typů útoků pakety nerozřazuje do streamů,
či jiných skupin, ve kterých se hledá potenciální výskyt útoku, ale prohledávání
probíhá v rámci všech paketů obsažených ve vstupním souboru (či případně pouze v
rámci vyfiltrovaných paketů po aplikaci pravidel v sekci **properties**).
Útoky mohou být detekovány na základě splnění některých ze čtyř druhů detekčních 
podmínek, které uživatel specifikuje. Tyto podmínky lze libovolně kombinovat a 
lze určit, zda musí platit všechny z nich, či alespoň jedna z uvedených apod.
Celkem jsou k dispozici tyto podmínky, jejichž význam bude uveden v samostatných
sekcích:
* Podmínka typu *field-value*
* Podmínka typu *field-count*
* Podmínka typu *packet-ratio*
* Podmínka typu *expression*

Podmínky je možné uvést pomocí povinného atributu **detection-conditions**,
jehož hodnotou je struktura obsahující dva atributy. Prvním z nich je povinný
atribut **type**, který očekává řetězcovou hodnotu *and* nebo *or* a specifikuje, 
zda uvedené podmínky musí platit všechny (hodnota *and*), nebo zda postačuje,
aby platila alespoň jedna z uvedených podmínek (hodnota *or*). Následuje povinný
atribut **conditions**, což už je kolekce samotných detekčních podmínek. Jedna 
podmínka je reprezentována právě jednou strukturou. Význam těchto podmínek a
podobu struktur reprezentujících podmínku je uveden v následujících sekcích.

#### Podmínka typu *field-value*
Tuto podmínku lze využít v případě, že útok lze detekovat na základě přítomnosti
určitého pole v paketu, nebo prostřednictívím specifické hodnoty některého pole.
Rovněž lze pomocí této podmínky detekovat útok, který je možné identifikovat na
základě počtu unikátních hodnot specifikovaného pole (např. pokud je ve vstupním
souboru nalezeno více než 100 různých unikátních hodnot specifického pole v paketech),
nebo pokud lze daný útok identifikovat tím, že určitý počet paketů sdílí stejnou 
hodnotu specifikovaného pole. Všechny parametry uvedené v této sekci jsou **povinné**,
pokud nebude explicitně řečeno jinak. Příkladem podmínky tohoto typu může být
následující poodmínka vyhodnotí jako pozitivní detekci takový paket, který obsahuje 
pole s názvem "ipv6.opt.unknown":
```
condition-type: field-value
field-name: ipv6.opt.unknown
```
Atribut **condition-type** v tomto případě určuje typ podmínky (v případě této 
podmínky se vždy jedná o hodnotu *field-value*) a atribut **field-name** název 
pole, jehož přítomnost indikuje výskyt útoku. Tuto podmínku lze navíc ještě
rozšířit tak, aby byl za pozitivní detekci označen takový paket, v němž má určité
pole nějákou konkrétní hodnotu. Příkladem může být následující podmínka:
```
condition-type: field-value
value-type: specific
field-name: ipv6.dst #Cílová IPv6 adresa
value: ff02::1
```
Tato podmínka vyhodnotí za pozitivní detekci všechny pakety, jejichž cílová
IPv6 adresa má hodnotu *ff02:1*. Atribut **value-type** s hodnotou *specific*
určuje, že nás zajímá konkrétní hodnota pole, jehož název je specifikován atributem
**field-name**. Atribut **value** pak určuje konkrétní hodnotu, která indikuje
přítomnost útoku.

Jak bylo zmíněno výše, lze definovat i podmínku, která z paketů ve vstupním souboru
zjistí počet unikátních hodnot specifikovaného pole:
```
condition-type: field-value
value-type: abstract
field-name: arp.dst.proto_ipv4 # Dotazovaná adresa v ARP request
value: different
count: 200
```
Při vyhodnocení této podmínky jsou procházeny všechny pakety a zaznamenávány
unikátní hodnoty pole "arp.dst.proto_ipv4". Atribut **value-type** s hodnotou
*abstract* určuje, že nás nezajímá žádná konkrétní hodnota atributu (jako tomu
bylo v předchozím případě), **field-name** určuje jméno pole, jehož hodnoty
se mají kontrolovat, **value** s hodnotou different znamená, že nás zajímá
počet unikátních hodnot specifikovaného pole a **count** je počet unikátních 
hodnot, po jejímž dosažení je podmínka vyhodnocena jako pravdivá. Výstupem
této podmínky tedy není konkrétní seznam paketů, ale pouze hodnota true (podmínka
je splněna), nebo false (podmínka není splněna).

Pokud nás zajímá, kolik různých paketů sdílí stejnou hodnotu nějákého atributu,
lze použít následující podmínku:
```
condition-type: field-value
value-type: abstract
field-name: bootp.id
value: same
count: 2
```
Tato podmínka je vyhodnocena jako pravdivá, pokud jsou nalezeny alespoň dva pakety
(atribut **count**), které mají stejnou hodnotu pole s názvem "bootp.id". Oproti
předhozímu příkladu se změní akorát hodnota atributu **value**, která je nyní
*same* a indikuje, že se mají hledat pakety se stejnou hodnotou specifikovaného
pole.

#### Podmínka typu *packet-ratio*
Tato podmínka se použije, pokud nás zajímá poměr počtu dvou typů paketů nacházejících
se ve vstupním souboru se zachycenou komunikací (například poměr počtu žádostí
protokolu ARP vůči počtu odpovědí ARP). Syntaxe této podmínky je následující:
```
condition-type: packet-ratio
ratio: 2.0
packets:
  - properties:
    - field-name: arp.opcode
      value: '2'
      valid: true
  - properties:
    - field-name: arp.opcode
      value: '1'
      valid: true
```
Atribut **condition-type** stejně jako v předchozím případě určuje typ podmínky.
Následuje povinný atribut **ratio**, který určuje hraniční poměr paketů, po jehož
překročení bude podmínka vyhodnocena jako pravdivá. Následuje povinný atribut 
**packets**, což je kolekce v níž jsou uvedeny vlastnosti jednotlivých paketů,
u kterých má být poměr vyhodnocen. Vždy je nutné specifikovat právě dva typy
paketů. Kolekce **properties** pak obsahuje vlastnosti daného typu paketů. Jejich
syntaxe a sémantika odpovídá syntaxi filtrovacích pravidel uvedených v sekci Úvod.
Podmínka je vyhodnocena následovně: Na základě uvedených vlastností se vyfiltrují
odpovídající pakety a následně je určen jejich počet. Poměr je pak vypočítán jako
počet paketů, které jsou v kolekci **packets** uvedeny jako první, děleno počtem
paketů, které jsou uvedeny v této kolekci jako druhé. Výsledek je poté porovnán
s hodnotou uvedenou v atributu **ratio** a pokud je výsledek větší, nebo roven
uvedenému poměru, je podmínka vyhodnocena jako pravdivá.

#### Podmínka typu expression
Tuto podmínku je možno využít, pokud uživatel chce vyhodnotit aritmetický výraz
specifikovaný prostřednictvím řetězce. Syntaxe této podmínky je následující:
```
condition-type: expression
expression: SrcIp == DstIp
variables:
  - name: SrcIp
    type: field-value
    field-name: ip.src
    value-type: specific
  - name: DstIp
    type: field-value
    field-name: ip.dst
    value-type: specific
```
Atribut **condition-type** specifikuje jako obvykle typ podmínky. Následuje atribut
**expression**, jehož hodnotou je výraz v řetězcové podobě, který má být vyhodocen.
V kolekci variables jsou pak uvedeny jednotlivé proměnné ve výrazu včetně určení,
která hodnota má být za proměnné dosazena. Platí pravidlo, že počáteční písmeno
proměnné ve výrazu by mělo být velké. U každé proměnné je uveden její typ v 
atributu **type**, který může dosahovat dvou hodnot. První z nich je 
*filtered-frame-count*. Pokud je proměnná tohoto typu, nevyžaduje již žádné
další atributy (pouze tedy **name** a **type**) a na místo proměnné je ve výrazu
dosazen celkový počet rámců, které obsahuje vstupní soubor po aplikaci filtrovacích
pravidel v kolekci **properties** (viz. sekce Úvod). Další hodnotou atributu
**type** je *field-value*, jež za proměnnou dosadí konkrétní hodnotu pole
specifikovaného atributem **field-name**. V takovém případě musí být atribut
**value-type** nastavený na hodnotu *specific*. 

Stejně jako u podmínky typu *field-value* je možné atribut **value-type** 
nastavit na hodnotu *abstract*. V takovém případě je pak ve struktuře popisující
proměnnou nezbytné přidat atribut **value**, jenž může dosahovat hodnot *different*
a *same*. Sémantika je stejná jako u podmínky typu *field-value*, čili je
za proměnné dosažen buď počet unikátních hodnot pole specifikovaného pomocí
atributu **field-name** (*different*), nebo maximální počet paketů, které sdílí 
stejnou hodnotu specifikovaného pole (*same*).

#### Podmínka typu *field-count*
Tento typ podmínky je poslední a použije se v případě, kdy je možné útok
identifikovat pomocí specifického počtu polí, které se vyskytují uvnitř paketu.
Syntaxe je následující:
```
condition-type: field-count
field-name: vlan
count: 2
```
V případě této podmínky bude za pozitivní detekci vyhodnocený takový paket, který
obsahuje právě dvě pole (atribut **count**) s názvem *vlan* (atribut **field-name**).
Jedná se tedy o podmínku detekující útok Double VLAN tagging.

#### Určení prahů detekce pro útok typu *atomic*
Stejně  jako u předchozích dvou typů útoků je nezbytné určit i zde prahy pro
detekci (tzn. kolik paketů musí splňovat specifikované podmínky, aby byl zahlášen
útok). Nastavení opět probíhá pomocí atributů **threshold-error** a 
**threshold-warning** a opět se očekává zadání alespoň jednoho z tohoto parametru.
V případě, že jsou zadány oba zaráz, očekává se, že hodnota atributu 
**threshold-error** bude ostře větší, než hodnota **threshold-warning**.
Podmínky pro nutnost jejich uvedení jsou ovšem poněkud složitější, než v předchozích
případech. Obecně se je třeba řídit následujícími pravidly:

* Pokud má atribut **type** hodnotu *or* (tzn. stačí, pokud platí pouze jedna
podmínka ze všech uvedených) je zapotřebí, aby každá z podmínek měla nastavený
svůj vlastní práh. To znamená, že kromě všech atributů, ze kterých se podmínka běžně
skládá je zapotřebí na stejnou úroveň zanoření jako má např. atribut **condition-type**
přidat jeden z atributů **threshold-warning**, **threshold-error**, nebo oba 
zaráz. 

* Pokud má atribut **type** hodnotu *or* není zapotřebí práh vůbec uvádět u
následujících podmínek: 1) *field-value*, pokud je její atribut **value-type**
nastavený na hodnotu *abstract*. 2) U podmínky typu *packet-ratio* se nenastavuje
práh nikdy 3) U podmínky typu *expression* není třeba práh zadávat, pokud VŠECHNY
proměnné mají atribut **type** nastavený na hodnotu *filtered-frames-count*, nebo
**type** nastavený na hodnotu *field-value* a současně s ním atribut 
**value-type** nastavený na *abstract* (atribut **value-type** se nastavuje pouze 
pokud je atribut **type** u proměnné nastavený na *field-value*).

* Pokud má atribut **type** hodnotu *and* vyhodnocení probíhá tak, že se nejdříve
vyhodnotí všechny podmínky a určí se počet paketů, pro které platí všechny podmínky
zaráz. V tomto případě tedy NENÍ zapotřebí uvádět prahy pro každou podmínku zvlášť, 
ale určí se společný práh, který se zapíše na stejnou úroveň, jako je atribut **name**, 
**scope** a další. Žádný práh není třeba uvádět (tzn. nikde v popisu), pokud se v 
seznamu podmínek vyskytují pouze tyto podmínky a jejich kombinace: 1) podmínka  *paket-ratio*, 
2) podmínka *field-value*, pokud  je v ní atribut **value-type** nastavený na hodnotu 
*abstract*, 3) Podmínka *expression*, pokud VŠECHNY proměnné mají atribut **type** nastavený na 
hodnotu  *filtered-frames-count*, nebo **type** nastavený na hodnotu *field-value* a 
současně s ním atribut  **value-type** nastavený na *abstract* (atribut **value-type** 
se nastavuje pouze pokud je atribut **type** u proměnné nastavený na *field-value*).

Nyní vyvstává otázka, proč není zrovna u těchto typů podmínek zaptořebí nastavovat
prahy. Je to kvůli tomu, že v těchto případech se pro vyhodnocení podmínky nevyužívá
žádný konkrétní paket, ale několik paketů současně. Obecně platí pravidlo, že kdykoliv
se podmínka vyhodnocuje zvlášť pro každý paket ve vstupním souboru (tzn. k vyhodnocení
podmínky postačuje jeden paket), vždy je zapotřebí práh uvést.

