package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.TollGateRow;
import general.io.OutputManager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TollGateTable extends DatabaseTable
{
    public static final String TABLE_NAME = "tollgate";
    
    public static final String COL_ID = "id";
    public static final String COL_GID = "detector";
    public static final String COL_START = "start";
    public static final String COL_UPDATED = "updated";
    public static final String COL_AXES_2 = "axes2";
    public static final String COL_AXES_3 = "axes3";
    public static final String COL_AXES_4 = "axes4";
    
    public TollGateTable( DatabaseManager dm )
    {
        super( dm );
    }
    
    public List<TollGateRow> getSumByHour( int gid, String dateStart, String dateEnd )
    {
        List<TollGateRow> rows = new ArrayList<>();
        
        String sql = "" +
                "SELECT " +
                "    -1 " + COL_ID + ", " +
                "    " + COL_GID + ", " +
                "    DATE_FORMAT(" + COL_START + ", \"%Y-%m-%d %H:00:00\") " + COL_START + ", " +
                "    MAX(" + COL_UPDATED + ") " + COL_UPDATED + ", " +
                "    SUM(" + COL_AXES_2 + ") " + COL_AXES_2 + ", " +
                "    SUM(" + COL_AXES_3 + ") " + COL_AXES_3 + ", " +
                "    SUM(" + COL_AXES_4 + ") " + COL_AXES_4 + " " +
                "FROM " +
                "    " + TABLE_NAME + " " +
                "WHERE " +
                "    " + COL_GID + " = ? AND " +
                "    DATE(" + COL_START + ") >= ? AND " +
                "    DATE(" + COL_START + ") < ? " +
                "GROUP BY " +
                "    DATE(" + COL_START + "), " +
                "    HOUR(" + COL_START + ") " +
                "ORDER BY " +
                "    DATE(" + COL_START + ") ASC, " +
                "    HOUR(" + COL_START + ") ASC; ";
        
        try( StatementManager sm = new StatementManager( dm ) )
        {
            PreparedStatement ps = sm.prepareStatement( sql );
            
            {
                int i = 0;
                
                ps.setInt( ++i, gid );
                ps.setString( ++i, dateStart );
                ps.setString( ++i, dateEnd );
            }
    
            ResultSet rs = ps.executeQuery();
    
            rows.addAll( TollGateRow.getRows( rs ) );
        }
        catch( SQLException e )
        {
            OutputManager.getInstance().printException( e );
        }
        
        return rows;
    }
}
