
package cz.vutbr.fit.rodos.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseManager
{
    private String host = "localhost";
    private int port = 3306;
    private String database = "unknown_database";
    private String user = "root";
    private String password = "";
    
    public DatabaseManager() throws SQLException
    {
        try
        {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch( ClassNotFoundException ex )
        {
            throw new SQLException( "Cannot find mysql driver.", ex );
        }
    }
    
    public void setHost( String host )
    {
        this.host = host;
    }
    
    public void setPort( int port )
    {
        this.port = port;
    }
    
    public void setDatabase( String database )
    {
        this.database = database;
    }
    
    public void setUser( String user )
    {
        this.user = user;
    }
    
    public void setPassword( String password )
    {
        this.password = password;
    }
    
    public Connection getConnection() throws SQLException
    {
        String url = "jdbc:mysql://" + host;
        
        if( port > 0 )
        {
            url += ":" + port;
        }
    
        if( database == null || database.isEmpty() )
        {
            throw new SQLException( "MySQL database not specified." );
        }
    
        if( user == null || user.isEmpty() )
        {
            throw new SQLException( "MySQL user not specified." );
        }
        
        url += "/" + database + "?" + "user=" + user;
        
        if( password != null && !password.isEmpty() )
        {
            url += "&password=" + password;
        }
        
        return DriverManager.getConnection( url );
    }
}
