/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.TollGateRow;
import general.io.OutputManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TollGateTable
extends DatabaseTable {
    public static final String TABLE_NAME = "tollgate";
    public static final String COL_ID = "id";
    public static final String COL_GID = "detector";
    public static final String COL_START = "start";
    public static final String COL_UPDATED = "updated";
    public static final String COL_AXES_2 = "axes2";
    public static final String COL_AXES_3 = "axes3";
    public static final String COL_AXES_4 = "axes4";

    public TollGateTable(DatabaseManager dm) {
        super(dm);
    }

    public List<TollGateRow> getSumByHour(int gid, String dateStart, String dateEnd) {
        ArrayList<TollGateRow> rows = new ArrayList<TollGateRow>();
        String sql = "SELECT     -1 id,     detector,     DATE_FORMAT(start, \"%Y-%m-%d %H:00:00\") start,     MAX(updated) updated,     SUM(axes2) axes2,     SUM(axes3) axes3,     SUM(axes4) axes4 FROM     tollgate WHERE     detector = ? AND     DATE(start) >= ? AND     DATE(start) < ? GROUP BY     DATE(start),     HOUR(start) ORDER BY     DATE(start) ASC,     HOUR(start) ASC; ";
        try (StatementManager sm = new StatementManager(this.dm);){
            PreparedStatement ps = sm.prepareStatement(sql);
            int i = 0;
            ps.setInt(++i, gid);
            ps.setString(++i, dateStart);
            ps.setString(++i, dateEnd);
            ResultSet rs = ps.executeQuery();
            rows.addAll(TollGateRow.getRows(rs));
        }
        catch (SQLException e) {
            OutputManager.getInstance().printException(e);
        }
        return rows;
    }
}

