/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos.db.tables;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import cz.vutbr.fit.rodos.db.DatabaseTable;
import cz.vutbr.fit.rodos.db.StatementManager;
import cz.vutbr.fit.rodos.db.rows.AsimRow;
import general.io.OutputManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AsimTable
extends DatabaseTable {
    public static final String TABLE_NAME = "asim";
    public static final String COL_ID = "id";
    public static final String COL_GID = "detector";
    public static final String COL_START = "start";
    public static final String COL_CATEGORY_1_AMOUNT = "category_1_amount";
    public static final String COL_CATEGORY_2_AMOUNT = "category_2_amount";
    public static final String COL_CATEGORY_3_AMOUNT = "category_3_amount";
    public static final String COL_CATEGORY_4_AMOUNT = "category_4_amount";
    public static final String COL_CATEGORY_5_AMOUNT = "category_5_amount";
    public static final String COL_CATEGORY_6_AMOUNT = "category_6_amount";
    public static final String COL_CATEGORY_1_SPEED = "category_1_speed";
    public static final String COL_CATEGORY_2_SPEED = "category_2_speed";
    public static final String COL_CATEGORY_3_SPEED = "category_3_speed";
    public static final String COL_CATEGORY_4_SPEED = "category_4_speed";
    public static final String COL_CATEGORY_5_SPEED = "category_5_speed";
    public static final String COL_CATEGORY_6_SPEED = "category_6_speed";

    public AsimTable(DatabaseManager dm) {
        super(dm);
    }

    public List<AsimRow> getSumByHour(int gid, String dateStart, String dateEnd) {
        ArrayList<AsimRow> rows = new ArrayList<AsimRow>();
        String sql = "SELECT     -1 id,     detector,     DATE_FORMAT(start, \"%Y-%m-%d %H:00:00\") start,     SUM(category_1_amount) category_1_amount,     SUM(category_2_amount) category_2_amount,     SUM(category_3_amount) category_3_amount,     SUM(category_4_amount) category_4_amount,     SUM(category_5_amount) category_5_amount,     SUM(category_6_amount) category_6_amount,     SUM(category_1_speed) category_1_speed,     SUM(category_2_speed) category_2_speed,     SUM(category_3_speed) category_3_speed,     SUM(category_4_speed) category_4_speed,     SUM(category_5_speed) category_5_speed,     SUM(category_6_speed) category_6_speed FROM     asim WHERE     detector = ? AND     DATE(start) >= ? AND     DATE(start) < ? GROUP BY     DATE(start),     HOUR(start) ORDER BY     DATE(start) ASC,     HOUR(start) ASC; ";
        try (StatementManager sm = new StatementManager(this.dm);){
            PreparedStatement ps = sm.prepareStatement(sql);
            int i = 0;
            ps.setInt(++i, gid);
            ps.setString(++i, dateStart);
            ps.setString(++i, dateEnd);
            ResultSet rs = ps.executeQuery();
            rows.addAll(AsimRow.getRows(rs));
        }
        catch (SQLException e) {
            OutputManager.getInstance().printException(e);
        }
        return rows;
    }
}

