/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos.db;

import cz.vutbr.fit.rodos.db.DatabaseManager;
import general.io.OutputManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class StatementManager
implements AutoCloseable {
    private final DatabaseManager dm;
    private Connection conn;
    private final List<Statement> statements;

    public StatementManager(DatabaseManager dm) {
        this.dm = dm;
        this.statements = new ArrayList<Statement>();
    }

    private Connection getConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            this.conn = this.dm.getConnection();
        }
        return this.conn;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, false);
    }

    public PreparedStatement prepareStatement(String sql, boolean returnKeys) throws SQLException {
        PreparedStatement ps = returnKeys ? this.getConnection().prepareStatement(sql, 1) : this.getConnection().prepareStatement(sql);
        this.statements.add(ps);
        return ps;
    }

    public Statement createStatement() throws SQLException {
        Statement st = this.getConnection().createStatement();
        this.statements.add(st);
        return st;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                OutputManager.getInstance().printException(e);
            }
        }
        for (Statement ps : this.statements) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                OutputManager.getInstance().printException(e);
            }
        }
    }
}

