/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.rodos;

import general.io.OutputManager;

public class MainParameters {
    public static final int NO_VALUE = -1;
    public static final int DETECTOR_ASIM = 0;
    public static final int DETECTOR_TOLLGATE = 1;
    public static final int DETECTOR_OTHER = 2;
    public static final int COLUMN_CATEGORY_1 = 1;
    public static final int COLUMN_CATEGORY_2 = 2;
    public static final int COLUMN_CATEGORY_3 = 3;
    public static final int COLUMN_CATEGORY_4 = 4;
    public static final int COLUMN_CATEGORY_5 = 5;
    public static final int COLUMN_CATEGORY_6 = 6;
    public static final int COLUMN_AXES_2 = 2;
    public static final int COLUMN_AXES_3 = 3;
    public static final int COLUMN_AXES_4 = 4;
    public static final int MODE_TRAIN = 1;
    public static final int MODE_PREDICT = 2;
    public int mode = -1;
    public int svmType = -1;
    public int kernelType = -1;
    public int polyDegree = -1;
    public int detectorType = -1;
    public int columnType = -1;
    public int predictDetector = -1;
    public int[] allDetectors = null;
    public String dbHost = null;
    public int dbPort = -1;
    public String db = null;
    public String dbUser = null;
    public String dbPassword = null;
    public String dbTable = null;
    public String dbColTime = null;
    public String dbColDetector = null;
    public String dbColAmount = null;
    public String modelFile = null;
    public String timeFrom = null;
    public String timeTo = null;

    public MainParameters(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String argNext = "";
            if (i + 1 < args.length) {
                argNext = args[i + 1];
            }
            if ("--help".equals(arg)) {
                this.printHelp();
                continue;
            }
            if ("--train".equals(arg)) {
                this.mode = 1;
                continue;
            }
            if ("--predict".equals(arg)) {
                this.mode = 2;
                continue;
            }
            if ("--modelFile".equals(arg)) {
                this.modelFile = argNext;
                ++i;
                continue;
            }
            if ("--dbHost".equals(arg)) {
                this.dbHost = argNext;
                ++i;
                continue;
            }
            if ("--dbPort".equals(arg)) {
                try {
                    this.dbPort = Integer.parseInt(argNext);
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Cannot parse value for parameter: " + arg, e);
                }
            }
            if ("--db".equals(arg)) {
                this.db = argNext;
                ++i;
                continue;
            }
            if ("--dbUser".equals(arg)) {
                this.dbUser = argNext;
                ++i;
                continue;
            }
            if ("--dbPassword".equals(arg)) {
                this.dbPassword = argNext;
                ++i;
                continue;
            }
            if ("--dbTable".equals(arg)) {
                this.dbTable = argNext;
                ++i;
                continue;
            }
            if ("--dbColDetector".equals(arg)) {
                this.dbColDetector = argNext;
                ++i;
                continue;
            }
            if ("--dbColAmount".equals(arg)) {
                this.dbColAmount = argNext;
                ++i;
                continue;
            }
            if ("--dbColTime".equals(arg)) {
                this.dbColTime = argNext;
                ++i;
                continue;
            }
            if ("--timeFrom".equals(arg)) {
                this.timeFrom = argNext;
                ++i;
                continue;
            }
            if ("--timeTo".equals(arg)) {
                this.timeTo = argNext;
                ++i;
                continue;
            }
            if ("--output".equals(arg)) {
                if ("mathematica".equals(argNext)) {
                    OutputManager.getInstance().setMathematicaOnly(true);
                    ++i;
                    continue;
                }
                if ("all".equals(argNext)) {
                    OutputManager.getInstance().setMathematicaOnly(false);
                    ++i;
                    continue;
                }
                throw new Exception("Cannot parse value for parameter: " + arg);
            }
            if ("--svm".equals(arg)) {
                if ("epsilon".equals(argNext)) {
                    this.svmType = 3;
                    ++i;
                    continue;
                }
                if ("nu".equals(argNext)) {
                    this.svmType = 4;
                    ++i;
                    continue;
                }
                throw new Exception("Cannot parse value for parameter: " + arg);
            }
            if ("--kernel".equals(arg)) {
                if ("rbf".equals(argNext)) {
                    this.kernelType = 2;
                    ++i;
                    continue;
                }
                if ("poly".equals(argNext)) {
                    this.kernelType = 1;
                    ++i;
                    continue;
                }
                if ("linear".equals(argNext)) {
                    this.kernelType = 0;
                    ++i;
                    continue;
                }
                throw new Exception("Cannot parse value for parameter: " + arg);
            }
            if ("--polyDegree".equals(arg)) {
                try {
                    this.polyDegree = Integer.parseInt(argNext);
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Cannot parse value for parameter: " + arg, e);
                }
            }
            if ("--detectorType".equals(arg)) {
                if ("tollgate".equals(argNext)) {
                    this.detectorType = 1;
                    ++i;
                    continue;
                }
                if ("asim".equals(argNext)) {
                    this.detectorType = 0;
                    ++i;
                    continue;
                }
                if ("other".equals(argNext)) {
                    this.detectorType = 2;
                    ++i;
                    continue;
                }
                throw new Exception("Cannot parse value for parameter: " + arg);
            }
            if ("--columnType".equals(arg)) {
                if ("cat1".equals(argNext)) {
                    this.columnType = 1;
                    ++i;
                    continue;
                }
                if ("cat2".equals(argNext)) {
                    this.columnType = 2;
                    ++i;
                    continue;
                }
                if ("cat3".equals(argNext)) {
                    this.columnType = 3;
                    ++i;
                    continue;
                }
                if ("cat4".equals(argNext)) {
                    this.columnType = 4;
                    ++i;
                    continue;
                }
                if ("cat5".equals(argNext)) {
                    this.columnType = 5;
                    ++i;
                    continue;
                }
                if ("cat6".equals(argNext)) {
                    this.columnType = 6;
                    ++i;
                    continue;
                }
                if ("axes2".equals(argNext)) {
                    this.columnType = 2;
                    ++i;
                    continue;
                }
                if ("axes3".equals(argNext)) {
                    this.columnType = 3;
                    ++i;
                    continue;
                }
                if ("axes4".equals(argNext)) {
                    this.columnType = 4;
                    ++i;
                    continue;
                }
                throw new Exception("Cannot parse value for parameter: " + arg);
            }
            if ("--predict".equals(arg)) {
                try {
                    this.predictDetector = Integer.parseInt(argNext);
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Cannot parse value for parameter: " + arg, e);
                }
            }
            if ("--detectors".equals(arg)) {
                String[] ids = argNext.split(",");
                this.allDetectors = new int[ids.length];
                try {
                    for (int j = 0; j < ids.length; ++j) {
                        this.allDetectors[j] = Integer.parseInt(ids[i]);
                    }
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Cannot parse value for parameter: " + arg, e);
                }
            }
            throw new Exception("Unknown program parameter: " + arg);
        }
        if (this.dbTable == null) {
            this.dbTable = "unknown_table";
        } else if (this.dbColDetector == null) {
            this.dbColDetector = "gid";
        } else if (this.dbColAmount == null) {
            this.dbColAmount = "amount";
        } else if (this.dbColTime == null) {
            this.dbColTime = "time";
        }
        if (this.modelFile == null) {
            this.modelFile = "svm.model";
        }
        if (this.timeFrom == null) {
            this.timeFrom = "0000-00-00";
        }
        if (this.timeTo == null) {
            this.timeTo = "0000-00-00";
        }
        if (this.svmType == -1) {
            this.svmType = 3;
        }
        if (this.kernelType == -1) {
            this.kernelType = 0;
        }
        if (this.polyDegree == -1) {
            this.polyDegree = 3;
        }
        if (this.detectorType == -1) {
            this.detectorType = 1;
        }
        if (this.columnType == -1) {
            this.columnType = this.detectorType == 1 ? 2 : 2;
        }
        if (this.predictDetector == -1) {
            this.predictDetector = this.detectorType == 1 ? 571 : 79;
        }
        if (this.allDetectors == null) {
            if (this.detectorType == 0) {
                this.allDetectors = new int[]{79, 80, 81, 82, 83, 84, 85, 86, 165, 166, 167, 168};
            } else if (this.detectorType == 1) {
                this.allDetectors = new int[]{537, 536, 284, 285, 311, 571};
            } else {
                throw new Exception("No detectors selected.");
            }
        }
    }

    public void printHelp() {
        String help = "--help\n    Will print this help.\n    \n--train\n    Will train SVM model.\n    \n--predict\n    Will predict detector data.\n    \n--modelFile <path>\n    Where to load from / save to model file.\n    Default value is 'svm.model'.\n    \n--dbHost <host>\n    Database host.nDefault value 'localhost'.\n    \n--dbPort <port>\n    Database port.\n    Default value is default port.\n    \n--db <name>\n    Database name.\n    \n--dbUser <user>\n    Database user. Default value 'root'.\n    \n--dbPassword <password>\n    Database password. Empty be default.\n    \n--dbTable <table name>\n    Custom database table.\n    Use if your table is not predefined Asim / Tollgate table.\n    \n--dbColDetector <column name>\n    Custom column containing detector ID.\n    Use if your table is not predefined Asim / Tollgate table.\n    \n--dbColAmount <column name>\n    Custom column containing amount of vehicles.\n    Use if your table is not predefined Asim / Tollgate table.\n    \n--dbColTime <column name>\n    Custom column containg time of last row update.\n    Use if your table is not predefined Asim / Tollgate table.\n    \n--timeFrom <datetime>\n    Interval star time in SQL format.\n    \n--timeTo <datetime>\n    Interval end time in SQL format.\n    \n--output <type>\n    all -> Write everything to the output (default).\n    mathematica -> Write only data for Wolfram Mathematica to the output.\n                   Format: {{y, y_predicted}, ...}\n    \n--svm <type>\n    epsilon / nu\n    \n--kernel <type>\n    rbf / poly / linear\n    \n--polyDegree <degree>\n    Polynomial degree for poly kernel.\n    \n--detectorType <type>\n    asim / tollgate / other\n    \n--columnType <type>\n    asim: cat1 / cat2 / cat3 / cat4 / cat5 / cat6\n    tollgate: axes2 / axes3 / axes4\n    other: (use --dbColXxx to define columns)\n    \n--predict <id>\n    ID of the detector for which the training / predicting is done.\n    \n--detectors <id,id,id,...>\n    IDs of all detectors contained in the model.\n    Separated with ',' without spaces.\n    \n";
    }
}

