/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.util.iterators.FilterIterator;

@Deprecated
public class GraphImpl
extends AbstractCollection<Statement>
implements Graph {
    private static final long serialVersionUID = -5307095904382050478L;
    protected LinkedList<Statement> statements = new LinkedList();
    protected transient ValueFactory valueFactory;

    public GraphImpl(ValueFactory valueFactory) {
        this.setValueFactory(valueFactory);
    }

    public GraphImpl() {
        this(SimpleValueFactory.getInstance());
    }

    public GraphImpl(ValueFactory valueFactory, Collection<? extends Statement> statements) {
        this(valueFactory);
        this.addAll(statements);
    }

    public GraphImpl(Collection<? extends Statement> statements) {
        this(SimpleValueFactory.getInstance(), statements);
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public boolean add(Statement st) {
        return this.statements.add(st);
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean graphChanged = false;
        if (contexts.length == 0) {
            graphChanged = this.add(this.valueFactory.createStatement(subj, pred, obj));
        } else {
            for (Resource context : contexts) {
                graphChanged |= this.add(this.valueFactory.createStatement(subj, pred, obj, context));
            }
        }
        return graphChanged;
    }

    @Override
    public Iterator<Statement> match(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        return new PatternIterator(this.iterator(), subj, pred, obj, contexts);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setValueFactory(SimpleValueFactory.getInstance());
    }

    private static class PatternIterator
    extends FilterIterator<Statement> {
        private Resource subj;
        private IRI pred;
        private Value obj;
        private Resource[] contexts;

        public PatternIterator(Iterator<? extends Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
            super(iter);
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.contexts = contexts;
        }

        @Override
        protected boolean accept(Statement st) {
            if (this.subj != null && !this.subj.equals(st.getSubject())) {
                return false;
            }
            if (this.pred != null && !this.pred.equals(st.getPredicate())) {
                return false;
            }
            if (this.obj != null && !this.obj.equals(st.getObject())) {
                return false;
            }
            if (this.contexts.length == 0) {
                return true;
            }
            Resource stContext = st.getContext();
            for (Resource context : this.contexts) {
                if (context == null && stContext == null) {
                    return true;
                }
                if (context == null || !context.equals(stContext)) continue;
                return true;
            }
            return false;
        }
    }
}

