/*
 * Decompiled with CFR 0.152.
 */
package io.github.radkovo.rdf4j.vocab;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import io.github.radkovo.rdf4j.vocab.GenerationException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.rdf4j.common.io.MavenUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VocabBuilder {
    private static final Logger log = LoggerFactory.getLogger(VocabBuilder.class);
    protected static final IRI[] COMMENT_PROPERTIES = new IRI[]{RDFS.COMMENT, DCTERMS.DESCRIPTION, SKOS.DEFINITION, DC.DESCRIPTION};
    protected static final IRI[] LABEL_PROPERTIES = new IRI[]{RDFS.LABEL, DCTERMS.TITLE, DC.TITLE, SKOS.PREF_LABEL, SKOS.ALT_LABEL};
    private String name = null;
    private String prefix = null;
    private String packageName = null;
    private String indent = "\t";
    private String language = null;
    private final Model model;
    private CaseFormat caseFormat = null;
    private CaseFormat stringCaseFormat = null;
    private String stringPropertyPrefix;
    private String stringPropertySuffix;
    private Set<String> createdFields = new HashSet<String>();
    private static Set<String> reservedWords = Sets.newHashSet("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "continue", "PREFIX", "NAMESPACE");

    public VocabBuilder(String filename, String format) throws IOException, RDFParseException {
        this(filename, format != null ? (RDFFormat)Rio.getParserFormatForMIMEType(format).orElse(null) : null);
    }

    public VocabBuilder(String filename, RDFFormat format) throws IOException, RDFParseException {
        Path file = Paths.get(filename, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(filename);
        }
        if (format == null) {
            format = Rio.getParserFormatForFileName(filename).orElse(null);
            log.trace("detected input format from filename {}: {}", (Object)filename, (Object)format);
        }
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            log.trace("Loading input file");
            this.model = Rio.parse(inputStream, "", format, new Resource[0]);
        }
        Set<Resource> owlOntologies = this.model.filter(null, RDF.TYPE, (Value)OWL.ONTOLOGY, new Resource[0]).subjects();
        if (!owlOntologies.isEmpty()) {
            this.setPrefix(owlOntologies.iterator().next().stringValue());
        }
    }

    public void generate(OutputStream outputStream) throws GenerationException, IOException {
        String cName = this.getName();
        if (StringUtils.isBlank(cName)) {
            throw new GenerationException("could not detect name, please set explicitly");
        }
        cName = WordUtils.capitalize(cName.replaceAll("\\W+", " ")).replaceAll("\\s+", "");
        this.generate(cName, new PrintWriter(outputStream));
    }

    public void generate(Path output) throws IOException, GenerationException {
        String className = output.getFileName().toString().replaceFirst("\\.java$", "");
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]));){
            this.generate(className, out);
        }
    }

    public void generate(String className, PrintWriter out) throws IOException, GenerationException {
        String nextKey;
        Literal label;
        Literal comment;
        log.trace("classname: {}", (Object)className);
        if (StringUtils.isBlank(this.name)) {
            this.name = className;
        }
        if (StringUtils.isBlank(this.prefix)) {
            throw new GenerationException("could not detect prefix, please set explicitly");
        }
        log.debug("prefix: {}", (Object)this.prefix);
        Pattern pattern = Pattern.compile(Pattern.quote(this.getPrefix()) + "(.+)");
        ConcurrentHashMap<String, IRI> splitUris = new ConcurrentHashMap<String, IRI>();
        for (Resource nextSubject : this.model.subjects()) {
            String k;
            Object putIfAbsent;
            Matcher matcher;
            if (!(nextSubject instanceof IRI) || !(matcher = pattern.matcher(nextSubject.stringValue())).find() || (putIfAbsent = splitUris.putIfAbsent(k = matcher.group(1), (IRI)nextSubject)) == null) continue;
            log.warn("Conflicting keys found: uri={} key={} existing={}", nextSubject.stringValue(), k, putIfAbsent);
        }
        if (StringUtils.isNotBlank(this.packageName)) {
            out.printf("package %s;%n%n", this.getPackageName());
        }
        out.println("import org.eclipse.rdf4j.model.IRI;");
        out.println("import org.eclipse.rdf4j.model.ValueFactory;");
        out.println("import org.eclipse.rdf4j.model.impl.SimpleValueFactory;");
        out.println();
        IRI pfx = SimpleValueFactory.getInstance().createIRI(this.prefix);
        Literal oTitle = this.getFirstExistingObjectLiteral(this.model, pfx, this.getPreferredLanguage(), LABEL_PROPERTIES);
        Literal oDescr = this.getFirstExistingObjectLiteral(this.model, pfx, this.getPreferredLanguage(), COMMENT_PROPERTIES);
        Set<Value> oSeeAlso = this.model.filter((Resource)pfx, RDFS.SEEALSO, null, new Resource[0]).objects();
        out.println("/**");
        if (oTitle != null) {
            out.printf(" * %s.%n", WordUtils.wrap(oTitle.getLabel().replaceAll("\\s+", " "), 70, "\n * ", false));
            out.println(" * <p>");
        }
        if (oDescr != null) {
            out.printf(" * %s.%n", WordUtils.wrap(oDescr.getLabel().replaceAll("\\s+", " "), 70, "\n * ", false));
            out.println(" * <p>");
        }
        out.printf(" * Namespace %s.%n", this.name);
        out.printf(" * Prefix: {@code <%s>}%n", this.prefix);
        if (!oSeeAlso.isEmpty()) {
            out.println(" *");
            for (Value s : oSeeAlso) {
                if (!(s instanceof IRI)) continue;
                out.printf(" * @see <a href=\"%s\">%s</a>%n", s.stringValue(), s.stringValue());
            }
        }
        out.println(" */");
        out.printf("public class %s {%n", className);
        out.println();
        out.printf(this.getIndent(1) + "/** {@code %s} **/%n", this.prefix);
        out.printf(this.getIndent(1) + "public static final String NAMESPACE = \"%s\";%n", this.prefix);
        out.println();
        out.printf(this.getIndent(1) + "/** {@code %s} **/%n", this.name.toLowerCase());
        out.printf(this.getIndent(1) + "public static final String PREFIX = \"%s\";%n", this.name.toLowerCase());
        out.println();
        ArrayList keys = new ArrayList();
        keys.addAll(splitUris.keySet());
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        if (this.getStringCaseFormat() != null || StringUtils.isNotBlank(this.stringPropertyPrefix) || StringUtils.isNotBlank(this.stringPropertySuffix)) {
            for (String key : keys) {
                comment = this.getFirstExistingObjectLiteral(this.model, (Resource)splitUris.get(key), this.getPreferredLanguage(), COMMENT_PROPERTIES);
                label = this.getFirstExistingObjectLiteral(this.model, (Resource)splitUris.get(key), this.getPreferredLanguage(), LABEL_PROPERTIES);
                out.println(this.getIndent(1) + "/**");
                if (label != null) {
                    out.printf(this.getIndent(1) + " * %s%n", label.getLabel());
                    out.println(this.getIndent(1) + " * <p>");
                }
                out.printf(this.getIndent(1) + " * {@code %s}.%n", ((IRI)splitUris.get(key)).stringValue());
                if (comment != null) {
                    out.println(this.getIndent(1) + " * <p>");
                    out.printf(this.getIndent(1) + " * %s%n", WordUtils.wrap(comment.getLabel().replaceAll("\\s+", " "), 70, "\n" + this.getIndent(1) + " * ", false));
                }
                out.println(this.getIndent(1) + " *");
                out.printf(this.getIndent(1) + " * @see <a href=\"%s\">%s</a>%n", splitUris.get(key), key);
                out.println(this.getIndent(1) + " */");
                nextKey = this.cleanKey(String.format("%s%s%s", StringUtils.defaultString(this.getStringPropertyPrefix()), this.doCaseFormatting(key, this.getStringConstantCase()), StringUtils.defaultString(this.getStringPropertySuffix())));
                this.checkField(className, nextKey);
                out.printf(this.getIndent(1) + "public static final String %s = %s.NAMESPACE + \"%s\";%n", nextKey, className, key);
                out.println();
            }
        }
        for (String key : keys) {
            comment = this.getFirstExistingObjectLiteral(this.model, (Resource)splitUris.get(key), this.getPreferredLanguage(), COMMENT_PROPERTIES);
            label = this.getFirstExistingObjectLiteral(this.model, (Resource)splitUris.get(key), this.getPreferredLanguage(), LABEL_PROPERTIES);
            out.println(this.getIndent(1) + "/**");
            if (label != null) {
                out.printf(this.getIndent(1) + " * %s%n", label.getLabel());
                out.println(this.getIndent(1) + " * <p>");
            }
            out.printf(this.getIndent(1) + " * {@code %s}.%n", ((IRI)splitUris.get(key)).stringValue());
            if (comment != null) {
                out.println(this.getIndent(1) + " * <p>");
                out.printf(this.getIndent(1) + " * %s%n", WordUtils.wrap(comment.getLabel().replaceAll("\\s+", " "), 70, "\n" + this.getIndent(1) + " * ", false));
            }
            out.println(this.getIndent(1) + " *");
            out.printf(this.getIndent(1) + " * @see <a href=\"%s\">%s</a>%n", splitUris.get(key), key);
            out.println(this.getIndent(1) + " */");
            nextKey = this.cleanKey(this.doCaseFormatting(key, this.getConstantCase()));
            this.checkField(className, nextKey);
            out.printf(this.getIndent(1) + "public static final IRI %s;%n", nextKey);
            out.println();
        }
        out.println(this.getIndent(1) + "static {");
        out.printf(this.getIndent(2) + "ValueFactory factory = SimpleValueFactory.getInstance();%n", new Object[0]);
        out.println();
        for (String key : keys) {
            String nextKey2 = this.cleanKey(this.doCaseFormatting(key, this.getConstantCase()));
            out.printf(this.getIndent(2) + "%s = factory.createIRI(%s.NAMESPACE, \"%s\");%n", nextKey2, className, key);
        }
        out.println(this.getIndent(1) + "}");
        out.println();
        out.printf(this.getIndent(1) + "private %s() {%n", className);
        out.println(this.getIndent(2) + "//static access only");
        out.println(this.getIndent(1) + "}");
        out.println();
        out.println("}");
        out.flush();
    }

    protected void checkField(String className, String fieldName) throws GenerationException {
        if (!this.createdFields.add(fieldName)) {
            throw new GenerationException(String.format("field %s.%s is defined twice", className, fieldName));
        }
    }

    public void generateResourceBundle(String baseName, Path bundleDir) throws GenerationException, IOException {
        HashMap<String, Properties> bundles = this.generateResourceBundle(baseName);
        for (String bKey : bundles.keySet()) {
            Properties bundle = bundles.get(bKey);
            Path file = bundleDir.resolve(bKey + ".properties");
            try {
                BufferedWriter w = Files.newBufferedWriter(file, Charset.forName("utf8"), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    bundle.store(w, String.format("ResourceBundle (%s) for %s, generated by %s v%s", bKey, baseName, "com.github.tkurz.sesame:vocab-builder", MavenUtil.loadVersion("com.github.tkurz.sesame", "vocab-builder", "0.0.0-DEVELOP")));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (w == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)w).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)w).close();
                }
            }
            catch (IOException e) {
                log.error("Could not write Bundle {} to {}: {}", bKey, file, e);
                throw e;
            }
        }
    }

    public HashMap<String, Properties> generateResourceBundle(String baseName) throws GenerationException {
        Pattern pattern = Pattern.compile(Pattern.quote(this.getPrefix()) + "(.+)");
        HashMap<String, IRI> splitUris = new HashMap<String, IRI>();
        for (Resource nextSubject : this.model.subjects()) {
            Object matcher;
            if (!(nextSubject instanceof IRI) || !((Matcher)(matcher = pattern.matcher(nextSubject.stringValue()))).find()) continue;
            String k = ((Matcher)matcher).group(1);
            splitUris.put(k, (IRI)nextSubject);
        }
        ArrayList keys = new ArrayList();
        keys.addAll(splitUris.keySet());
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        HashMap<String, Properties> bundles = new HashMap<String, Properties>();
        bundles.put(baseName, new Properties());
        for (String key : keys) {
            Properties bundle;
            String lang;
            Literal lit;
            IRI resource = (IRI)splitUris.get(key);
            String nextKey = this.cleanKey(this.doCaseFormatting(key, this.getConstantCase()));
            for (IRI p : LABEL_PROPERTIES) {
                for (Value v : this.model.filter((Resource)resource, p, null, new Resource[0]).objects()) {
                    if (!(v instanceof Literal)) continue;
                    lit = (Literal)v;
                    lang = lit.getLanguage().orElse(null);
                    if (lang == null) {
                        bundle = bundles.get(baseName);
                    } else if (bundles.containsKey(baseName + "_" + lang)) {
                        bundle = bundles.get(baseName + "_" + lang);
                    } else {
                        bundle = new Properties();
                        bundles.put(baseName + "_" + lang, bundle);
                    }
                    if (bundle.containsKey(nextKey + ".label")) continue;
                    bundle.put(nextKey + ".label", lit.getLabel().replaceAll("\\s+", " "));
                }
            }
            for (IRI p : COMMENT_PROPERTIES) {
                for (Value v : this.model.filter((Resource)resource, p, null, new Resource[0]).objects()) {
                    if (!(v instanceof Literal)) continue;
                    lit = (Literal)v;
                    lang = lit.getLanguage().orElse(null);
                    if (lang == null) {
                        bundle = bundles.get(baseName);
                    } else if (bundles.containsKey(baseName + "_" + lang)) {
                        bundle = bundles.get(baseName + "_" + lang);
                    } else {
                        bundle = new Properties();
                        bundles.put(baseName + "_" + lang, bundle);
                    }
                    if (bundle.containsKey(nextKey + ".comment")) continue;
                    bundle.put(nextKey + ".comment", lit.getLabel().replaceAll("\\s+", " "));
                }
            }
        }
        if (this.getPreferredLanguage() != null) {
            log.debug("completing default Bundle with preferred language {}", (Object)this.getPreferredLanguage());
            Properties defaultBundle = bundles.get(baseName);
            Properties prefBundle = bundles.get(baseName + "_" + this.getPreferredLanguage());
            if (prefBundle != null) {
                for (Map.Entry<Object, Object> key : prefBundle.entrySet()) {
                    String nextKey = (String)key.getKey();
                    if (defaultBundle.containsKey(nextKey)) continue;
                    log.trace("copying {} from {} to default Bundle", (Object)nextKey, (Object)this.getPreferredLanguage());
                    defaultBundle.setProperty(nextKey, (String)key.getValue());
                }
            } else {
                log.warn("No Bundle data found for preferred language {}", (Object)this.getPreferredLanguage());
            }
        }
        return bundles;
    }

    protected String getIndent(int level) {
        return StringUtils.repeat(this.getIndent(), level);
    }

    protected Literal getFirstExistingObjectLiteral(Model model, Resource subject, String lang, IRI ... predicates) {
        for (IRI predicate : predicates) {
            Literal literal = this.getOptionalObjectLiteral(model, subject, predicate, lang);
            if (literal == null) continue;
            return literal;
        }
        return null;
    }

    private Literal getOptionalObjectLiteral(Model model, Resource subject, IRI predicate, String lang) {
        Set<Value> objects = model.filter(subject, predicate, null, new Resource[0]).objects();
        Literal result = null;
        for (Value nextValue : objects) {
            if (!(nextValue instanceof Literal)) continue;
            Literal literal = (Literal)nextValue;
            if (result != null && (lang == null || !lang.equals(literal.getLanguage().orElse(null)))) continue;
            result = literal;
        }
        return result;
    }

    protected String cleanKey(String s) {
        s = s.replaceAll("#", "");
        s = s.replaceAll("\\.", "_");
        if (reservedWords.contains(s = s.replaceAll("-", "_"))) {
            s = "_" + s;
        }
        return s;
    }

    protected String doCaseFormatting(String key, CaseFormat targetFormat) {
        if (targetFormat == null) {
            return key;
        }
        CaseFormat originalFormat = CaseFormat.LOWER_CAMEL;
        if (Character.isUpperCase(key.charAt(0)) && key.contains("_")) {
            originalFormat = CaseFormat.UPPER_UNDERSCORE;
        } else if (Character.isUpperCase(key.charAt(0))) {
            originalFormat = CaseFormat.UPPER_CAMEL;
        } else if (key.contains("_")) {
            originalFormat = CaseFormat.LOWER_UNDERSCORE;
        } else if (key.contains("-")) {
            originalFormat = CaseFormat.LOWER_HYPHEN;
        }
        return originalFormat.to(targetFormat, key);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setPreferredLanguage(String language) {
        this.language = language;
    }

    public String getPreferredLanguage() {
        return this.language;
    }

    public void setConstantCase(CaseFormat caseFormat) {
        this.caseFormat = caseFormat;
    }

    public CaseFormat getConstantCase() {
        return this.caseFormat;
    }

    public CaseFormat getStringConstantCase() {
        return this.getStringCaseFormat();
    }

    public void setStringConstantCase(CaseFormat stringCaseFormat) {
        this.setStringCaseFormat(stringCaseFormat);
    }

    public String getStringPropertyPrefix() {
        return this.stringPropertyPrefix;
    }

    public void setStringPropertyPrefix(String stringPropertyPrefix) {
        this.stringPropertyPrefix = stringPropertyPrefix;
    }

    public String getStringPropertySuffix() {
        return this.stringPropertySuffix;
    }

    public void setStringPropertySuffix(String stringPropertySuffix) {
        this.stringPropertySuffix = stringPropertySuffix;
    }

    protected Model getModel() {
        return this.model;
    }

    public CaseFormat getStringCaseFormat() {
        return this.stringCaseFormat;
    }

    public void setStringCaseFormat(CaseFormat stringCaseFormat) {
        this.stringCaseFormat = stringCaseFormat;
    }
}

