/*
 * Decompiled with CFR 0.152.
 */
package io.github.radkovo.rdf4j.builder;

import io.github.radkovo.rdf4j.builder.ClassBuilder;
import io.github.radkovo.rdf4j.vocab.GenerationException;
import io.github.radkovo.rdf4j.vocab.VocabBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;

public class Main {
    public static void main(String[] args) {
        try {
            String filename;
            PosixParser parser = new PosixParser();
            CommandLine cli = parser.parse(Main.getCliOpts(), args);
            if (cli.hasOption('h')) {
                Main.printHelp();
                return;
            }
            String[] cliArgs = cli.getArgs();
            switch (cliArgs.length) {
                case 0: {
                    throw new ParseException("Missing input file");
                }
                case 1: {
                    filename = cliArgs[0];
                    break;
                }
                default: {
                    throw new ParseException("too many arguments");
                }
            }
            String cwd = System.getProperty("user.dir");
            RDFFormat format = Rio.getParserFormatForMIMEType(cli.getOptionValue('f', null)).orElse(null);
            String vocabName = cli.getOptionValue('v');
            String vocabDir = cli.hasOption('o') ? cli.getOptionValue('o') : cwd;
            String vocabPackage = cli.hasOption('p') ? cli.getOptionValue('p') : "";
            String classDir = cli.hasOption('O') ? cli.getOptionValue('O') : vocabDir;
            String classPackage = cli.hasOption('P') ? cli.getOptionValue('P') : vocabPackage;
            Main.generateFromOWL(filename, format, vocabName, vocabDir, vocabPackage, classDir, classPackage);
        }
        catch (MissingOptionException e) {
            Main.printHelp("Missing option: " + e.getMessage());
        }
        catch (ParseException e) {
            Main.printHelp(e.getMessage());
        }
        catch (IOException e) {
            System.err.println("I/O exception: " + e.getMessage());
        }
        catch (GenerationException e) {
            e.printStackTrace();
        }
    }

    private static void generateFromOWL(String filename, RDFFormat format, String vocabName, String vocabDir, String vocabPackage, String classDir, String classPackage) throws IOException, GenerationException {
        VocabBuilder vb = new VocabBuilder(filename, format);
        vb.setPackageName(vocabPackage);
        vb.generate(Paths.get(vocabDir, vocabName + ".java"));
        ClassBuilder cb = new ClassBuilder(filename, format);
        cb.setPackageName(classPackage);
        cb.setVocabPackageName(vocabPackage);
        cb.setVocabName(vocabName);
        cb.generate(classDir);
    }

    private static void printHelp() {
        Main.printHelp(null);
    }

    private static void printHelp(String error) {
        HelpFormatter hf = new HelpFormatter();
        PrintWriter w = new PrintWriter(System.out);
        if (error != null) {
            hf.printWrapped(w, 80, error);
            w.println();
        }
        hf.printWrapped(w, 80, 12, "Usage: ClassBuilder [options...] <input-file>");
        hf.printWrapped(w, 80, 42, "  <input-file>                  the input file to read from");
        hf.printOptions(w, 80, Main.getCliOpts(), 2, 2);
        w.flush();
        w.close();
    }

    private static Options getCliOpts() {
        Options o = new Options();
        OptionBuilder.withLongOpt("format");
        OptionBuilder.withDescription("mime-type of the input file (will try to guess if absent)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("format");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('f'));
        OptionBuilder.withLongOpt("vocab-name");
        OptionBuilder.withDescription("vocabulary class name");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("class-name");
        OptionBuilder.isRequired(true);
        o.addOption(OptionBuilder.create('v'));
        OptionBuilder.withLongOpt("vocab-package");
        OptionBuilder.withDescription("vocabulary package declaration (will use default (empty) package if absent)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("package");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('p'));
        OptionBuilder.withLongOpt("class-package");
        OptionBuilder.withDescription("class package declaration (will use the vocabulary package if absent)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("package");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('P'));
        OptionBuilder.withLongOpt("vocab-dir");
        OptionBuilder.withDescription("the output directory for the vocabulary (current directory when absent)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("path");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('o'));
        OptionBuilder.withLongOpt("class-dir");
        OptionBuilder.withDescription("the output directory for the classes (vocabulary directory when absent)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("path");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('O'));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("print this help");
        OptionBuilder.isRequired(false);
        OptionBuilder.hasArg(false);
        o.addOption(OptionBuilder.create('h'));
        return o;
    }
}

