/*
 * Decompiled with CFR 0.152.
 */
package io.github.radkovo.rdf4j.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.atteo.evo.inflector.English;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClassBuilder.class);
    private static final String DEFAULT_SUPERCLASS = "com.github.radkovo.rdf4j.builder.RDFEntity";
    private static final IRI[] COMMENT_PROPERTIES = new IRI[]{RDFS.COMMENT, DCTERMS.DESCRIPTION, SKOS.DEFINITION, DC.DESCRIPTION};
    private static final IRI[] LABEL_PROPERTIES = new IRI[]{RDFS.LABEL, DCTERMS.TITLE, DC.TITLE, SKOS.PREF_LABEL, SKOS.ALT_LABEL};
    private static final IRI[] PROPERTY_PROPERTIES = new IRI[]{RDF.PROPERTY, OWL.DATATYPEPROPERTY, OWL.OBJECTPROPERTY};
    private static final Set<IRI> classPredicates = new HashSet<IRI>();
    private static final Map<IRI, String> dataTypes;
    private String packageName = null;
    private String vocabPackageName = null;
    private String vocabName = null;
    private String indent = "\t";
    private String language = null;
    private final Model model;

    public ClassBuilder(String filename, String format) throws IOException, RDFParseException {
        this(filename, format != null ? (RDFFormat)Rio.getParserFormatForMIMEType(format).orElse(null) : null);
    }

    public ClassBuilder(String filename, RDFFormat format) throws IOException, RDFParseException {
        Path file = Paths.get(filename, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException(filename);
        }
        if (format == null) {
            format = Rio.getParserFormatForFileName(filename).orElse(null);
            log.trace("detected input format from filename {}: {}", (Object)filename, (Object)format);
        }
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            log.trace("Loading input file");
            this.model = Rio.parse(inputStream, "", format, new Resource[0]);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVocabPackageName() {
        return this.vocabPackageName;
    }

    public void setVocabPackageName(String vocabPackageName) {
        this.vocabPackageName = vocabPackageName;
    }

    public String getVocabName() {
        return this.vocabName;
    }

    public void setVocabName(String vocabName) {
        this.vocabName = vocabName;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getPreferredLanguage() {
        return this.language;
    }

    public void setPreferredLanguage(String language) {
        this.language = language;
    }

    public void generate(String outputDirName) throws IOException {
        Path outputDir = Paths.get(outputDirName, new String[0]);
        this.generate(outputDir);
    }

    public void generate(Path outputDir) throws IOException {
        if (!Files.isDirectory(outputDir, new LinkOption[0])) {
            throw new FileNotFoundException(outputDir.toString());
        }
        Set<Resource> classes = this.findClasses();
        log.info("Found clases: {}", (Object)classes);
        for (Resource cres : classes) {
            if (cres instanceof IRI) {
                this.generateClass((IRI)cres, outputDir);
                continue;
            }
            log.warn("Skipping resource {} -- not an IRI", (Object)cres);
        }
        this.generateFactory(classes, outputDir);
    }

    public void generateFactory(Set<Resource> classes, Path outputDir) throws IOException {
        String fname = this.getFactoryName();
        File outfile = new File(outputDir.toFile(), fname + ".java");
        PrintWriter out = new PrintWriter(outfile);
        this.generateFactory(classes, fname, out);
        out.close();
    }

    public void generateFactory(Set<Resource> classes, String fname, PrintWriter out) {
        log.info("Generating factory interface {}", (Object)fname);
        if (this.getPackageName() != null) {
            out.printf("package %s;\n\n", this.getPackageName());
        }
        out.println("import org.eclipse.rdf4j.model.IRI;");
        out.println("import com.github.radkovo.rdf4j.builder.EntityFactory;");
        out.println();
        out.printf("public interface %s extends EntityFactory{\n", fname);
        for (Resource cres : classes) {
            if (!(cres instanceof IRI)) continue;
            String cname = this.getClassName((IRI)cres);
            out.printf(this.getIndent(1) + "public %s create%s(IRI iri);\n", cname, cname);
        }
        out.println("}");
    }

    private String getFactoryName() {
        return this.getVocabName() + "Factory";
    }

    public void generateClass(IRI cres, Path outputDir) throws IOException {
        String className = this.getClassName(cres);
        File outfile = new File(outputDir.toFile(), className + ".java");
        PrintWriter out = new PrintWriter(outfile);
        this.generateClass(cres, className, out);
        out.close();
    }

    public void generateClass(IRI iri, String className, PrintWriter out) {
        log.info("Generating {}", (Object)className);
        Set<IRI> properties = this.findClassProperties(iri);
        Set<IRI> revProperties = this.findClassProperties(iri, RDFS.RANGE);
        log.debug("   properties: {}", (Object)properties);
        boolean somePropertiesNotFunctional = false;
        boolean someCollections = false;
        boolean someObjects = false;
        for (IRI piri : properties) {
            if (!this.isFunctionalProperty(piri)) {
                somePropertiesNotFunctional = true;
            }
            if (this.getPropertyClassification(piri).equals("Object")) {
                someObjects = true;
            }
            if (!this.getPropertyClassification(piri).equals("Collection")) continue;
            someCollections = true;
        }
        for (IRI piri : revProperties) {
            if (!this.isObjectOrCollectionProperty(piri) || this.isInverseFunctionalProperty(piri)) continue;
            someCollections = true;
        }
        if (this.getPackageName() != null) {
            out.printf("package %s;\n\n", this.getPackageName());
        }
        if (somePropertiesNotFunctional || someCollections || someObjects) {
            out.println("import java.util.Set;");
        }
        if (someCollections) {
            out.println("import java.util.HashSet;");
        }
        out.println("import org.eclipse.rdf4j.model.IRI;");
        out.println("import org.eclipse.rdf4j.model.Model;");
        out.println("import com.github.radkovo.rdf4j.builder.EntityFactory;");
        out.println("import com.github.radkovo.rdf4j.builder.TargetModel;");
        if (this.getVocabPackageName() != null && this.getVocabName() != null) {
            out.printf("import %s.%s;\n", this.getVocabPackageName(), this.getVocabName());
        }
        out.println();
        this.generateJavadoc(iri, out, 0);
        boolean derived = false;
        String superClass = DEFAULT_SUPERCLASS;
        IRI superClassIRI = this.getOptionalObjectIRI(this.model, iri, RDFS.SUBCLASSOF);
        if (superClassIRI != null) {
            derived = true;
            superClass = this.getClassName(superClassIRI);
        }
        out.printf("public class %s extends %s\n", className, superClass);
        out.println("{");
        out.printf(this.getIndent(1) + "public static final IRI CLASS_IRI = vf.createIRI(\"%s\");\n\n", iri);
        for (IRI piri : properties) {
            this.generatePropertyDeclaration(piri, this.getPropertyName(piri), out);
        }
        for (IRI piri : revProperties) {
            if (!this.isObjectOrCollectionProperty(piri) || this.isInverseFunctionalProperty(piri)) continue;
            this.generateReverseCollectionDeclaration(piri, this.getPropertyName(piri), this.getPropertySourceType(piri), out);
        }
        out.println();
        this.generateConstructors(className, properties, revProperties, out);
        out.println();
        this.generateDefaultMethods(className, out);
        out.println();
        for (IRI piri : properties) {
            this.generatePropertyGetter(piri, this.getPropertyName(piri), out);
            out.println();
            if (!this.isFunctionalProperty(piri)) continue;
            this.generatePropertySetter(piri, this.getPropertyName(piri), out);
            out.println();
        }
        for (IRI piri : revProperties) {
            if (!this.isObjectOrCollectionProperty(piri) || this.isInverseFunctionalProperty(piri)) continue;
            this.generateRevPropertyGetterAdder(piri, this.getPropertyName(piri), this.getPropertySourceType(piri), out);
            out.println();
        }
        this.generateAddToModel(properties, revProperties, out);
        out.println();
        this.generateLoadFromModel(properties, out, someCollections || someObjects);
        out.println("}");
    }

    protected void generatePropertyDeclaration(IRI iri, String propertyName, PrintWriter out) {
        this.generateJavadoc(iri, out, 1);
        String type = this.getPropertyDataType(iri);
        out.printf(this.getIndent(1) + "private %s %s;\n", type, propertyName);
        out.println();
    }

    protected void generateReverseCollectionDeclaration(IRI iri, String propertyName, String propertyType, PrintWriter out) {
        out.printf(this.getIndent(1) + "/** Inverse collection for %s.%s. */\n", propertyType, propertyName);
        String varName = this.getReversePropertyName(iri);
        out.printf(this.getIndent(1) + "private Set<%s> %s;\n", propertyType, varName);
        out.println();
    }

    protected void generatePropertyGetter(IRI iri, String propertyName, PrintWriter out) {
        String name = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String type = this.getPropertyDataType(iri);
        out.printf(this.getIndent(1) + "public %s %s() {\n", type, name);
        out.printf(this.getIndent(2) + "return %s;\n", propertyName);
        out.println(this.getIndent(1) + "}");
    }

    protected void generatePropertySetter(IRI iri, String propertyName, PrintWriter out) {
        String name = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String type = this.getPropertyDataType(iri);
        out.printf(this.getIndent(1) + "public void %s(%s %s) {\n", name, type, propertyName);
        out.printf(this.getIndent(2) + "this.%s = %s;\n", propertyName, propertyName);
        out.println(this.getIndent(1) + "}");
    }

    protected void generateRevPropertyGetterAdder(IRI iri, String propertyName, String propertyType, PrintWriter out) {
        String adderName = "add" + propertyType;
        String paramName = propertyType.substring(0, 1).toLowerCase() + propertyType.substring(1);
        String varName = this.getReversePropertyName(iri);
        String getterName = "get" + English.plural(propertyType);
        out.printf(this.getIndent(1) + "public Set<%s> %s() {\n", propertyType, getterName);
        out.printf(this.getIndent(2) + "return %s;\n", varName);
        out.println(this.getIndent(1) + "}");
        out.println();
        out.printf(this.getIndent(1) + "public void %s(%s %s) {\n", adderName, propertyType, paramName);
        out.printf(this.getIndent(2) + "if (%s == null) %s = new HashSet<>();\n", varName, varName);
        out.printf(this.getIndent(2) + "%s.add(%s);\n", varName, paramName);
        if (this.getPropertyClassification(iri).equals("Object")) {
            String otherSetter = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            out.printf(this.getIndent(2) + "%s.%s(this);\n", paramName, otherSetter);
        } else {
            String other = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            out.printf(this.getIndent(2) + "%s.%s().add(this);\n", paramName, other);
        }
        out.println(this.getIndent(1) + "}");
    }

    protected void generateConstructors(String className, Set<IRI> properties, Set<IRI> revProperties, PrintWriter out) {
        String propertyName;
        out.printf(this.getIndent(1) + "public %s(IRI iri) {\n", className);
        out.println(this.getIndent(2) + "super(iri);");
        for (IRI piri : properties) {
            if (!this.getPropertyClassification(piri).equals("Collection")) continue;
            propertyName = this.getPropertyName(piri);
            String propertyType = this.getPropertyDataType(piri);
            out.printf(this.getIndent(2) + "%s = new Hash%s();\n", propertyName, propertyType);
        }
        for (IRI piri : revProperties) {
            if (!this.isObjectOrCollectionProperty(piri) || this.isInverseFunctionalProperty(piri)) continue;
            propertyName = this.getReversePropertyName(piri);
            out.printf(this.getIndent(2) + "%s = new HashSet<>();\n", propertyName);
        }
        out.println(this.getIndent(1) + "}");
    }

    protected void generateDefaultMethods(String className, PrintWriter out) {
        out.println(this.getIndent(1) + "@Override");
        out.println(this.getIndent(1) + "public IRI getClassIRI() {");
        out.printf(this.getIndent(2) + "return %s.CLASS_IRI;\n", className);
        out.println(this.getIndent(1) + "}");
    }

    protected void generateAddToModel(Collection<IRI> properties, Collection<IRI> revProperties, PrintWriter out) {
        out.println(this.getIndent(1) + "@Override");
        out.println(this.getIndent(1) + "public void addToModel(TargetModel target) {");
        out.println(this.getIndent(2) + "super.addToModel(target);");
        for (IRI piri : properties) {
            out.print(this.getIndent(2));
            String name = this.getPropertyName(piri);
            String type = this.getPropertyClassification(piri);
            out.printf("add%s(target, %s.%s, %s);\n", type, this.getVocabName(), name, name);
        }
        for (IRI piri : revProperties) {
            if (!this.isObjectOrCollectionProperty(piri) || this.isInverseFunctionalProperty(piri)) continue;
            String varName = this.getReversePropertyName(piri);
            out.printf(this.getIndent(2) + "target.addAll(%s);\n", varName);
        }
        out.println(this.getIndent(1) + "}");
    }

    protected void generateLoadFromModel(Collection<IRI> properties, PrintWriter out, boolean useFactory) {
        out.println(this.getIndent(1) + "@Override");
        out.printf(this.getIndent(1) + "public void loadFromModel(Model model, EntityFactory efactory) {\n", new Object[0]);
        out.println(this.getIndent(2) + "super.loadFromModel(model, efactory);");
        if (useFactory) {
            out.printf(this.getIndent(2) + "if (!(efactory instanceof %s))\n", this.getFactoryName());
            out.printf(this.getIndent(3) + "throw new IllegalArgumentException(\"factory must be instance of %s\");\n", this.getFactoryName());
            out.printf(this.getIndent(2) + "final %s factory = (%s) efactory;\n\n", this.getFactoryName(), this.getFactoryName());
        }
        out.println(this.getIndent(2) + "final Model m = model.filter(getIRI(), null, null);");
        for (IRI piri : properties) {
            String name = this.getPropertyName(piri);
            String type = this.getPropertyClassification(piri);
            String dtype = this.getPropertyDataType(piri);
            if (type.equals("Value") || type.equals("Array")) {
                if ((dtype = dtype.replace("[]", "")).contains(".")) {
                    dtype = dtype.substring(dtype.lastIndexOf(46) + 1);
                }
                dtype = dtype.substring(0, 1).toUpperCase() + dtype.substring(1);
                out.printf(this.getIndent(2) + "%s = load%s%s(m, %s.%s);\n", name, dtype, type, this.getVocabName(), name);
                continue;
            }
            if (type.equals("Object")) {
                out.printf(this.getIndent(2) + "//load object %s\n", name);
                out.printf(this.getIndent(2) + "final Set<IRI> %sIRIs = getObjectIRIs(m, %s.%s);\n", name, this.getVocabName(), name);
                out.printf(this.getIndent(2) + "if (!%sIRIs.isEmpty()) {\n", name);
                out.printf(this.getIndent(3) + "final IRI iri = %sIRIs.iterator().next();\n", name);
                out.printf(this.getIndent(3) + "%s = factory.create%s(iri);\n", name, dtype);
                out.printf(this.getIndent(3) + "%s.loadFromModel(m, factory);\n", name);
                out.println(this.getIndent(2) + "} else {");
                out.printf(this.getIndent(3) + "%s = null;\n", name);
                out.println(this.getIndent(2) + "}");
                continue;
            }
            if (!type.equals("Collection")) continue;
            dtype = dtype.replace("Set<", "").replace(">", "");
            out.printf(this.getIndent(2) + "//load collection %s\n", name);
            out.printf(this.getIndent(2) + "final Set<IRI> %sIRIs = getObjectIRIs(m, %s.%s);\n", name, this.getVocabName(), name);
            out.printf(this.getIndent(2) + "%s = new HashSet<>();\n", name);
            out.printf(this.getIndent(2) + "for (IRI iri : %sIRIs) {\n", name);
            out.printf(this.getIndent(3) + "%s item = factory.create%s(iri);\n", dtype, dtype);
            out.printf(this.getIndent(3) + "item.loadFromModel(m, factory);\n", new Object[0]);
            out.printf(this.getIndent(3) + "%s.add(item);\n", name);
            out.println(this.getIndent(2) + "}");
        }
        out.println(this.getIndent(1) + "}");
    }

    protected void generateJavadoc(IRI iri, PrintWriter out, int indent) {
        Literal oTitle = this.getFirstExistingObjectLiteral(this.model, iri, this.getPreferredLanguage(), LABEL_PROPERTIES);
        Literal oDescr = this.getFirstExistingObjectLiteral(this.model, iri, this.getPreferredLanguage(), COMMENT_PROPERTIES);
        Set<Value> oSeeAlso = this.model.filter((Resource)iri, RDFS.SEEALSO, null, new Resource[0]).objects();
        String ii = this.getIndent(indent);
        out.println(ii + "/**");
        if (oTitle != null) {
            out.printf(ii + " * %s.%n", WordUtils.wrap(oTitle.getLabel().replaceAll("\\s+", " "), 70, "\n" + ii + " * ", false));
            out.println(ii + " * <p>");
        }
        if (oDescr != null) {
            out.printf(ii + " * %s.%n", WordUtils.wrap(oDescr.getLabel().replaceAll("\\s+", " "), 70, "\n" + ii + " * ", false));
            out.println(ii + " * <p>");
        }
        out.printf(ii + " * IRI: {@code <%s>}%n", iri);
        if (!oSeeAlso.isEmpty()) {
            out.println(ii + " *");
            for (Value s : oSeeAlso) {
                if (!(s instanceof IRI)) continue;
                out.printf(ii + " * @see <a href=\"%s\">%s</a>%n", s.stringValue(), s.stringValue());
            }
        }
        out.println(ii + " */");
    }

    private Set<Resource> findClasses() {
        HashSet<Resource> classes = new HashSet<Resource>();
        Model types = this.model.filter(null, RDF.TYPE, null, new Resource[0]);
        for (Statement st : types) {
            if (!classPredicates.contains(st.getObject())) continue;
            classes.add(st.getSubject());
        }
        return classes;
    }

    private String getClassName(IRI iri) {
        return iri.getLocalName();
    }

    private Set<IRI> findClassProperties(IRI classIRI) {
        return this.findClassProperties(classIRI, RDFS.DOMAIN);
    }

    private Set<IRI> findClassProperties(IRI classIRI, IRI predicate) {
        HashSet<IRI> ret = new HashSet<IRI>();
        for (IRI pred : PROPERTY_PROPERTIES) {
            for (Statement st : this.model.filter(null, RDF.TYPE, (Value)pred, new Resource[0])) {
                IRI firi;
                Set<Value> domains;
                if (!(st.getSubject() instanceof IRI) || !(domains = this.model.filter((Resource)(firi = (IRI)st.getSubject()), predicate, null, new Resource[0]).objects()).contains(classIRI)) continue;
                ret.add(firi);
            }
        }
        return ret;
    }

    private String getPropertyName(IRI iri) {
        return iri.getLocalName();
    }

    private String getReversePropertyName(IRI iri) {
        String propertyType = this.getPropertySourceType(iri);
        return English.plural(propertyType.substring(0, 1).toLowerCase() + propertyType.substring(1));
    }

    private String getPropertyDataType(IRI iri) {
        IRI range = this.getOptionalObjectIRI(this.model, iri, RDFS.RANGE);
        String type = "String";
        if (range != null) {
            if (dataTypes.containsKey(range)) {
                type = dataTypes.get(range);
                if (!this.isFunctionalProperty(iri)) {
                    type = type + "[]";
                }
            } else if (range.getNamespace().equals(iri.getNamespace())) {
                type = this.getClassName(range);
                if (!this.isFunctionalProperty(iri)) {
                    type = "Set<" + type + ">";
                }
            }
        }
        return type;
    }

    private String getPropertySourceType(IRI iri) {
        IRI domain = this.getOptionalObjectIRI(this.model, iri, RDFS.DOMAIN);
        return domain == null ? null : this.getClassName(domain);
    }

    private String getPropertyClassification(IRI iri) {
        IRI range = this.getOptionalObjectIRI(this.model, iri, RDFS.RANGE);
        String type = "Value";
        if (range != null) {
            if (dataTypes.containsKey(range)) {
                type = "Value";
                if (!this.isFunctionalProperty(iri)) {
                    type = "Array";
                }
            } else if (range.getNamespace().equals(iri.getNamespace())) {
                type = "Object";
                if (!this.isFunctionalProperty(iri)) {
                    type = "Collection";
                }
            }
        }
        return type;
    }

    private boolean isFunctionalProperty(IRI iri) {
        Model m = this.model.filter((Resource)iri, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY, new Resource[0]);
        return m.size() != 0;
    }

    private boolean isInverseFunctionalProperty(IRI iri) {
        Model m = this.model.filter((Resource)iri, RDF.TYPE, (Value)OWL.INVERSEFUNCTIONALPROPERTY, new Resource[0]);
        return m.size() != 0;
    }

    private boolean isObjectOrCollectionProperty(IRI piri) {
        return this.getPropertyClassification(piri).equals("Object") || this.getPropertyClassification(piri).equals("Collection");
    }

    private Literal getFirstExistingObjectLiteral(Model model, Resource subject, String lang, IRI ... predicates) {
        for (IRI predicate : predicates) {
            Literal literal = this.getOptionalObjectLiteral(model, subject, predicate, lang);
            if (literal == null) continue;
            return literal;
        }
        return null;
    }

    private Literal getOptionalObjectLiteral(Model model, Resource subject, IRI predicate, String lang) {
        Set<Value> objects = model.filter(subject, predicate, null, new Resource[0]).objects();
        Literal result = null;
        for (Value nextValue : objects) {
            if (!(nextValue instanceof Literal)) continue;
            Literal literal = (Literal)nextValue;
            if (result != null && (lang == null || !lang.equals(literal.getLanguage().orElse(null)))) continue;
            result = literal;
        }
        return result;
    }

    private IRI getOptionalObjectIRI(Model model, Resource subject, IRI predicate) {
        Set<Value> objects = model.filter(subject, predicate, null, new Resource[0]).objects();
        for (Value nextValue : objects) {
            if (!(nextValue instanceof IRI)) continue;
            return (IRI)nextValue;
        }
        return null;
    }

    private String getIndent(int level) {
        return StringUtils.repeat(this.getIndent(), level);
    }

    static {
        classPredicates.add(RDFS.CLASS);
        classPredicates.add(OWL.CLASS);
        dataTypes = new HashMap<IRI, String>();
        dataTypes.put(XMLSchema.BOOLEAN, "boolean");
        dataTypes.put(XMLSchema.BYTE, "byte");
        dataTypes.put(XMLSchema.DATE, "java.util.Date");
        dataTypes.put(XMLSchema.DATETIME, "java.util.Date");
        dataTypes.put(XMLSchema.DECIMAL, "float");
        dataTypes.put(XMLSchema.DOUBLE, "double");
        dataTypes.put(XMLSchema.FLOAT, "float");
        dataTypes.put(XMLSchema.INT, "int");
        dataTypes.put(XMLSchema.INTEGER, "int");
        dataTypes.put(XMLSchema.LONG, "long");
        dataTypes.put(XMLSchema.POSITIVE_INTEGER, "int");
        dataTypes.put(XMLSchema.SHORT, "short");
        dataTypes.put(XMLSchema.STRING, "String");
        dataTypes.put(XMLSchema.TIME, "java.util.Date");
        dataTypes.put(XMLSchema.ANYURI, "java.net.URL");
    }
}

