/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetBooleanTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetConsumer;
import org.tmatesoft.sqljet.core.table.ISqlJetDoubleTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetIntTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetLongTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetTransactionRunner<U extends SqlJetEngine> {
    private final SqlJetTransactionMode mode;
    private final U db;

    public SqlJetTransactionRunner(SqlJetTransactionMode mode, U db) {
        this.mode = mode;
        this.db = db;
    }

    public <T> T as(ISqlJetTransaction<T, U> op) throws SqlJetException {
        return (T)((SqlJetEngine)this.db).runEngineTransaction(engine -> op.run(this.db), this.mode);
    }

    public void asVoid(ISqlJetConsumer<U> op) throws SqlJetException {
        this.as(db -> {
            op.run(db);
            return null;
        });
    }

    public boolean asBool(ISqlJetBooleanTransaction<U> op) throws SqlJetException {
        return ((SqlJetEngine)this.db).runEngineTransactionBool(engine -> op.run(this.db), this.mode);
    }

    public double asDouble(ISqlJetDoubleTransaction<U> op) throws SqlJetException {
        return this.as(db -> op.run(db));
    }

    public long asLong(ISqlJetLongTransaction<U> op) throws SqlJetException {
        return this.as(db -> op.run(db));
    }

    public int asInt(ISqlJetIntTransaction<U> op) throws SqlJetException {
        return this.as(db -> op.run(db));
    }
}

