/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetTimeoutBusyHandler
implements ISqlJetBusyHandler {
    private static final int[] delays = new int[]{1, 2, 5, 10, 15, 20, 25, 25, 25, 50, 50, 100};
    private static final int[] totals;
    private final int timeout;

    static {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 8;
        nArray[4] = 18;
        nArray[5] = 33;
        nArray[6] = 53;
        nArray[7] = 78;
        nArray[8] = 103;
        nArray[9] = 128;
        nArray[10] = 178;
        nArray[11] = 228;
        totals = nArray;
    }

    public SqlJetTimeoutBusyHandler(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean call(int number) {
        int prior;
        int delay;
        if (number < delays.length) {
            delay = delays[number];
            prior = totals[number];
        } else {
            delay = delays[delays.length - 1];
            prior = totals[delays.length - 1] + delay * (number - (delays.length - 1));
        }
        if (prior + delay > this.timeout && (delay = this.timeout - prior) <= 0) {
            return false;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

