/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import java.io.File;
import java.io.IOException;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetTransactionRunner;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetDb
extends SqlJetEngine {
    public static final File IN_MEMORY = new File(":memory:");
    private SqlJetDb temporaryDb;
    private final SqlJetTransactionRunner<SqlJetDb> readRunner = new SqlJetTransactionRunner<SqlJetDb>(SqlJetTransactionMode.READ_ONLY, this);
    private final SqlJetTransactionRunner<SqlJetDb> writeRunner = new SqlJetTransactionRunner<SqlJetDb>(SqlJetTransactionMode.WRITE, this);

    public SqlJetDb(File file, boolean writable) throws SqlJetException {
        super(file, writable);
    }

    public SqlJetDb(File file, boolean writable, ISqlJetFileSystem fs) throws SqlJetException {
        super(file, writable, fs);
    }

    public SqlJetDb(File file, boolean writable, String fsName) throws SqlJetException {
        super(file, writable, fsName);
    }

    public static SqlJetDb open(File file, boolean write) throws SqlJetException {
        return new SqlJetDb(file, write);
    }

    public static SqlJetDb open(File file, boolean write, ISqlJetFileSystem fs) throws SqlJetException {
        return new SqlJetDb(file, write, fs);
    }

    public static SqlJetDb open(File file, boolean write, String fsName) throws SqlJetException {
        return new SqlJetDb(file, write, fsName);
    }

    public <T> T runWithLock(ISqlJetTransaction<T, SqlJetDb> op) throws SqlJetException {
        return (T)this.runSynchronized(db -> op.run(this));
    }

    public ISqlJetSchema getSchema() throws SqlJetException {
        return this.getSchemaInternal();
    }

    public ISqlJetTable getTable(String tableName) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.runWithLock(db -> new SqlJetTable((SqlJetDb)db, this.btree, tableName, this.writable));
    }

    public SqlJetTransactionRunner<SqlJetDb> read() throws SqlJetException {
        this.checkOpen();
        return this.readRunner;
    }

    public SqlJetTransactionRunner<SqlJetDb> write() throws SqlJetException {
        this.checkOpen();
        if (this.writable) {
            return this.writeRunner;
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public <T> T runTransaction(ISqlJetTransaction<T, SqlJetDb> op, SqlJetTransactionMode mode) throws SqlJetException {
        return (T)this.runEngineTransaction(engine -> op.run(this), mode);
    }

    public Object pragma(String sql) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.runWithLock(db -> new SqlJetPragmasHandler(this.getOptions()).pragma(sql));
    }

    public ISqlJetTableDef createTable(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().createTable(sql));
    }

    public ISqlJetIndexDef createIndex(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().createIndex(sql));
    }

    public void dropTable(String tableName) throws SqlJetException {
        this.write().asVoid(db -> this.getSchemaInternal().dropTable(tableName));
    }

    public void dropIndex(String indexName) throws SqlJetException {
        this.write().asVoid(db -> this.getSchemaInternal().dropIndex(indexName));
    }

    public void dropView(String viewName) throws SqlJetException {
        this.write().asVoid(db -> this.getSchemaInternal().dropView(viewName));
    }

    public void dropTrigger(String triggerName) throws SqlJetException {
        this.write().asVoid(db -> this.getSchemaInternal().dropTrigger(triggerName));
    }

    public ISqlJetTableDef alterTable(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().alterTable(sql));
    }

    public ISqlJetVirtualTableDef createVirtualTable(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().createVirtualTable(sql, 0));
    }

    public ISqlJetViewDef createView(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().createView(sql));
    }

    public ISqlJetTriggerDef createTrigger(String sql) throws SqlJetException {
        return this.write().as(db -> this.getSchemaInternal().createTrigger(sql));
    }

    public SqlJetDb getTemporaryDatabase() throws SqlJetException {
        return this.getTemporaryDatabase(false);
    }

    public SqlJetDb getTemporaryDatabase(boolean inMemory) throws SqlJetException {
        this.checkOpen();
        return this.runWithLock(db -> {
            if (this.temporaryDb == null || !this.temporaryDb.isOpen()) {
                this.closeTemporaryDatabase();
                File tmpDbFile = this.getTemporaryDatabaseFile(inMemory);
                if (tmpDbFile != null) {
                    this.temporaryDb = SqlJetDb.open(tmpDbFile, true);
                }
            }
            return this.temporaryDb;
        });
    }

    @Override
    protected void closeResources() throws SqlJetException {
        this.closeTemporaryDatabase();
    }

    private void closeTemporaryDatabase() throws SqlJetException {
        if (this.temporaryDb != null) {
            this.temporaryDb.close();
            File tmpDbFile = this.temporaryDb.getFile();
            if (tmpDbFile != null && !IN_MEMORY.equals(tmpDbFile)) {
                this.getFileSystem().delete(tmpDbFile, false);
            }
        }
        this.temporaryDb = null;
    }

    private File getTemporaryDatabaseFile(boolean inMemory) throws SqlJetException {
        if (inMemory) {
            return IN_MEMORY;
        }
        File tmpDbFile = null;
        try {
            tmpDbFile = this.getFileSystem().getTempFile();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
        }
        if (tmpDbFile == null) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        return tmpDbFile;
    }
}

