/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.map;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMap;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.map.ISqlJetMap;
import org.tmatesoft.sqljet.core.map.ISqlJetMapDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetTransactionRunner;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMapDb
extends SqlJetEngine {
    private static final String MAP_TABLE_DOES_NOT_EXIST = "Map table '%s' does not exist";
    public static final File IN_MEMORY = new File(":memory:");
    public static final String MODULE_NAME = "sqljetmap";
    private static final String MAP_EXISTS = "Map '%s' exists";
    private volatile Map<String, SqlJetMapDef> mapDefs;
    private final SqlJetTransactionRunner<SqlJetEngine> readRunner = new SqlJetTransactionRunner<SqlJetMapDb>(SqlJetTransactionMode.READ_ONLY, this);
    private final SqlJetTransactionRunner<SqlJetEngine> writeRunner = new SqlJetTransactionRunner<SqlJetMapDb>(SqlJetTransactionMode.WRITE, this);

    public SqlJetMapDb(File file, boolean writable) throws SqlJetException {
        super(file, writable);
    }

    public static SqlJetMapDb open(File file, boolean writable) throws SqlJetException {
        return new SqlJetMapDb(file, writable);
    }

    public SqlJetTransactionRunner<SqlJetEngine> read() throws SqlJetException {
        this.checkOpen();
        return this.readRunner;
    }

    public SqlJetTransactionRunner<SqlJetEngine> write() throws SqlJetException {
        this.checkOpen();
        if (this.writable) {
            return this.writeRunner;
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public <T> T runTransaction(SqlJetTransactionMode mode, ISqlJetTransaction<T, SqlJetMapDb> transaction) throws SqlJetException {
        this.checkOpen();
        return (T)this.runEngineTransaction(engine -> transaction.run(this), mode);
    }

    public <T> T runSynchronizedMap(ISqlJetTransaction<T, SqlJetMapDb> transaction) throws SqlJetException {
        return (T)this.runSynchronized(engine -> transaction.run(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SqlJetMapDef> getMapDefs() {
        if (this.mapDefs == null) {
            SqlJetMapDb sqlJetMapDb = this;
            synchronized (sqlJetMapDb) {
                if (this.mapDefs == null) {
                    this.mapDefs = new TreeMap<String, SqlJetMapDef>(String.CASE_INSENSITIVE_ORDER);
                }
            }
        }
        return this.mapDefs;
    }

    @Override
    protected void readSchema() throws SqlJetException {
        super.readSchema();
        this.readMapDefs();
    }

    private void readMapDefs() throws SqlJetException {
        SqlJetSchema schema = this.getSchemaInternal();
        Set<String> names = schema.getVirtualTableNames();
        if (names != null && names.size() > 0) {
            this.getMapDefs().clear();
            for (String name : names) {
                ISqlJetVirtualTableDef vtable = schema.getVirtualTable(name);
                if (!MODULE_NAME.equalsIgnoreCase(vtable.getModuleName())) continue;
                ISqlJetIndexDef indexDef = schema.getIndex(this.getMapIndexName(name));
                if (indexDef != null) {
                    SqlJetMapDef mapTableDef = new SqlJetMapDef(name, vtable, indexDef);
                    this.getMapDefs().put(name, mapTableDef);
                    continue;
                }
                throw new SqlJetException(SqlJetErrorCode.CORRUPT, String.format("Map '%s' does not have index", name));
            }
        }
    }

    public Set<String> getMapNames() throws SqlJetException {
        return this.runSynchronizedMap(mapDb -> {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.getMapDefs().keySet());
            return s;
        });
    }

    public ISqlJetMapDef getMapDef(String mapName) throws SqlJetException {
        return this.runSynchronizedMap(mapDb -> this.getMapDefs().get(mapName));
    }

    public ISqlJetMapDef createMap(String mapName) throws SqlJetException {
        if (this.getMapDefs().containsKey(mapName)) {
            throw new SqlJetException(String.format(MAP_EXISTS, mapName));
        }
        return this.write().as(mapDb -> {
            int page = this.btree.createTable(SqlJetSchema.BTREE_CREATE_TABLE_FLAGS);
            SqlJetSchema schema = this.getSchemaInternal();
            String create = String.format("create virtual table %s using %s", mapName, MODULE_NAME);
            ISqlJetVirtualTableDef vtable = schema.createVirtualTable(create, page);
            String indexName = this.getMapIndexName(mapName);
            ISqlJetIndexDef indexDef = schema.createIndexForVirtualTable(mapName, indexName);
            SqlJetMapDef mapDef = new SqlJetMapDef(mapName, vtable, indexDef);
            this.getMapDefs().put(mapName, mapDef);
            return mapDef;
        });
    }

    private String getMapIndexName(String mapTableName) {
        return String.format("%s_%s_1", MODULE_NAME, mapTableName);
    }

    public ISqlJetMap getMap(String mapName) throws SqlJetException {
        this.checkOpen();
        return this.runSynchronizedMap(mapDb -> {
            this.refreshSchema();
            SqlJetMapDef mapDef = this.getMapDefs().get(mapName);
            if (mapDef != null) {
                return new SqlJetMap((SqlJetMapDb)mapDb, this.btree, mapDef, this.writable);
            }
            throw new SqlJetException(String.format(MAP_TABLE_DOES_NOT_EXIST, mapName));
        });
    }
}

