/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.util.ArrayList;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetResultWithOffset;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult32;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFactory;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;

public class SqlJetKeyInfo
implements ISqlJetKeyInfo {
    private final SqlJetEncoding enc;
    private boolean[] aSortOrder = new boolean[0];

    public SqlJetKeyInfo(SqlJetEncoding enc) {
        this.enc = enc;
    }

    @Override
    public SqlJetUnpackedRecord recordUnpack(int nKey, ISqlJetMemoryPointer pKey) {
        ArrayList<ISqlJetVdbeMem> pMem = new ArrayList<ISqlJetVdbeMem>(this.aSortOrder.length + 1);
        SqlJetVarintResult32 res = pKey.getVarint32();
        int idx = res.getOffset();
        int d = res.getValue();
        int u = 0;
        while (idx < res.getValue() && u < this.aSortOrder.length + 1) {
            SqlJetVarintResult32 res2 = pKey.pointer(idx).getVarint32();
            idx += res2.getOffset();
            if (d >= nKey && SqlJetVdbeSerialType.serialTypeLen(res2.getValue()) > 0) break;
            SqlJetResultWithOffset<ISqlJetVdbeMem> result = SqlJetVdbeMemFactory.serialGet(pKey, d, res2.getValue(), this.enc);
            d += result.getOffset();
            pMem.add(result.getValue());
            ++u;
        }
        return new SqlJetUnpackedRecord(this, pMem);
    }

    public int getNField() {
        return this.aSortOrder.length;
    }

    public void setNField(int field) {
        this.aSortOrder = new boolean[field];
    }

    public SqlJetEncoding getEnc() {
        return this.enc;
    }

    public void setSortOrder(int i, boolean desc) throws SqlJetException {
        if (i >= this.aSortOrder.length) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.aSortOrder[i] = desc;
    }

    public boolean getSortOrder(int i) throws SqlJetException {
        if (i >= this.aSortOrder.length) {
            return false;
        }
        return this.aSortOrder[i];
    }
}

