/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetRowNumCursor;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetTableDataCursor
extends SqlJetRowNumCursor {
    public SqlJetTableDataCursor(ISqlJetBtreeDataTable table, SqlJetDb db) throws SqlJetException {
        super(table, db);
        super.first();
    }

    protected ISqlJetBtreeDataTable getBtreeDataTable() {
        return (ISqlJetBtreeDataTable)this.btreeTable;
    }

    @Override
    public long getRowId() throws SqlJetException {
        return this.db.read().asLong(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            if (table.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or the current record doesn't point to a data row");
            }
            return table.getRowId();
        });
    }

    @Override
    public boolean goTo(long rowId) throws SqlJetException {
        return this.db.read().asBool(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            return table.goToRow(rowId);
        });
    }

    private int getFieldSafe(String fieldName) throws SqlJetException {
        ISqlJetBtreeDataTable table = this.getBtreeDataTable();
        if (this.eof()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or the current record doesn't point to a data row");
        }
        if (fieldName == null) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Field name is null");
        }
        int field = table.getDefinition().getColumnNumber(fieldName);
        if (field < 0) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Field not found: " + fieldName);
        }
        return field;
    }

    @Override
    public SqlJetValueType getFieldType(String fieldName) throws SqlJetException {
        return this.db.read().as(db -> this.getBtreeDataTable().getFieldType(this.getFieldSafe(fieldName)));
    }

    @Override
    public boolean isNull(String fieldName) throws SqlJetException {
        return this.db.read().asBool(db -> this.getBtreeDataTable().isNull(this.getFieldSafe(fieldName)));
    }

    @Override
    public String getString(String fieldName) throws SqlJetException {
        return this.db.read().as(db -> this.getBtreeDataTable().getString(this.getFieldSafe(fieldName)));
    }

    @Override
    public long getInteger(String fieldName) throws SqlJetException {
        return this.db.read().asLong(db -> {
            if (SqlJetBtreeDataTable.isFieldNameRowId(fieldName)) {
                return this.getBtreeDataTable().getRowId();
            }
            return this.getBtreeDataTable().getInteger(this.getFieldSafe(fieldName));
        });
    }

    @Override
    public double getFloat(String fieldName) throws SqlJetException {
        return this.db.read().asDouble(db -> this.getBtreeDataTable().getFloat(this.getFieldSafe(fieldName)));
    }

    @Override
    public Optional<byte[]> getBlobAsArray(String fieldName) throws SqlJetException {
        return this.db.read().as(db -> this.getBtreeDataTable().getBlob(this.getFieldSafe(fieldName)).map(ISqlJetMemoryPointer::getBytes));
    }

    @Override
    public Optional<InputStream> getBlobAsStream(String fieldName) throws SqlJetException {
        return this.db.read().as(db -> this.getBtreeDataTable().getBlob(this.getFieldSafe(fieldName)).map(buffer -> new ByteArrayInputStream(buffer.getBytes())));
    }

    @Override
    public Object getValue(String fieldName) throws SqlJetException {
        return this.db.read().as(db -> {
            if (SqlJetBtreeDataTable.isFieldNameRowId(fieldName)) {
                return this.getBtreeDataTable().getRowId();
            }
            return this.getBtreeDataTable().getValue(this.getFieldSafe(fieldName));
        });
    }

    @Override
    public boolean getBoolean(String fieldName) throws SqlJetException {
        return this.db.read().asBool(db -> this.getBoolean(this.getFieldSafe(fieldName)));
    }

    @Override
    public void update(Object ... values) throws SqlJetException {
        this.updateOr(null, values);
    }

    @Override
    public void updateOr(SqlJetConflictAction onConflict, Object ... values) throws SqlJetException {
        this.db.write().asVoid(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            if (table.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't't point to data row");
            }
            table.updateCurrent(onConflict, values);
        });
    }

    @Override
    public long updateWithRowId(long rowId, Object ... values) throws SqlJetException {
        return this.updateWithRowIdOr(null, rowId, values);
    }

    @Override
    public long updateWithRowIdOr(SqlJetConflictAction onConflict, long rowId, Object ... values) throws SqlJetException {
        return this.db.write().asLong(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            if (table.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't't point to data row");
            }
            return table.updateCurrentWithRowId(onConflict, rowId, values);
        });
    }

    @Override
    public void updateByFieldNames(Map<String, Object> values) throws SqlJetException {
        this.updateByFieldNamesOr(null, values);
    }

    @Override
    public void updateByFieldNamesOr(SqlJetConflictAction onConflict, Map<String, Object> values) throws SqlJetException {
        this.db.write().asVoid(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            if (table.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't point to data row");
            }
            table.update(onConflict, values);
        });
    }

    @Override
    public void delete() throws SqlJetException {
        this.db.write().asVoid(db -> {
            ISqlJetBtreeDataTable table = this.getBtreeDataTable();
            if (table.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table is empty or current record doesn't point to data row");
            }
            table.delete();
        });
        super.delete();
    }

    @Override
    public Object[] getRowValues() throws SqlJetException {
        return this.db.read().as(db -> {
            Object[] values = this.getBtreeDataTable().getValues();
            return (Object[])values.clone();
        });
    }
}

