/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetCursor;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public abstract class SqlJetRowNumCursor
extends SqlJetCursor {
    private long rowsCount = -1L;
    private long currentRowNum = -1L;
    private long currentRowId = -1L;
    private boolean internalMove;
    private long limit = 0L;

    protected SqlJetRowNumCursor(ISqlJetBtreeTable table, SqlJetDb db) throws SqlJetException {
        super(table, db);
    }

    @Override
    public void setLimit(long limit) throws SqlJetException {
        if (limit >= 0L) {
            this.limit = limit;
            this.rowsCount = -1L;
            this.first();
        }
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public long getRowCount() throws SqlJetException {
        if (this.rowsCount < 0L) {
            this.computeRows(false);
        }
        return this.rowsCount;
    }

    protected void computeRows(boolean current) throws SqlJetException {
        this.db.read().asVoid(db -> {
            try {
                this.internalMove = true;
                this.currentRowId = this.getRowIdSafe();
                this.rowsCount = 0L;
                this.currentRowNum = -1L;
                this.first();
                while (!this.eof()) {
                    ++this.rowsCount;
                    if (this.currentRowId == this.getRowIdSafe()) {
                        this.currentRowNum = this.rowsCount;
                        if (current) break;
                    }
                    this.next();
                }
                if (this.currentRowNum < 0L) {
                    this.currentRowNum = this.rowsCount;
                }
                if (this.currentRowId > 0L) {
                    this.goTo(this.currentRowId);
                }
            }
            finally {
                this.internalMove = false;
            }
        });
    }

    @Override
    public long getRowIndex() throws SqlJetException {
        if (this.currentRowNum < 0L || this.rowsCount < 0L && this.eof() || this.currentRowId != this.getRowIdSafe()) {
            this.computeRows(true);
        }
        return this.currentRowNum;
    }

    @Override
    public boolean goToRow(long rowNum) throws SqlJetException {
        try {
            this.internalMove = true;
            if (this.rowsCount > 0L && rowNum > this.rowsCount) {
                return false;
            }
            if (this.currentRowNum < 0L || this.eof() && this.rowsCount < 0L || this.currentRowId != this.getRowIdSafe()) {
                this.currentRowId = this.getRowIdSafe();
                this.currentRowNum = 0L;
                this.first();
                while (!this.eof()) {
                    ++this.currentRowNum;
                    if (this.currentRowNum == rowNum) {
                        this.currentRowId = this.getRowIdSafe();
                        return true;
                    }
                    this.next();
                }
                if (this.rowsCount < 0L) {
                    this.rowsCount = this.currentRowNum;
                }
                this.currentRowNum = -1L;
                if (this.currentRowId > 0L) {
                    this.goTo(this.currentRowId);
                }
            } else {
                if (rowNum == this.currentRowNum) {
                    return true;
                }
                long rn = this.currentRowNum;
                while (!this.eof()) {
                    this.currentRowNum = rowNum > this.currentRowNum ? ++this.currentRowNum : --this.currentRowNum;
                    if (this.currentRowNum == rowNum) {
                        this.currentRowId = this.getRowIdSafe();
                        return true;
                    }
                    if (rowNum <= this.currentRowNum ? !this.previous() : !this.next()) break;
                }
                if (this.rowsCount < 0L) {
                    this.rowsCount = this.currentRowNum;
                }
                this.currentRowNum = rn;
                if (this.currentRowId > 0L) {
                    this.goTo(this.currentRowId);
                }
            }
            return false;
        }
        finally {
            this.internalMove = false;
        }
    }

    @Override
    public void delete() throws SqlJetException {
        --this.rowsCount;
        --this.currentRowNum;
        this.currentRowId = this.getRowIdSafe();
    }

    @Override
    public boolean first() throws SqlJetException {
        return this.firstRowNum(super.first());
    }

    @Override
    public boolean next() throws SqlJetException {
        return this.nextRowNum(super.next());
    }

    @Override
    public boolean previous() throws SqlJetException {
        return this.previousRowNum(super.previous());
    }

    @Override
    public boolean last() throws SqlJetException {
        if (this.limit > 0L && this.goToRow(this.limit)) {
            return true;
        }
        return this.lastRowNum(super.last());
    }

    protected boolean firstRowNum(boolean first) throws SqlJetException {
        if (this.internalMove) {
            return first;
        }
        if (first) {
            this.currentRowNum = 1L;
            this.currentRowId = this.getRowIdSafe();
        } else {
            this.currentRowNum = 0L;
            this.currentRowId = -1L;
        }
        return first;
    }

    protected boolean nextRowNum(boolean next) throws SqlJetException {
        if (this.internalMove) {
            return next;
        }
        if (next) {
            ++this.currentRowNum;
            this.currentRowId = this.getRowIdSafe();
        }
        return next;
    }

    protected boolean previousRowNum(boolean previous) throws SqlJetException {
        if (this.internalMove) {
            return previous;
        }
        if (previous) {
            --this.currentRowNum;
            this.currentRowId = this.getRowIdSafe();
        }
        return previous;
    }

    protected boolean lastRowNum(boolean last) throws SqlJetException {
        if (this.internalMove) {
            return last;
        }
        this.currentRowNum = -1L;
        this.currentRowId = -1L;
        return last;
    }

    private long getRowIdSafe() throws SqlJetException {
        return super.eof() ? 0L : this.getRowId();
    }

    @Override
    public boolean eof() throws SqlJetException {
        if (this.limit > 0L) {
            return this.currentRowNum >= this.limit;
        }
        return super.eof();
    }
}

