/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetOptions
implements ISqlJetOptions {
    private static final SqlJetEncoding SQLJET_DEFAULT_ENCODING = SqlJetUtility.getEnumSysProp("SQLJET_DEFAULT_ENCODING", SqlJetEncoding.UTF8);
    private static final int SCHEMA_COOKIE = 1;
    private static final int FILE_FORMAT = 2;
    private static final int PAGE_CACHE_SIZE = 3;
    private static final int AUTOVACUUM = 4;
    private static final int ENCODING = 5;
    private static final int USER_COOKIE = 6;
    private static final int INCREMENTAL_VACUUM = 7;
    private final ISqlJetBtree btree;
    private final ISqlJetDbHandle dbHandle;
    private int schemaCookie;
    private int fileFormat = SQLJET_DEFAULT_FILE_FORMAT;
    private int pageCacheSize = 2000;
    private SqlJetAutoVacuumMode autovacuumMode = ISqlJetBtree.SQLJET_DEFAULT_AUTOVACUUM;
    private SqlJetEncoding encoding = SQLJET_DEFAULT_ENCODING;
    private int userCookie;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlJetOptions(ISqlJetBtree btree, ISqlJetDbHandle dbHandle) throws SqlJetException {
        this.btree = btree;
        this.dbHandle = dbHandle;
        if (this.readSchemaCookie() == 0) {
            try {
                this.initMeta();
                return;
            }
            catch (SqlJetException e) {
                if (SqlJetErrorCode.READONLY == e.getErrorCode()) return;
                throw e;
            }
        } else {
            this.readMeta();
        }
    }

    private void readMeta() throws SqlJetException {
        this.schemaCookie = this.readSchemaCookie();
        this.autovacuumMode = SqlJetAutoVacuumMode.selectVacuumMode(this.readAutoVacuum(), this.readIncrementalVacuum());
        this.fileFormat = this.readFileFormat();
        this.userCookie = this.readUserCookie();
        this.pageCacheSize = this.readPageCacheSize();
        this.encoding = this.readEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ENCODING: ").append((Object)this.encoding).append("\n");
        sb.append("SCHEMA VERSION: ").append(this.schemaCookie).append("\n");
        sb.append("USER VERSION: ").append(this.userCookie).append("\n");
        sb.append("FILE FORMAT: ").append(this.fileFormat).append("\n");
        sb.append("AUTOVACUUM: ").append((Object)this.autovacuumMode).append("\n");
        sb.append("CACHE SIZE: ").append(this.pageCacheSize);
        return sb.toString();
    }

    private SqlJetEncoding readEncoding() throws SqlJetException {
        int enc = this.btree.getMeta(5);
        if (enc == 0) {
            SqlJetAssert.assertTrue(this.readSchemaCookie() == 0, SqlJetErrorCode.CORRUPT);
            return SqlJetEncoding.UTF8;
        }
        SqlJetEncoding res = SqlJetEncoding.decodeInt(enc);
        SqlJetAssert.assertTrue(res != null && res.isSupported(), SqlJetErrorCode.CORRUPT);
        return res;
    }

    private boolean readIncrementalVacuum() throws SqlJetException {
        return this.btree.getMeta(7) != 0;
    }

    private int readUserCookie() throws SqlJetException {
        return this.btree.getMeta(6);
    }

    private boolean readAutoVacuum() throws SqlJetException {
        return this.btree.getMeta(4) != 0;
    }

    private int readPageCacheSize() throws SqlJetException {
        int meta = this.btree.getMeta(3);
        return meta > 0 ? meta : 2000;
    }

    private int readFileFormat() throws SqlJetException {
        int fileFormat = this.btree.getMeta(2);
        this.checkFileFormat(fileFormat);
        return fileFormat;
    }

    private void checkFileFormat(int fileFormat) throws SqlJetException {
        if (fileFormat < 1 || fileFormat > 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private int readSchemaCookie() throws SqlJetException {
        return this.btree.getMeta(1);
    }

    @Override
    public int getSchemaVersion() throws SqlJetException {
        return this.schemaCookie;
    }

    @Override
    public int getFileFormat() throws SqlJetException {
        return this.fileFormat;
    }

    @Override
    public int getCacheSize() throws SqlJetException {
        return this.pageCacheSize;
    }

    @Override
    public boolean isAutovacuum() throws SqlJetException {
        return this.autovacuumMode.isAutoVacuum();
    }

    @Override
    public SqlJetEncoding getEncoding() throws SqlJetException {
        return this.encoding;
    }

    @Override
    public boolean isLegacyFileFormat() throws SqlJetException {
        return this.fileFormat == 1;
    }

    @Override
    public void setLegacyFileFormat(boolean flag) throws SqlJetException {
        this.fileFormat = flag ? 1 : 4;
    }

    @Override
    public int getUserVersion() throws SqlJetException {
        return this.userCookie;
    }

    @Override
    public boolean isIncrementalVacuum() throws SqlJetException {
        return this.autovacuumMode.isIncrVacuum();
    }

    @Override
    public void setSchemaVersion(int version) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            SqlJetAssert.assertTrue(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can be performed only in active transaction");
            this.checkSchemaVersion();
            this.schemaCookie = version;
            this.writeSchemaCookie(this.schemaCookie);
        });
    }

    private void checkSchemaVersion() throws SqlJetException {
        SqlJetAssert.assertTrue(this.verifySchemaVersion(), SqlJetErrorCode.SCHEMA);
    }

    @Override
    public boolean verifySchemaVersion() throws SqlJetException {
        return this.dbHandle.getMutex().runBool(mutex -> this.schemaCookie == this.btree.getMeta(1));
    }

    @Override
    public void changeSchemaVersion() throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            SqlJetAssert.assertTrue(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can be performed only in active transaction");
            this.checkSchemaVersion();
            ++this.schemaCookie;
            this.writeSchemaCookie(this.schemaCookie);
        });
    }

    private void initMeta() throws SqlJetException {
        boolean inTrans = this.btree.isInTrans();
        SqlJetTransactionMode transMode = this.btree.getTransMode();
        try {
            if (!inTrans || transMode != SqlJetTransactionMode.EXCLUSIVE) {
                this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            }
            try {
                this.schemaCookie = 1;
                this.writeSchemaCookie(this.schemaCookie);
                this.writeFileFormat(this.fileFormat);
                this.writePageCacheSize();
                this.writeEncoding(this.encoding);
                this.autovacuumMode = this.btree.getAutoVacuum();
                this.writeAutoVacuum(this.isAutovacuum());
                this.writeIncrementalVacuum(this.isIncrementalVacuum());
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        }
        finally {
            if (inTrans && transMode != null) {
                if (!this.btree.isInTrans()) {
                    this.btree.beginTrans(transMode);
                } else if (this.btree.getTransMode() != transMode) {
                    this.btree.commit();
                    this.btree.beginTrans(transMode);
                }
            }
        }
    }

    private void writeSchemaCookie(int schemaCookie) throws SqlJetException {
        this.btree.updateMeta(1, schemaCookie);
    }

    private void writeEncoding(SqlJetEncoding encoding) throws SqlJetException {
        SqlJetAssert.assertTrue(encoding.isSupported(), SqlJetErrorCode.CORRUPT);
        this.btree.updateMeta(5, encoding.getValue());
    }

    private void writeIncrementalVacuum(boolean incrementalVacuum) throws SqlJetException {
        this.btree.updateMeta(7, incrementalVacuum ? 1 : 0);
    }

    private void writeAutoVacuum(boolean autovacuum) throws SqlJetException {
        this.btree.updateMeta(4, autovacuum ? 1 : 0);
    }

    private void writePageCacheSize() throws SqlJetException {
        this.checkPageCacheSize();
        this.btree.updateMeta(3, this.pageCacheSize);
    }

    private void checkPageCacheSize() throws SqlJetException {
        if (this.pageCacheSize < 10) {
            this.pageCacheSize = 2000;
        }
    }

    private void writeFileFormat(int fileFormat) throws SqlJetException {
        this.checkFileFormat(fileFormat);
        this.btree.updateMeta(2, fileFormat);
    }

    @Override
    public void setUserVersion(int userCookie) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            SqlJetAssert.assertTrue(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can be performed only in active transaction");
            this.userCookie = userCookie;
            this.writeUserCookie(this.userCookie);
        });
    }

    private void writeUserCookie(int userCookie) throws SqlJetException {
        this.btree.updateMeta(6, userCookie);
    }

    private void checkSchema() throws SqlJetException {
        if (this.readSchemaCookie() != 1) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
    }

    @Override
    public void setFileFormat(int fileFormat) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            this.checkSchema();
            SqlJetAssert.assertFalse(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can't be performed in active transaction");
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.fileFormat = fileFormat;
                this.writeFileFormat(this.fileFormat);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        });
    }

    @Override
    public void setCacheSize(int pageCacheSize) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            SqlJetAssert.assertTrue(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can be performed only in active transaction");
            this.pageCacheSize = pageCacheSize;
            this.writePageCacheSize();
        });
    }

    @Override
    public void setAutovacuum(boolean autovacuum) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            this.checkSchema();
            SqlJetAssert.assertFalse(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can't be performed in active transaction");
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.autovacuumMode = this.autovacuumMode.changeVacuumMode(autovacuum);
                this.writeAutoVacuum(autovacuum);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        });
    }

    @Override
    public void setEncoding(SqlJetEncoding encoding) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            this.checkSchema();
            SqlJetAssert.assertFalse(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can't be performed in active transaction");
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.encoding = encoding;
                this.writeEncoding(this.encoding);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        });
    }

    @Override
    public void setIncrementalVacuum(boolean incrementalVacuum) throws SqlJetException {
        this.dbHandle.getMutex().runVoid(x -> {
            this.checkSchema();
            SqlJetAssert.assertFalse(this.btree.isInTrans(), SqlJetErrorCode.MISUSE, "It can't be performed in active transaction");
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.autovacuumMode = this.autovacuumMode.changeIncrMode(incrementalVacuum);
                this.writeIncrementalVacuum(incrementalVacuum);
                this.btree.commit();
            }
            catch (SqlJetException e) {
                this.btree.rollback();
                throw e;
            }
        });
    }
}

