/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Optional;
import java.util.Random;
import java.util.Stack;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;

public class SqlJetBtreeTable
implements ISqlJetBtreeTable {
    protected final ISqlJetBtree btree;
    protected final int rootPage;
    protected boolean write;
    protected boolean index;
    private long priorNewRowid = 0L;
    private SqlJetBtreeRecord recordCache;
    private Object[] valuesCache;
    private final Stack<State> states = new Stack();

    public SqlJetBtreeTable(ISqlJetBtree btree, int rootPage, boolean write, boolean index) throws SqlJetException {
        this.btree = btree;
        this.rootPage = rootPage;
        this.write = write;
        this.index = index;
        this.pushState();
        this.first();
    }

    private State getCurrentState() {
        assert (!this.states.isEmpty());
        return this.states.peek();
    }

    protected ISqlJetBtreeCursor getCursor() {
        return this.getCurrentState().getCursor();
    }

    protected SqlJetKeyInfo getKeyInfo() {
        return this.getCurrentState().getKeyInfo();
    }

    @Override
    public void pushState() throws SqlJetException {
        SqlJetKeyInfo keyInfo = null;
        if (this.index) {
            keyInfo = new SqlJetKeyInfo(this.btree.getDb().getOptions().getEncoding());
        }
        ISqlJetBtreeCursor cursor = this.btree.getCursor(this.rootPage, this.write, keyInfo);
        this.states.push(new State(cursor, keyInfo));
        this.clearRecordCache();
        this.adjustKeyInfo();
    }

    protected void adjustKeyInfo() throws SqlJetException {
    }

    @Override
    public boolean popState() throws SqlJetException {
        if (this.states.size() <= 1) {
            return false;
        }
        State oldState = this.states.pop();
        oldState.close();
        this.clearRecordCache();
        return true;
    }

    @Override
    public void close() throws SqlJetException {
        for (State s : this.states) {
            s.close();
        }
        this.states.clear();
        this.clearRecordCache();
    }

    @Override
    public boolean eof() throws SqlJetException {
        this.hasMoved();
        return this.getCursor().eof();
    }

    @Override
    public boolean hasMoved() throws SqlJetException {
        return this.getCursor().cursorHasMoved();
    }

    @Override
    public boolean first() throws SqlJetException {
        this.clearRecordCache();
        return !this.getCursor().first();
    }

    @Override
    public boolean last() throws SqlJetException {
        this.clearRecordCache();
        return !this.getCursor().last();
    }

    @Override
    public boolean next() throws SqlJetException {
        this.clearRecordCache();
        this.hasMoved();
        return !this.getCursor().next();
    }

    @Override
    public boolean previous() throws SqlJetException {
        this.clearRecordCache();
        this.hasMoved();
        return !this.getCursor().previous();
    }

    @Override
    public ISqlJetBtreeRecord getRecord() throws SqlJetException {
        if (this.eof()) {
            return null;
        }
        if (this.recordCache == null) {
            this.recordCache = new SqlJetBtreeRecord(this.getCursor(), this.index, this.btree.getDb().getOptions().getFileFormat());
        }
        return this.recordCache;
    }

    @Override
    public SqlJetEncoding getEncoding() throws SqlJetException {
        return this.getCursor().getCursorDb().getOptions().getEncoding();
    }

    protected static boolean checkField(ISqlJetBtreeRecord record, int field) throws SqlJetException {
        return field >= 0 && record != null && field < record.getFieldsCount();
    }

    protected Optional<ISqlJetVdbeMem> getValueMem(int field) throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (!SqlJetBtreeTable.checkField(r, field)) {
            return Optional.empty();
        }
        return Optional.of(r.getRawField(field));
    }

    @Override
    public Object getValue(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::toObject).orElse(null);
    }

    @Override
    public int getFieldsCount() throws SqlJetException {
        ISqlJetBtreeRecord r = this.getRecord();
        if (r == null) {
            return 0;
        }
        return r.getFieldsCount();
    }

    @Override
    public boolean isNull(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::isNull).orElse(Boolean.TRUE);
    }

    @Override
    public String getString(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::stringValue).orElse(null);
    }

    @Override
    public long getInteger(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::intValue).orElse(0L);
    }

    @Override
    public double getFloat(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::realValue).orElse(0.0);
    }

    @Override
    public SqlJetValueType getFieldType(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::getType).orElse(SqlJetValueType.NULL);
    }

    @Override
    public Optional<ISqlJetMemoryPointer> getBlob(int field) throws SqlJetException {
        return this.getValueMem(field).map(ISqlJetVdbeMem::blobValue);
    }

    @Override
    public Object[] getValues() throws SqlJetException {
        if (this.valuesCache != null) {
            return this.valuesCache;
        }
        ISqlJetBtreeRecord record = this.getRecord();
        int fieldsCount = record.getFieldsCount();
        this.valuesCache = new Object[fieldsCount];
        int i = 0;
        while (i < fieldsCount) {
            this.valuesCache[i] = this.getValue(i);
            ++i;
        }
        return this.valuesCache;
    }

    @Override
    public long newRowId() throws SqlJetException {
        return this.newRowId(0L);
    }

    @Override
    public long newRowId(long prev) throws SqlJetException {
        int flags = this.getCursor().flags();
        SqlJetAssert.assertTrue(SqlJetBtreeTableCreateFlags.INTKEY.hasFlag(flags) && !SqlJetBtreeTableCreateFlags.ZERODATA.hasFlag(flags), SqlJetErrorCode.CORRUPT);
        boolean useRandomRowid = false;
        long v = 0L;
        int res = 0;
        int cnt = 0;
        long MAX_ROWID = Integer.MAX_VALUE;
        boolean last = this.getCursor().last();
        if (last) {
            v = 1L;
        } else {
            v = this.getCursor().getKeySize();
            if (v == MAX_ROWID) {
                useRandomRowid = true;
            } else {
                ++v;
            }
            if (prev != 0L) {
                if (prev == MAX_ROWID || useRandomRowid) {
                    throw new SqlJetException(SqlJetErrorCode.FULL);
                }
                if (v < prev) {
                    v = prev + 1L;
                }
            }
            if (useRandomRowid) {
                v = this.priorNewRowid;
                Random random = new Random();
                assert (prev == 0L);
                cnt = 0;
                do {
                    if (cnt == 0 && (v & 0xFFFFFFL) == v) {
                        ++v;
                    } else {
                        v = random.nextInt();
                        if (cnt < 5) {
                            v &= 0xFFFFFFL;
                        }
                    }
                    if (v == 0L) continue;
                    res = this.getCursor().moveToUnpacked(null, v, false);
                    ++cnt;
                } while (cnt < 100 && res == 0);
                this.priorNewRowid = v;
                if (res == 0) {
                    throw new SqlJetException(SqlJetErrorCode.FULL);
                }
            }
        }
        return v;
    }

    protected void clearRecordCache() {
        this.recordCache = null;
        this.valuesCache = null;
    }

    @Override
    public void clear() throws SqlJetException {
        this.btree.clearTable(this.rootPage, null);
    }

    @Override
    public long getKeySize() throws SqlJetException {
        return this.getCursor().getKeySize();
    }

    @Override
    public int moveTo(ISqlJetMemoryPointer pKey, long nKey, boolean bias) throws SqlJetException {
        this.clearRecordCache();
        return this.getCursor().moveTo(pKey, nKey, bias);
    }

    @Override
    public void insert(ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int nZero, boolean bias) throws SqlJetException {
        this.clearRecordCache();
        this.getCursor().insert(pKey, nKey, pData, nData, nZero, bias);
    }

    @Override
    public void delete() throws SqlJetException {
        this.clearRecordCache();
        this.getCursor().delete();
    }

    protected static class State {
        private final ISqlJetBtreeCursor cursor;
        private final SqlJetKeyInfo keyInfo;

        public State(ISqlJetBtreeCursor cursor, SqlJetKeyInfo keyInfo) {
            this.cursor = cursor;
            this.keyInfo = keyInfo;
        }

        public ISqlJetBtreeCursor getCursor() {
            return this.cursor;
        }

        public SqlJetKeyInfo getKeyInfo() {
            return this.keyInfo;
        }

        public void close() throws SqlJetException {
            if (this.cursor != null) {
                this.cursor.closeCursor();
            }
        }
    }
}

