/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;

public class SqlJetVirtualTableDef
implements ISqlJetVirtualTableDef {
    private final String tableName;
    private final String databaseName;
    private final String moduleName;
    private final List<ISqlJetColumnDef> moduleColumns;
    private int page;
    private long rowId;

    public SqlJetVirtualTableDef(CommonTree ast, int page) throws SqlJetException {
        CommonTree defNode;
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.tableName = nameNode.getText();
        this.databaseName = nameNode.getChildCount() > 0 ? nameNode.getChild(0).getText() : null;
        CommonTree moduleNode = (CommonTree)ast.getChild(2);
        this.moduleName = moduleNode.getText();
        ArrayList<SqlJetColumnDef> moduleColumns = new ArrayList<SqlJetColumnDef>();
        if (ast.getChildCount() > 3 && "columns".equalsIgnoreCase((defNode = (CommonTree)ast.getChild(3)).getText())) {
            int i = 0;
            while (i < defNode.getChildCount()) {
                moduleColumns.add(new SqlJetColumnDef((CommonTree)defNode.getChild(i)));
                ++i;
            }
        }
        this.moduleColumns = Collections.unmodifiableList(moduleColumns);
        this.page = page;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public List<ISqlJetColumnDef> getModuleColumns() {
        return this.moduleColumns;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public long getRowId() {
        return this.rowId;
    }

    @Override
    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getPage());
        buffer.append("/");
        buffer.append(this.getRowId());
        buffer.append(": ");
        buffer.append(this.toSQL(false));
        return buffer.toString();
    }

    @Override
    public String toSQL() {
        return this.toSQL(true);
    }

    public String toSQL(boolean schemaStrict) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE VIRTUAL TABLE ");
        if (!schemaStrict && this.getDatabaseName() != null) {
            buffer.append(this.getDatabaseName());
            buffer.append('.');
        }
        buffer.append(this.getTableName());
        buffer.append(" USING ");
        buffer.append(this.getModuleName());
        if (!this.moduleColumns.isEmpty()) {
            buffer.append(" (");
            boolean first = true;
            for (ISqlJetColumnDef cd : this.moduleColumns) {
                if (!first) {
                    buffer.append(", ");
                }
                first = false;
                buffer.append(cd.toString());
            }
            buffer.append(')');
        }
        return buffer.toString();
    }
}

