/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableForeignKey;

public class SqlJetTableForeignKey
extends SqlJetTableConstraint
implements ISqlJetTableForeignKey {
    private final List<String> columnNames;
    private final ISqlJetForeignKey foreignKey;

    public SqlJetTableForeignKey(String name, CommonTree ast) {
        super(name);
        assert ("foreign".equalsIgnoreCase(ast.getText()));
        CommonTree columnsNode = (CommonTree)ast.getChild(1);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()) || "references".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columnNames = new ArrayList<String>();
        int i = 0;
        while (i < columnsNode.getChildCount()) {
            columnNames.add(columnsNode.getChild(i).getText());
            ++i;
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.foreignKey = new SqlJetForeignKey((CommonTree)ast.getChild(1));
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public ISqlJetForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append("FOREIGN KEY (");
        int i = 0;
        while (i < this.getColumnNames().size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumnNames().get(i));
            ++i;
        }
        buffer.append(") ");
        buffer.append(this.foreignKey);
        return buffer.toString();
    }
}

