/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetMatchExpression;

public class SqlJetMatchExpression
extends SqlJetExpression
implements ISqlJetMatchExpression {
    private final ISqlJetMatchExpression.Operation operation;
    private final boolean not;
    private final ISqlJetExpression expression;
    private final ISqlJetExpression matchExpression;
    private final ISqlJetExpression escapeExpression;

    public SqlJetMatchExpression(CommonTree ast) throws SqlJetException {
        this.operation = ISqlJetMatchExpression.Operation.decode(ast.getText());
        assert (this.operation != null);
        this.matchExpression = SqlJetMatchExpression.create((CommonTree)ast.getChild(0));
        boolean not = false;
        ISqlJetExpression expression = null;
        ISqlJetExpression escapeExpression = null;
        int i = 1;
        while (i < ast.getChildCount()) {
            CommonTree child = (CommonTree)ast.getChild(1);
            if ("not".equalsIgnoreCase(child.getText())) {
                not = true;
            } else if ("escape".equalsIgnoreCase(child.getText())) {
                escapeExpression = SqlJetMatchExpression.create((CommonTree)child.getChild(0));
            } else {
                expression = SqlJetMatchExpression.create(child);
            }
            ++i;
        }
        assert (expression != null);
        this.not = not;
        this.expression = expression;
        this.escapeExpression = escapeExpression;
    }

    @Override
    public ISqlJetExpression getExpression() {
        return this.expression;
    }

    @Override
    public ISqlJetMatchExpression.Operation getOperation() {
        return this.operation;
    }

    @Override
    public boolean isNot() {
        return this.not;
    }

    @Override
    public ISqlJetExpression getMatchExpression() {
        return this.matchExpression;
    }

    @Override
    public ISqlJetExpression getEscapeExpression() {
        return this.escapeExpression;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getExpression());
        if (this.isNot()) {
            buffer.append(" NOT");
        }
        buffer.append(' ');
        buffer.append((Object)this.getOperation());
        buffer.append(' ');
        buffer.append(this.getMatchExpression());
        if (this.getEscapeExpression() != null) {
            buffer.append(" ESCAPE ");
            buffer.append(this.getEscapeExpression());
        }
        return buffer.toString();
    }
}

