/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetInValuesExpression;

public class SqlJetInValuesExpression
extends SqlJetExpression
implements ISqlJetInValuesExpression {
    private final ISqlJetExpression expression;
    private final boolean not;
    private final List<ISqlJetExpression> values;

    public SqlJetInValuesExpression(CommonTree ast) throws SqlJetException {
        CommonTree child;
        assert ("in_values".equalsIgnoreCase(ast.getText()));
        int idx = 0;
        if ("not".equalsIgnoreCase((child = (CommonTree)ast.getChild(idx++)).getText())) {
            this.not = true;
            child = (CommonTree)ast.getChild(idx++);
        } else {
            this.not = false;
        }
        assert ("in".equalsIgnoreCase(child.getText()));
        ArrayList<ISqlJetExpression> values = new ArrayList<ISqlJetExpression>();
        int exprIdx = 0;
        while (exprIdx < child.getChildCount()) {
            values.add(SqlJetInValuesExpression.create((CommonTree)child.getChild(exprIdx)));
            ++exprIdx;
        }
        this.values = Collections.unmodifiableList(values);
        this.expression = SqlJetInValuesExpression.create((CommonTree)ast.getChild(idx));
    }

    @Override
    public ISqlJetExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isNot() {
        return this.not;
    }

    @Override
    public List<ISqlJetExpression> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getExpression());
        if (this.isNot()) {
            buffer.append(" NOT");
        }
        buffer.append(" IN (");
        int idx = 0;
        while (idx < this.getValues().size()) {
            if (idx > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getValues().get(idx));
            ++idx;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

