/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyDeferrable;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyMatchAction;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyUpdateAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyDeferrable;

public class SqlJetForeignKey
implements ISqlJetForeignKey {
    private final String foreignTableName;
    private final List<String> columnNames;
    private final List<ISqlJetForeignKeyAction> actions;
    private final ISqlJetForeignKeyDeferrable deferrable;

    public SqlJetForeignKey(CommonTree ast) {
        assert ("references".equalsIgnoreCase(ast.getText()));
        this.foreignTableName = ast.getChild(0).getText();
        CommonTree columnsNode = (CommonTree)ast.getChild(1);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columnNames = new ArrayList<String>();
        int i = 0;
        while (i < columnsNode.getChildCount()) {
            columnNames.add(columnsNode.getChild(i).getText());
            ++i;
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        ArrayList<ISqlJetForeignKeyAction> actions = new ArrayList<ISqlJetForeignKeyAction>();
        SqlJetForeignKeyDeferrable deferrable = null;
        int i2 = 2;
        while (i2 < ast.getChildCount()) {
            CommonTree child = (CommonTree)ast.getChild(i2);
            if ("deferrable".equalsIgnoreCase(child.getText())) {
                assert (deferrable == null);
                deferrable = new SqlJetForeignKeyDeferrable(child);
            } else if ("on".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyUpdateAction(child));
            } else if ("match".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyMatchAction(child));
            } else assert (false);
            ++i2;
        }
        this.actions = Collections.unmodifiableList(actions);
        this.deferrable = deferrable;
    }

    @Override
    public String getForeignTableName() {
        return this.foreignTableName;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<ISqlJetForeignKeyAction> getActions() {
        return this.actions;
    }

    @Override
    public ISqlJetForeignKeyDeferrable getDeferrable() {
        return this.deferrable;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("REFERENCES ");
        buffer.append(this.getForeignTableName());
        buffer.append(" (");
        int i = 0;
        while (i < this.getColumnNames().size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumnNames().get(i));
            ++i;
        }
        buffer.append(")");
        i = 0;
        while (i < this.getActions().size()) {
            buffer.append(' ');
            buffer.append(this.getActions().get(i));
            ++i;
        }
        if (this.getDeferrable() != null) {
            buffer.append(' ');
            buffer.append(this.getDeferrable());
        }
        return buffer.toString();
    }
}

