/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;

public class SqlJetColumnPrimaryKey
extends SqlJetColumnIndexConstraint
implements ISqlJetColumnPrimaryKey {
    private Boolean ascending;
    private boolean autoincremented;
    private SqlJetConflictAction conflictAction;

    public SqlJetColumnPrimaryKey(SqlJetColumnDef column, String name, CommonTree ast) {
        super(column, name);
        assert ("primary".equalsIgnoreCase(ast.getText()));
        int i = 0;
        while (i < ast.getChildCount()) {
            CommonTree child = (CommonTree)ast.getChild(i);
            if ("asc".equalsIgnoreCase(child.getText())) {
                this.ascending = Boolean.TRUE;
            } else if ("desc".equalsIgnoreCase(child.getText())) {
                this.ascending = Boolean.FALSE;
            } else if ("autoincrement".equalsIgnoreCase(child.getText())) {
                this.autoincremented = true;
            } else if ("conflict".equalsIgnoreCase(child.getText())) {
                assert (child.getChildCount() == 1);
                child = (CommonTree)child.getChild(0);
                this.conflictAction = SqlJetConflictAction.decode(child.getText());
            } else assert (false);
            ++i;
        }
    }

    @Override
    public Boolean isAscending() {
        return this.ascending;
    }

    @Override
    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    @Override
    public SqlJetConflictAction getConflictAction() {
        return this.conflictAction;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append("PRIMARY KEY");
        if (this.ascending == Boolean.TRUE) {
            buffer.append(" ASC");
        }
        if (this.ascending == Boolean.FALSE) {
            buffer.append(" DESC");
        }
        if (this.conflictAction != null) {
            buffer.append(" ON CONFLICT ");
            buffer.append((Object)this.conflictAction);
        }
        if (this.autoincremented) {
            buffer.append(" AUTOINCREMENT");
        }
        return buffer.toString();
    }
}

