/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnExpression;

public class SqlJetColumnExpression
extends SqlJetExpression
implements ISqlJetColumnExpression {
    private final String columnName;
    private final String tableName;
    private final String databaseName;

    public SqlJetColumnExpression(CommonTree ast) {
        assert ("column_expression".equalsIgnoreCase(ast.getText()));
        CommonTree columnNode = (CommonTree)ast.getChild(0);
        this.columnName = columnNode.getText();
        if (columnNode.getChildCount() > 0) {
            CommonTree tableNode = (CommonTree)columnNode.getChild(0);
            this.tableName = tableNode.getText();
            this.databaseName = tableNode.getChildCount() > 0 ? tableNode.getChild(0).getText() : null;
        } else {
            this.tableName = null;
            this.databaseName = null;
        }
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getDatabaseName() != null) {
            buffer.append(this.getDatabaseName());
            buffer.append('.');
        }
        if (this.getTableName() != null) {
            buffer.append(this.getTableName());
            buffer.append('.');
        }
        buffer.append(this.getColumnName());
        return buffer.toString();
    }
}

