/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetCaseExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;

public class SqlJetCaseExpression
extends SqlJetExpression
implements ISqlJetCaseExpression {
    private final ISqlJetExpression expression;
    private final ISqlJetExpression defaultValue;
    private final List<ISqlJetExpression> conditions;
    private final List<ISqlJetExpression> values;

    public SqlJetCaseExpression(CommonTree ast) throws SqlJetException {
        CommonTree child;
        assert ("case".equalsIgnoreCase(ast.getText()));
        int idx = 0;
        if ("when".equalsIgnoreCase((child = (CommonTree)ast.getChild(idx++)).getText())) {
            this.expression = null;
        } else {
            this.expression = SqlJetCaseExpression.create(child);
            child = (CommonTree)ast.getChild(idx++);
        }
        ArrayList<ISqlJetExpression> conditions = new ArrayList<ISqlJetExpression>();
        ArrayList<ISqlJetExpression> values = new ArrayList<ISqlJetExpression>();
        while (idx < ast.getChildCount()) {
            if (!"when".equalsIgnoreCase(child.getText())) break;
            ISqlJetExpression condition = SqlJetCaseExpression.create((CommonTree)child.getChild(0));
            ISqlJetExpression value = SqlJetCaseExpression.create((CommonTree)child.getChild(1));
            conditions.add(condition);
            values.add(value);
            child = (CommonTree)ast.getChild(idx++);
        }
        this.conditions = Collections.unmodifiableList(conditions);
        this.values = Collections.unmodifiableList(values);
        this.defaultValue = idx < child.getChildCount() ? SqlJetCaseExpression.create(child) : null;
    }

    @Override
    public ISqlJetExpression getExpression() {
        return this.expression;
    }

    @Override
    public List<ISqlJetExpression> getConditions() {
        return this.conditions;
    }

    @Override
    public List<ISqlJetExpression> getValues() {
        return this.values;
    }

    @Override
    public ISqlJetExpression getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CASE ");
        if (this.getExpression() != null) {
            buffer.append(this.getExpression());
            buffer.append(' ');
        }
        int idx = 0;
        while (idx < this.getConditions().size()) {
            buffer.append("WHEN ");
            buffer.append(this.getConditions().get(idx));
            buffer.append(' ');
            buffer.append(this.getValues().get(idx));
            buffer.append(' ');
            ++idx;
        }
        if (this.getDefaultValue() != null) {
            buffer.append("ELSE ");
            buffer.append(this.getDefaultValue());
            buffer.append(' ');
        }
        buffer.append("END");
        return buffer.toString();
    }
}

