/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.io.File;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetLimits;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerLockingMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetPager
implements ISqlJetPager,
ISqlJetLimits,
ISqlJetPageCallback {
    private static final String SQLJET_LOG_PAGER_PROP = "SQLJET_LOG_PAGER";
    private static Logger pagerLogger = Logger.getLogger("SQLJET_LOG_PAGER");
    private static final boolean SQLJET_LOG_PAGER = SqlJetUtility.getBoolSysProp("SQLJET_LOG_PAGER", false);
    private static final int MAX_SECTOR_SIZE = 0x100000;
    private final ISqlJetFileSystem fileSystem;
    private final SqlJetFileType type;
    private final Set<SqlJetFileOpenPermission> permissions;
    protected SqlJetPagerState state = SqlJetPagerState.UNLOCK;
    private SqlJetPagerJournalMode journalMode = SqlJetPagerJournalMode.DELETE;
    private SqlJetPagerLockingMode lockingMode = SqlJetPagerLockingMode.NORMAL;
    protected boolean journalOpen;
    protected boolean journalStarted;
    protected final boolean useJournal;
    private final boolean noReadlock;
    protected boolean noSync;
    private boolean fullSync;
    private final boolean tempFile;
    protected final boolean readOnly;
    protected boolean needSync;
    protected boolean dirtyCache;
    protected final boolean memDb;
    protected boolean doNotSync;
    protected boolean dbModified;
    private boolean changeCountDone;
    private boolean dbSizeValid;
    protected int dbSize;
    protected int dbOrigSize;
    private int dbFileSize;
    protected int nRec;
    private long cksumInit;
    protected int pageSize;
    private int mxPgno;
    protected BitSet pagesInJournal;
    protected final BitSet pagesAlwaysRollback = new BitSet();
    private final File fileName;
    private final File journal;
    private final File directory;
    private final ISqlJetFile fd;
    protected ISqlJetFile jfd;
    protected long journalOff;
    private long journalHdr;
    protected int sectorSize;
    private final ISqlJetMemoryPointer dbFileVers = SqlJetUtility.memoryManager.allocatePtr(16);
    private final long journalSizeLimit;
    protected final ISqlJetPageCache pageCache;
    private SqlJetSafetyLevel safetyLevel;
    private ISqlJetPageCallback reiniter;
    private ISqlJetBusyHandler busyHandler;
    protected SqlJetErrorCode errCode;
    private static final Random RND = new Random();

    static void PAGERTRACE(String format, Object ... args) {
        if (SQLJET_LOG_PAGER) {
            SqlJetUtility.log(pagerLogger, format, args);
        }
    }

    String PAGERID() {
        return this.fileName != null ? this.fileName.getPath() : null;
    }

    String FILEHANDLEID() {
        return this.PAGERID();
    }

    private int JOURNAL_PG_SZ() {
        return this.pageSize + 8;
    }

    private int getSectorSize() {
        return this.sectorSize;
    }

    long PAGER_MJ_PGNO() {
        return 0x40000000L / (long)this.pageSize + 1L;
    }

    int int_PAGER_MJ_PGNO() {
        return Long.valueOf(this.PAGER_MJ_PGNO()).intValue();
    }

    public SqlJetPager(ISqlJetFileSystem fileSystem, File fileName, Set<SqlJetPagerFlags> flags, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        this.fileSystem = fileSystem;
        this.type = type;
        this.permissions = EnumSet.copyOf(permissions);
        int szPageDflt = 1024;
        boolean bl = this.useJournal = !flags.contains((Object)SqlJetPagerFlags.OMIT_JOURNAL);
        if (fileName != null) {
            if (":memory:".equals(fileName.getPath())) {
                this.memDb = true;
                this.fileName = null;
            } else {
                this.memDb = false;
                this.fileName = fileName;
            }
        } else {
            this.fileName = null;
            this.memDb = false;
        }
        if (this.fileName != null && !this.memDb) {
            this.tempFile = false;
            this.lockingMode = SqlJetPagerLockingMode.NORMAL;
            this.directory = this.fileName.getParentFile();
            this.journal = new File(this.directory, String.valueOf(this.fileName.getName()) + "-journal");
            this.fd = this.fileSystem.open(this.fileName, this.type, this.permissions);
            this.readOnly = this.fd.getPermissions().contains((Object)SqlJetFileOpenPermission.READONLY);
            if (!this.readOnly) {
                this.setSectorSize();
                if (szPageDflt < this.sectorSize) {
                    szPageDflt = this.sectorSize;
                }
                if (szPageDflt > 8192) {
                    szPageDflt = 8192;
                }
            }
        } else {
            this.directory = null;
            this.journal = null;
            this.readOnly = false;
            this.tempFile = true;
            this.state = SqlJetPagerState.EXCLUSIVE;
            this.lockingMode = SqlJetPagerLockingMode.EXCLUSIVE;
            this.fd = this.memDb ? null : this.openTemp(type);
        }
        this.pageCache = new SqlJetPageCache(szPageDflt, !this.memDb, !this.memDb ? this : null);
        SqlJetPager.PAGERTRACE("OPEN %s %s\n", this.FILEHANDLEID(), fileName);
        this.noReadlock = flags.contains((Object)SqlJetPagerFlags.NO_READLOCK) && this.readOnly;
        this.dbSizeValid = this.memDb;
        this.pageSize = szPageDflt;
        this.mxPgno = 0x3FFFFFFF;
        this.noSync = this.tempFile || !this.useJournal;
        this.fullSync = !this.noSync;
        this.journalSizeLimit = SQLJET_DEFAULT_JOURNAL_SIZE_LIMIT;
        this.setSectorSize();
        if (this.memDb) {
            this.journalMode = SqlJetPagerJournalMode.MEMORY;
        }
        this.setSafetyLevel(SqlJetSafetyLevel.NORMAL);
    }

    private void setSectorSize() {
        assert (this.fd != null || this.tempFile);
        if (!this.tempFile && this.fd != null) {
            this.sectorSize = this.fd.sectorSize();
        }
        if (this.sectorSize < SQLJET_MIN_SECTOR_SIZE) {
            this.sectorSize = SQLJET_MIN_SECTOR_SIZE;
        }
        if (this.sectorSize > 0x100000) {
            this.sectorSize = 0x100000;
        }
    }

    @Override
    public File getDirectoryName() {
        return this.directory;
    }

    @Override
    public File getFileName() {
        return this.fileName;
    }

    @Override
    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public ISqlJetFile getFile() {
        return this.fd;
    }

    @Override
    public File getJournalName() {
        return this.journal;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public SqlJetPagerLockingMode getLockingMode() {
        return this.lockingMode;
    }

    @Override
    public void setLockingMode(SqlJetPagerLockingMode lockingMode) {
        this.lockingMode = lockingMode;
    }

    @Override
    public SqlJetPagerJournalMode getJournalMode() {
        return this.journalMode;
    }

    @Override
    public void setJournalMode(SqlJetPagerJournalMode journalMode) {
        this.journalMode = journalMode;
    }

    @Override
    public long getJournalSizeLimit() {
        return this.journalSizeLimit;
    }

    @Override
    public SqlJetSafetyLevel getSafetyLevel() {
        return this.safetyLevel;
    }

    @Override
    public void setSafetyLevel(SqlJetSafetyLevel safetyLevel) {
        this.safetyLevel = safetyLevel;
        this.noSync = safetyLevel == SqlJetSafetyLevel.OFF || this.tempFile;
        boolean bl = this.fullSync = safetyLevel == SqlJetSafetyLevel.FULL && !this.tempFile;
        if (this.noSync) {
            this.needSync = false;
        }
    }

    @Override
    public ISqlJetMemoryPointer getTempSpace() {
        return SqlJetUtility.memoryManager.allocatePtr(this.pageSize);
    }

    @Override
    public void setBusyhandler(ISqlJetBusyHandler busyHandler) {
        this.busyHandler = busyHandler;
    }

    @Override
    public void setReiniter(ISqlJetPageCallback reinitier) {
        this.reiniter = reinitier;
    }

    @Override
    public int setPageSize(int pageSize) throws SqlJetException {
        this.checkErrorCode();
        SqlJetAssert.assertTrue(pageSize >= 512 && pageSize <= 32768, SqlJetErrorCode.CORRUPT);
        if (!(pageSize == this.pageSize || this.memDb && this.dbSize != 0 || this.pageCache.getRefCount() != 0)) {
            this.reset();
            this.pageSize = pageSize;
            if (!this.memDb) {
                this.setSectorSize();
            }
            this.pageCache.setPageSize(pageSize);
        }
        return this.pageSize;
    }

    private void checkErrorCode() throws SqlJetException {
        SqlJetAssert.assertNull((Object)this.errCode, this.errCode);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    ISqlJetPage lookup(int pageNumber) throws SqlJetException {
        return this.pageCache.fetch(pageNumber, false);
    }

    private void reset() {
        if (this.errCode != null) {
            return;
        }
        if (this.pageCache != null) {
            this.pageCache.clear();
        }
    }

    @Override
    public int getMaxPageCount() {
        return this.mxPgno;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.pageCache.setCacheSize(cacheSize);
    }

    @Override
    public int getCacheSize() {
        return this.pageCache.getCachesize();
    }

    @Override
    public void readFileHeader(int count, ISqlJetMemoryPointer buffer) throws SqlJetIOException {
        block4: {
            assert (this.fd != null || this.tempFile);
            if (this.fd != null) {
                try {
                    this.fd.read(buffer, count, 0L);
                }
                catch (SqlJetIOException e) {
                    if (SqlJetIOErrorCode.IOERR_SHORT_READ == e.getIoErrorCode()) break block4;
                    throw e;
                }
            }
        }
    }

    @Override
    public int getPageCount() throws SqlJetException {
        this.checkErrorCode();
        int n = 0;
        if (this.dbSizeValid) {
            n = this.dbSize;
        } else {
            assert (this.fd != null || this.tempFile);
            long l = 0L;
            if (this.fd != null) {
                try {
                    l = this.fd.fileSize();
                }
                catch (SqlJetException e) {
                    this.error(e);
                    throw e;
                }
            }
            n = l > 0L && l < (long)this.pageSize ? 1 : (int)(l / (long)this.pageSize);
            if (SqlJetPagerState.UNLOCK != this.state) {
                this.dbSize = n;
                this.dbFileSize = n;
                this.dbSizeValid = true;
            }
        }
        if ((long)n == 0x40000000L / (long)this.pageSize) {
            ++n;
        }
        if (n > this.mxPgno) {
            this.mxPgno = n;
        }
        return n;
    }

    private void error(SqlJetException e) {
        SqlJetErrorCode c = e.getErrorCode();
        if (SqlJetErrorCode.FULL == c || SqlJetErrorCode.IOERR == c || SqlJetErrorCode.CORRUPT == c) {
            this.errCode = c;
            if (SqlJetPagerState.UNLOCK == this.state && this.pageCache.getRefCount() == 0) {
                this.unlock();
            }
        }
    }

    private void unlock() {
        if (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode) {
            if (this.journalOpen) {
                if (this.jfd != null) {
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException sqlJetException) {
                        // empty catch block
                    }
                }
                this.journalOpen = false;
                this.pagesInJournal = null;
                this.pagesAlwaysRollback.clear();
            }
            SqlJetErrorCode errCode = null;
            try {
                if (this.fd != null) {
                    this.fd.unlock(SqlJetLockType.NONE);
                }
            }
            catch (SqlJetException e) {
                errCode = e.getErrorCode();
            }
            this.dbSizeValid = false;
            SqlJetPager.PAGERTRACE("UNLOCK %s\n", this.PAGERID());
            if (errCode != null) {
                errCode = null;
                this.reset();
                this.journalOff = 0L;
                this.journalStarted = false;
                this.dbOrigSize = 0;
            }
            this.state = SqlJetPagerState.UNLOCK;
            this.changeCountDone = false;
        }
    }

    @Override
    public void close() throws SqlJetException {
        this.errCode = null;
        this.lockingMode = SqlJetPagerLockingMode.NORMAL;
        this.reset();
        if (!this.memDb) {
            this.journalHdr = -1L;
            this.unlockAndRollback();
        }
        SqlJetPager.PAGERTRACE("CLOSE %s\n", this.PAGERID());
        if (this.journalOpen && this.jfd != null) {
            this.jfd.close();
        }
        this.pagesInJournal = null;
        this.pagesAlwaysRollback.clear();
        if (this.fd != null) {
            this.fd.close();
        }
        if (this.pageCache != null) {
            this.pageCache.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISqlJetPage acquirePage(int pageNumber, boolean read) throws SqlJetException {
        assert (this.state == SqlJetPagerState.UNLOCK || this.pageCache.getRefCount() > 0 || pageNumber == 1);
        if (pageNumber > Integer.MAX_VALUE || pageNumber == 0 || (long)pageNumber == 0x40000000L / (long)this.pageSize + 1L) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.sharedLock();
        assert (this.state != SqlJetPagerState.UNLOCK);
        ISqlJetPage page = this.pageCache.fetch(pageNumber, true);
        SqlJetAssert.assertNotNull(page, SqlJetErrorCode.INTERNAL, "Page cache is overflow");
        if (page.getPager() == null) {
            int nMax;
            page.setPager(this);
            try {
                nMax = this.getPageCount();
            }
            catch (SqlJetException e) {
                page.unref();
                throw e;
            }
            if (nMax < pageNumber || this.memDb || !read) {
                if (pageNumber > this.mxPgno) {
                    page.unref();
                    throw new SqlJetException(SqlJetErrorCode.FULL);
                }
                page.getData().fill(this.pageSize, (byte)0);
                if (!read) {
                    page.getFlags().add(SqlJetPageFlags.NEED_READ);
                }
                SqlJetPager.PAGERTRACE("ZERO %s %d\n", this.PAGERID(), pageNumber);
                return page;
            } else {
                try {
                    this.readDbPage(page, pageNumber);
                    return page;
                }
                catch (SqlJetIOException e) {
                    if (SqlJetIOErrorCode.IOERR_SHORT_READ == e.getIoErrorCode()) return page;
                    this.dropPage(page);
                    throw e;
                }
            }
        }
        assert (this.pageCache.getRefCount() > 0 || 1 == pageNumber);
        if (!read) return page;
        try {
            this.getContent(page);
            return page;
        }
        catch (SqlJetException e) {
            page.unref();
            throw e;
        }
    }

    void getContent(ISqlJetPage page) throws SqlJetIOException {
        Set<SqlJetPageFlags> flags = page.getFlags();
        if (flags.contains((Object)SqlJetPageFlags.NEED_READ)) {
            this.readDbPage(page, page.getPageNumber());
            flags.remove((Object)SqlJetPageFlags.NEED_READ);
        }
    }

    private void dropPage(ISqlJetPage page) throws SqlJetException {
        this.pageCache.drop(page);
        this.unlockIfUnused();
    }

    void unlockIfUnused() throws SqlJetException {
        if (this.pageCache.getRefCount() == 0 && (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode || this.journalOff > 0L)) {
            this.unlockAndRollback();
        }
    }

    private void unlockAndRollback() throws SqlJetException {
        if (this.errCode == null && SqlJetPagerState.RESERVED.compareTo(this.state) <= 0) {
            this.rollback();
        }
        this.unlock();
    }

    private void readDbPage(ISqlJetPage page, int pageNumber) throws SqlJetIOException {
        assert (!this.memDb);
        assert (this.fd != null || this.tempFile);
        if (this.fd == null) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_SHORT_READ);
        }
        long offset = (long)(pageNumber - 1) * (long)this.pageSize;
        ISqlJetMemoryPointer data = page.getData();
        this.fd.read(data, this.pageSize, offset);
        if (1 == pageNumber) {
            this.dbFileVers.copyFrom(0, data, 24, this.dbFileVers.remaining());
        }
        SqlJetPager.PAGERTRACE("FETCH %s page %d\n", this.PAGERID(), page.getPageNumber());
    }

    private void sharedLock() throws SqlJetException {
        boolean isErrorReset = false;
        if (!this.memDb && this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE && this.pageCache.getRefCount() == 0 && this.errCode != null) {
            if (this.journalOpen) {
                isErrorReset = true;
            }
            this.errCode = null;
            this.reset();
        }
        if (this.errCode != null && this.errCode != SqlJetErrorCode.FULL) {
            throw new SqlJetException(this.errCode);
        }
        if (SqlJetPagerState.UNLOCK == this.state || isErrorReset) {
            try {
                boolean isHotJournal = false;
                assert (!this.memDb);
                assert (this.pageCache.getRefCount() == 0);
                if (!this.noReadlock) {
                    try {
                        this.waitOnLock(SqlJetLockType.SHARED);
                    }
                    catch (SqlJetException e) {
                        assert (this.state == SqlJetPagerState.UNLOCK);
                        this.error(e);
                        throw e;
                    }
                } else if (this.state == SqlJetPagerState.UNLOCK) {
                    this.state = SqlJetPagerState.SHARED;
                }
                assert (SqlJetPagerState.SHARED == this.state);
                if (!isErrorReset) {
                    isHotJournal = this.hasHotJournal();
                }
                if (isErrorReset || isHotJournal) {
                    if (SqlJetPagerState.EXCLUSIVE.compareTo(this.state) > 0) {
                        try {
                            this.fd.lock(SqlJetLockType.EXCLUSIVE);
                        }
                        catch (SqlJetException e) {
                            this.error(e);
                            throw e;
                        }
                        this.state = SqlJetPagerState.EXCLUSIVE;
                    }
                    if (this.jfd == null) {
                        if (this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS)) {
                            assert (!this.tempFile);
                            this.jfd = this.fileSystem.open(this.journal, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE));
                            if (this.jfd != null) {
                                try {
                                    Set<SqlJetFileOpenPermission> p = this.jfd.getPermissions();
                                    if (p.contains((Object)SqlJetFileOpenPermission.READONLY)) {
                                        throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
                                    }
                                }
                                catch (SqlJetException e) {
                                    this.jfd.close();
                                    throw e;
                                }
                                this.journalOpen = true;
                            }
                        } else {
                            this.endTransaction(false);
                        }
                        this.journalStarted = false;
                        this.journalOff = 0L;
                        this.journalHdr = 0L;
                        try {
                            this.pageCache.clear();
                        }
                        finally {
                            if (this.jfd != null) {
                                try {
                                    this.playback(true);
                                }
                                catch (SqlJetException e) {
                                    this.error(e);
                                    throw e;
                                }
                            }
                        }
                        assert (SqlJetPagerState.SHARED == this.state || SqlJetPagerLockingMode.EXCLUSIVE == this.lockingMode && SqlJetPagerState.SHARED.compareTo(this.state) < 0);
                    }
                }
                if (this.pageCache.getPageCount() > 0) {
                    ISqlJetMemoryPointer dbFileVers = SqlJetUtility.memoryManager.allocatePtr(this.dbFileVers.remaining());
                    this.getPageCount();
                    if (this.errCode != null) {
                        throw new SqlJetException(this.errCode);
                    }
                    assert (this.dbSizeValid);
                    if (this.dbSize > 0) {
                        SqlJetPager.PAGERTRACE("CKVERS %s %d\n", this.PAGERID(), dbFileVers.remaining());
                        this.fd.read(dbFileVers, dbFileVers.remaining(), 24L);
                    } else {
                        dbFileVers.fill(dbFileVers.remaining(), (byte)0);
                    }
                    if (SqlJetUtility.memcmp(this.dbFileVers, dbFileVers, dbFileVers.remaining()) != 0) {
                        this.reset();
                    }
                }
                assert (SqlJetPagerLockingMode.EXCLUSIVE == this.lockingMode || SqlJetPagerState.SHARED == this.state);
            }
            catch (SqlJetException e) {
                this.unlock();
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void playback(boolean isHot) throws SqlJetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteMaster(String master) throws SqlJetException {
        File masterFile = new File(master);
        ISqlJetFile pMaster = this.fileSystem.open(masterFile, SqlJetFileType.MASTER_JOURNAL, EnumSet.of(SqlJetFileOpenPermission.READONLY));
        int nMasterJournal = (int)pMaster.fileSize();
        if (nMasterJournal > 0) {
            ISqlJetMemoryPointer zMasterJournal = SqlJetUtility.memoryManager.allocatePtr(nMasterJournal);
            pMaster.read(zMasterJournal, nMasterJournal, 0L);
            int nMasterPtr = 0;
            while (nMasterPtr < nMasterJournal) {
                int zMasterPtr = SqlJetUtility.strlen(zMasterJournal, nMasterPtr);
                String zJournal = SqlJetUtility.toString(zMasterJournal.pointer(nMasterPtr));
                File journalPath = new File(zJournal);
                boolean exists = this.fileSystem.access(journalPath, SqlJetFileAccesPermission.EXISTS);
                if (exists) {
                    try (ISqlJetFile pJournal = this.fileSystem.open(journalPath, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));){
                        String readJournal = this.readMasterJournal(pJournal);
                        if (readJournal != null && readJournal.equals(master)) {
                            return;
                        }
                    }
                }
                nMasterPtr += zMasterPtr + 1;
            }
        }
        this.fileSystem.delete(masterFile, false);
        return;
        finally {
            pMaster.close();
        }
    }

    private void endTransaction(boolean hasMaster) throws SqlJetException {
        SqlJetException rc = null;
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            return;
        }
        if (this.journalOpen) {
            this.pagesInJournal = null;
            this.pagesAlwaysRollback.clear();
            this.pageCache.cleanAll();
            this.dirtyCache = false;
            this.nRec = 0;
            if (this.journalMode == SqlJetPagerJournalMode.MEMORY) {
                boolean isMemoryJournal = this.jfd.isMemJournal();
                try {
                    this.jfd.close();
                }
                catch (SqlJetException sqlJetException) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (!isMemoryJournal) {
                    try {
                        this.fileSystem.delete(this.journal, false);
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            } else if (this.journalMode == SqlJetPagerJournalMode.TRUNCATE) {
                try {
                    this.jfd.truncate(0L);
                    this.journalOff = 0L;
                    this.journalStarted = false;
                }
                catch (SqlJetException e) {
                    rc = e;
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException sqlJetException) {
                        // empty catch block
                    }
                    this.journalOpen = false;
                }
            } else if (this.exclusiveMode() || this.journalMode == SqlJetPagerJournalMode.PERSIST) {
                try {
                    this.zeroJournalHdr(hasMaster);
                }
                catch (SqlJetException e) {
                    rc = e;
                    this.error(e);
                }
                this.journalOff = 0L;
                this.journalStarted = false;
            } else {
                assert (this.journalMode == SqlJetPagerJournalMode.DELETE);
                try {
                    this.jfd.truncate(0L);
                }
                catch (SqlJetIOException e) {
                    // empty catch block
                }
                try {
                    this.jfd.close();
                }
                catch (SqlJetException e) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (!this.tempFile) {
                    try {
                        if (!this.fileSystem.delete(this.journal, true)) {
                            rc = new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE);
                        }
                    }
                    catch (SqlJetException e) {
                        rc = e;
                    }
                }
            }
        } else assert (this.pagesInJournal == null);
        this.dbOrigSize = 0;
        this.needSync = false;
        this.pageCache.truncate(this.dbSize);
        if (!this.memDb) {
            this.dbSizeValid = false;
        }
        this.dbModified = false;
        if (!this.exclusiveMode()) {
            this.state = SqlJetPagerState.SHARED;
            this.changeCountDone = false;
            if (this.fd != null) {
                try {
                    this.fd.unlock(SqlJetLockType.SHARED);
                }
                catch (SqlJetException e) {
                    rc = e;
                }
            }
        } else if (this.state == SqlJetPagerState.SYNCED) {
            this.state = SqlJetPagerState.EXCLUSIVE;
        }
        if (rc != null) {
            throw rc;
        }
    }

    private void zeroJournalHdr(boolean doTruncate) throws SqlJetException {
        if (this.journalOff > 0L) {
            long sz;
            long iLimit = this.journalSizeLimit;
            if (doTruncate || iLimit == 0L) {
                this.jfd.truncate(0L);
            } else {
                ISqlJetMemoryPointer zeroHdr = SqlJetUtility.memoryManager.allocatePtr(28);
                this.jfd.write(zeroHdr, zeroHdr.remaining(), 0L);
            }
            if (!this.noSync) {
                this.jfd.sync();
            }
            if (iLimit > 0L && (sz = this.jfd.fileSize()) > iLimit) {
                this.jfd.truncate(iLimit);
            }
        }
    }

    private boolean exclusiveMode() {
        return this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE;
    }

    private long playbackOnePage(long pOffset, boolean isSavepnt, BitSet pDone) throws SqlJetException {
        assert (isSavepnt || pDone == null);
        ISqlJetMemoryPointer aData = this.getTempSpace();
        ISqlJetFile jfd = this.jfd;
        int pgno = this.read32bits(jfd, pOffset);
        jfd.read(aData, this.pageSize, pOffset + 4L);
        pOffset += (long)(this.pageSize + 4 + 4);
        SqlJetAssert.assertFalse(pgno == 0 || (long)pgno == this.PAGER_MJ_PGNO(), SqlJetErrorCode.DONE);
        if (pgno > this.dbSize || SqlJetUtility.bitSetTest(pDone, pgno)) {
            return pOffset;
        }
        long cksum = this.read32bitsUnsigned(jfd, pOffset - 4L);
        SqlJetAssert.assertFalse(!isSavepnt && this.cksum(aData) != cksum, SqlJetErrorCode.DONE);
        if (pDone != null) {
            pDone.set(pgno);
        }
        assert (this.state == SqlJetPagerState.RESERVED || this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
        ISqlJetPage pPg = this.lookup(pgno);
        SqlJetPager.PAGERTRACE("PLAYBACK %s page %d %s\n", this.PAGERID(), pgno, "main-journal");
        if (!(this.state.compareTo(SqlJetPagerState.EXCLUSIVE) < 0 || pPg != null && pPg.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC) || this.fd == null)) {
            long ofst = (long)(pgno - 1) * (long)this.pageSize;
            this.fd.write(aData, this.pageSize, ofst);
            if (pgno > this.dbFileSize) {
                this.dbFileSize = pgno;
            }
        }
        if (pPg != null) {
            ISqlJetMemoryPointer pData = pPg.getData();
            pData.copyFrom(aData, this.pageSize);
            if (this.reiniter != null) {
                this.reiniter.pageCallback(pPg);
            }
            if (!isSavepnt || this.journalOff <= this.journalHdr) {
                pPg.makeClean();
            }
            if (pgno == 1) {
                this.dbFileVers.copyFrom(0, pData, 24, this.dbFileVers.remaining());
            }
            pPg.release();
        }
        return pOffset;
    }

    long cksum(ISqlJetMemoryPointer data) {
        long cksum = this.cksumInit;
        int i = this.pageSize - 200;
        while (i > 0) {
            cksum += (long)data.getByteUnsigned(i);
            i -= 200;
        }
        return cksum;
    }

    private String readMasterJournal(ISqlJetFile journal) throws SqlJetException {
        ISqlJetMemoryPointer aMagic = SqlJetUtility.memoryManager.allocatePtr(8);
        long szJ = journal.fileSize();
        if (szJ < 16L) {
            return null;
        }
        int len = this.read32bits(journal, szJ - 16L);
        long cksum = this.read32bitsUnsigned(journal, szJ - 12L);
        journal.read(aMagic, aMagic.remaining(), szJ - 8L);
        if (SqlJetUtility.memcmp(aMagic, aJournalMagic, aMagic.remaining()) != 0) {
            return null;
        }
        ISqlJetMemoryPointer zMaster = SqlJetUtility.memoryManager.allocatePtr(len);
        journal.read(zMaster, len, szJ - 16L - (long)len);
        int u = 0;
        while (u < len) {
            cksum -= (long)zMaster.getByteUnsigned(u);
            ++u;
        }
        if (cksum > 0L) {
            return null;
        }
        return SqlJetUtility.toString(zMaster);
    }

    private int read32bits(ISqlJetFile fd, long offset) throws SqlJetIOException {
        ISqlJetMemoryPointer ac = SqlJetUtility.memoryManager.allocatePtr(4);
        fd.read(ac, ac.remaining(), offset);
        return ac.getInt();
    }

    private long read32bitsUnsigned(ISqlJetFile fd, long offset) throws SqlJetIOException {
        ISqlJetMemoryPointer ac = SqlJetUtility.memoryManager.allocatePtr(4);
        fd.read(ac, ac.remaining(), offset);
        return ac.getIntUnsigned();
    }

    private int[] readJournalHdr(long journalSize) throws SqlJetException {
        int[] result = new int[2];
        ISqlJetMemoryPointer aMagic = SqlJetUtility.memoryManager.allocatePtr(8);
        this.seekJournalHdr();
        if (this.journalOff + (long)this.getSectorSize() > journalSize) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        long jrnlOff = this.journalOff;
        this.jfd.read(aMagic, aMagic.remaining(), jrnlOff);
        jrnlOff += (long)aMagic.remaining();
        if (SqlJetUtility.memcmp(aMagic, aJournalMagic, aMagic.remaining()) != 0) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        int pNRec = this.read32bits(this.jfd, jrnlOff);
        this.cksumInit = this.read32bitsUnsigned(this.jfd, jrnlOff + 4L);
        int pDbSize = this.read32bits(this.jfd, jrnlOff + 8L);
        result[0] = pNRec;
        result[1] = pDbSize;
        if (this.journalOff == 0L) {
            int iPageSize = this.read32bits(this.jfd, jrnlOff + 16L);
            if (iPageSize < 512 || iPageSize > 32768 || (iPageSize - 1 & iPageSize) != 0) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.setPageSize(iPageSize);
            assert (this.pageSize == iPageSize);
            int iSectorSize = this.read32bits(this.jfd, jrnlOff + 12L);
            if ((iSectorSize & iSectorSize - 1) != 0 || iSectorSize < 512 || iSectorSize > 32768) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.sectorSize = iSectorSize;
        }
        this.journalOff += (long)this.getSectorSize();
        return result;
    }

    private long journalHdrOffset() {
        long offset = 0L;
        long c = this.journalOff;
        if (c > 0L) {
            offset = ((c - 1L) / (long)this.getSectorSize() + 1L) * (long)this.getSectorSize();
        }
        assert (offset % (long)this.getSectorSize() == 0L);
        assert (offset >= c);
        assert (offset - c < (long)this.getSectorSize());
        return offset;
    }

    private void seekJournalHdr() {
        this.journalOff = this.journalHdrOffset();
    }

    private boolean hasHotJournal() throws SqlJetException {
        boolean exists = false;
        boolean locked = false;
        assert (this.useJournal);
        assert (this.fd != null);
        exists = this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS);
        if (exists) {
            locked = this.fd.checkReservedLock();
        }
        if (exists && !locked) {
            if (this.getPageCount() == 0) {
                this.fileSystem.delete(this.journal, false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void waitOnLock(SqlJetLockType lockType) throws SqlJetException {
        assert (SqlJetPagerState.SHARED.compareTo(this.state) <= 0 || !this.dbSizeValid);
        if (this.state.getLockType().compareTo(lockType) < 0) {
            boolean wait;
            boolean lock = false;
            int n = 0;
            while (((lock = this.fd.lock(lockType)) || this.busyHandler == null || (wait = this.busyHandler.call(n++))) && !lock) {
            }
            if (lock) {
                this.state = SqlJetPagerState.getPagerState(lockType);
            } else {
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    @Override
    public ISqlJetPage getPage(int pageNumber) throws SqlJetException {
        return this.acquirePage(pageNumber, true);
    }

    @Override
    public ISqlJetPage lookupPage(int pageNumber) throws SqlJetException {
        assert (pageNumber != 0);
        if (this.state != SqlJetPagerState.UNLOCK && (this.errCode == null || this.errCode == SqlJetErrorCode.FULL)) {
            return this.pageCache.fetch(pageNumber, false);
        }
        return null;
    }

    @Override
    public void truncateImage(int pagesNumber) {
        assert (this.dbSizeValid);
        assert (this.dbSize >= pagesNumber);
        this.dbSize = pagesNumber;
    }

    @Override
    public int imageSize() {
        assert (this.dbSizeValid);
        return this.dbSize;
    }

    private void doTruncate(int pageNumber) throws SqlJetException {
        long newSize;
        long currentSize;
        if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0 && this.fd != null && (currentSize = this.fd.fileSize()) != (newSize = (long)this.pageSize * (long)pageNumber)) {
            if (currentSize > newSize) {
                this.fd.truncate(newSize);
            } else {
                ISqlJetMemoryPointer b = SqlJetUtility.memoryManager.allocatePtr(1);
                this.fd.write(b, 1, newSize - 1L);
            }
            this.dbFileSize = 0;
        }
    }

    private void syncJournal() throws SqlJetIOException {
        if (this.needSync) {
            assert (!this.tempFile);
            if (this.journalMode != SqlJetPagerJournalMode.MEMORY) {
                long jrnlOff;
                block8: {
                    assert (this.journalOpen);
                    jrnlOff = this.journalHdrOffset();
                    ISqlJetMemoryPointer zMagic = SqlJetUtility.memoryManager.allocatePtr(8);
                    try {
                        this.jfd.read(zMagic, 8, jrnlOff);
                        if (SqlJetUtility.memcmp(zMagic, aJournalMagic, 8) == 0) {
                            ISqlJetMemoryPointer zerobyte = SqlJetUtility.memoryManager.allocatePtr(1);
                            this.jfd.write(zerobyte, 1, jrnlOff);
                        }
                    }
                    catch (SqlJetIOException e) {
                        if (e.getIoErrorCode() == SqlJetIOErrorCode.IOERR_SHORT_READ) break block8;
                        throw e;
                    }
                }
                if (this.fullSync) {
                    SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                    this.jfd.sync();
                }
                jrnlOff = this.journalHdr + (long)aJournalMagic.remaining();
                SqlJetPager.PAGERTRACE("JHDR %s %d %d\n", this.PAGERID(), jrnlOff, 4);
                SqlJetPager.write32bits(this.jfd, jrnlOff, this.nRec);
                SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                this.jfd.sync();
                this.journalStarted = true;
            }
            this.needSync = false;
            this.pageCache.clearSyncFlags();
        }
    }

    static void write32bits(ISqlJetFile fd, long offset, int val) throws SqlJetIOException {
        ISqlJetMemoryPointer b = SqlJetUtility.put4byte(val);
        fd.write(b, b.remaining(), offset);
    }

    static void write32bitsUnsigned(ISqlJetFile fd, long offset, long val) throws SqlJetIOException {
        ISqlJetMemoryPointer b = SqlJetUtility.put4byteUnsigned(val);
        fd.write(b, b.remaining(), offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void begin(boolean exclusive) throws SqlJetException {
        assert (this.state != SqlJetPagerState.UNLOCK);
        if (this.state == SqlJetPagerState.SHARED) {
            assert (this.pagesInJournal == null);
            assert (!this.memDb);
            if (!this.fd.lock(SqlJetLockType.RESERVED)) throw new SqlJetException(SqlJetErrorCode.BUSY);
            this.state = SqlJetPagerState.RESERVED;
            if (exclusive) {
                this.waitOnLock(SqlJetLockType.EXCLUSIVE);
            }
            this.dirtyCache = false;
            SqlJetPager.PAGERTRACE("TRANSACTION %s\n", this.PAGERID());
            if (this.useJournal && !this.tempFile && this.journalMode != SqlJetPagerJournalMode.OFF) {
                this.openJournal();
            }
        } else if (this.journalOpen && this.journalOff == 0L) {
            assert (this.pagesInJournal == null);
            assert (this.nRec == 0);
            assert (this.dbOrigSize == 0);
            this.getPageCount();
            this.pagesInJournal = new BitSet(this.dbSize);
            this.dbOrigSize = this.dbSize;
            this.writeJournalHdr();
        }
        assert (!this.journalOpen || this.journalOff > 0L);
        return;
    }

    private void writeJournalHdr() throws SqlJetException {
        ISqlJetMemoryPointer zHeader = this.getTempSpace();
        int nHeader = Integer.min(this.pageSize, this.getSectorSize());
        this.seekJournalHdr();
        this.journalHdr = this.journalOff;
        zHeader.copyFrom(aJournalMagic, aJournalMagic.remaining());
        assert (this.fd != null || this.noSync);
        if (this.noSync || this.journalMode == SqlJetPagerJournalMode.MEMORY) {
            zHeader.putIntUnsigned(aJournalMagic.remaining(), -1L);
        } else {
            zHeader.putIntUnsigned(aJournalMagic.remaining(), 0L);
        }
        this.cksumInit = this.randomnessInt();
        zHeader.putIntUnsigned(aJournalMagic.remaining() + 4, this.cksumInit);
        zHeader.putIntUnsigned(aJournalMagic.remaining() + 8, this.dbOrigSize);
        zHeader.putIntUnsigned(aJournalMagic.remaining() + 12, this.sectorSize);
        zHeader.fill(aJournalMagic.remaining() + 16, nHeader - (aJournalMagic.remaining() + 16), (byte)0);
        if (this.journalHdr == 0L) {
            zHeader.putIntUnsigned(aJournalMagic.remaining() + 16, this.pageSize);
        }
        int nWrite = 0;
        while (nWrite < this.getSectorSize()) {
            this.jfd.write(zHeader, nHeader, this.journalOff);
            this.journalOff += (long)nHeader;
            nWrite += nHeader;
        }
    }

    private long randomnessInt() {
        return SqlJetBytesUtility.toUnsignedInt(RND.nextInt());
    }

    void openJournal() throws SqlJetException {
        SqlJetFileType fileType = null;
        EnumSet<SqlJetFileOpenPermission> flags = SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.EXCLUSIVE, SqlJetFileOpenPermission.CREATE);
        boolean success = false;
        assert (this.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
        assert (this.useJournal);
        assert (this.pagesInJournal == null);
        this.getPageCount();
        this.pagesInJournal = new BitSet(this.dbSize);
        try {
            if (!this.journalOpen) {
                if (this.tempFile) {
                    flags.add(SqlJetFileOpenPermission.DELETEONCLOSE);
                    fileType = SqlJetFileType.TEMP_JOURNAL;
                } else {
                    fileType = SqlJetFileType.MAIN_JOURNAL;
                }
                this.jfd = this.journalMode == SqlJetPagerJournalMode.MEMORY ? this.fileSystem.memJournalOpen() : this.fileSystem.open(this.journal, fileType, flags);
                this.journalOff = 0L;
                this.journalHdr = 0L;
            }
            this.journalOpen = true;
            this.journalStarted = false;
            this.needSync = false;
            this.nRec = 0;
            SqlJetAssert.assertNull((Object)this.errCode, this.errCode);
            this.dbOrigSize = this.dbSize;
            this.writeJournalHdr();
            success = true;
        }
        finally {
            if (!success) {
                if (this.journal != null) {
                    this.fileSystem.delete(this.journal, false);
                }
                this.endTransaction(false);
                this.pagesInJournal = null;
            }
        }
    }

    @Override
    public void commitPhaseOne(boolean noSync) throws SqlJetException {
        block12: {
            SqlJetAssert.assertNull((Object)this.errCode, this.errCode);
            if (!this.dbModified && (this.journalMode != SqlJetPagerJournalMode.DELETE || this.exclusiveMode())) {
                assert (!this.dirtyCache || !this.journalOpen);
                return;
            }
            SqlJetPager.PAGERTRACE("DATABASE SYNC: File=%s nSize=%d\n", this.fileName, this.dbSize);
            try {
                if (this.state != SqlJetPagerState.SYNCED && !this.memDb && this.dirtyCache) {
                    this.incrChangeCounter();
                    if (this.journalMode != SqlJetPagerJournalMode.OFF) {
                        if (this.dbSize < this.dbOrigSize) {
                            long iSkip = this.PAGER_MJ_PGNO();
                            int dbSize = this.dbSize;
                            this.dbSize = this.dbOrigSize;
                            int i = dbSize + 1;
                            while (i <= this.dbOrigSize) {
                                if (!SqlJetUtility.bitSetTest(this.pagesInJournal, i) && (long)i != iSkip) {
                                    ISqlJetPage pg = this.getPage(i);
                                    pg.write();
                                    pg.unref();
                                }
                                ++i;
                            }
                            this.dbSize = dbSize;
                        }
                        this.syncJournal();
                    }
                    this.writePageList(this.pageCache.getDirtyList());
                    this.pageCache.cleanAll();
                    if (this.dbSize != this.dbFileSize) {
                        assert (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
                        this.doTruncate(this.dbSize - ((long)this.dbSize == this.PAGER_MJ_PGNO() ? 1 : 0));
                    }
                    if (!this.noSync && !noSync) {
                        this.fd.sync();
                    }
                    this.state = SqlJetPagerState.SYNCED;
                }
            }
            catch (SqlJetIOException e) {
                if (e.getIoErrorCode() != SqlJetIOErrorCode.IOERR_BLOCKED) break block12;
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    private void writePageList(List<ISqlJetPage> pList) throws SqlJetException {
        if (pList.isEmpty()) {
            return;
        }
        this.waitOnLock(SqlJetLockType.EXCLUSIVE);
        for (ISqlJetPage page : pList) {
            if (page.getPageNumber() <= this.dbSize && !page.getFlags().contains((Object)SqlJetPageFlags.DONT_WRITE)) {
                long offset = (long)(page.getPageNumber() - 1) * (long)this.pageSize;
                SqlJetPager.PAGERTRACE("STORE %s page %d\n", this.PAGERID(), page.getPageNumber());
                ISqlJetMemoryPointer pData = page.getData();
                this.fd.write(pData, this.pageSize, offset);
                if (page.getPageNumber() == 1) {
                    this.dbFileVers.copyFrom(0, pData, 24, this.dbFileVers.remaining());
                }
                if (page.getPageNumber() <= this.dbFileSize) continue;
                this.dbFileSize = page.getPageNumber();
                continue;
            }
            SqlJetPager.PAGERTRACE("NOSTORE %s page %d\n", this.PAGERID(), page.getPageNumber());
        }
    }

    private ISqlJetFile openTemp(SqlJetFileType type) throws SqlJetException {
        EnumSet<SqlJetFileOpenPermission> flags = EnumSet.of(SqlJetFileOpenPermission.READWRITE, SqlJetFileOpenPermission.CREATE, SqlJetFileOpenPermission.EXCLUSIVE, SqlJetFileOpenPermission.DELETEONCLOSE);
        flags.addAll(this.permissions);
        return this.fileSystem.open(null, type, flags);
    }

    private void incrChangeCounter() throws SqlJetException {
        if (!this.changeCountDone && this.dbSize > 0) {
            ISqlJetPage page = this.getPage(1);
            try {
                page.write();
                int changeCounter = this.dbFileVers.getInt() + 1;
                page.getData().putIntUnsigned(24, changeCounter);
            }
            finally {
                page.unref();
            }
            this.changeCountDone = true;
        }
    }

    @Override
    public void commitPhaseTwo() throws SqlJetException {
        SqlJetAssert.assertNull((Object)this.errCode, this.errCode);
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (!(this.dbModified || this.journalMode == SqlJetPagerJournalMode.DELETE && this.exclusiveMode())) {
            assert (!this.dirtyCache || !this.journalOpen);
            return;
        }
        SqlJetPager.PAGERTRACE("COMMIT %s\n", this.PAGERID());
        assert (this.state == SqlJetPagerState.SYNCED || this.memDb || !this.dirtyCache);
        try {
            this.endTransaction(false);
        }
        catch (SqlJetException e) {
            this.error(e);
        }
    }

    @Override
    public void rollback() throws SqlJetException {
        block11: {
            SqlJetPager.PAGERTRACE("ROLLBACK %s\n", this.PAGERID());
            if (!this.dirtyCache || !this.journalOpen) {
                this.endTransaction(false);
            } else {
                if (this.errCode != null && this.errCode != SqlJetErrorCode.FULL) {
                    if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0) {
                        this.playback(false);
                    }
                    throw new SqlJetException(this.errCode);
                }
                try {
                    if (this.state == SqlJetPagerState.RESERVED) {
                        try {
                            this.playback(false);
                            break block11;
                        }
                        finally {
                            this.endTransaction(false);
                        }
                    }
                    this.playback(false);
                }
                catch (SqlJetException e) {
                    if (!this.memDb) {
                        this.dbSizeValid = false;
                    }
                    this.error(e);
                }
            }
        }
    }

    @Override
    public void sync() throws SqlJetIOException {
        if (!this.memDb) {
            this.fd.sync();
        }
    }

    @Override
    public int getRefCount() {
        return this.pageCache.getRefCount();
    }

    @Override
    public void pageCallback(ISqlJetPage pPg) {
        if (this.doNotSync) {
            return;
        }
        assert (pPg.getFlags().contains((Object)SqlJetPageFlags.DIRTY));
        if (this.errCode == null) {
            try {
                if (pPg.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                    this.syncJournal();
                    if (this.fullSync && this.journalMode != SqlJetPagerJournalMode.MEMORY) {
                        this.nRec = 0;
                        this.writeJournalHdr();
                    }
                }
                this.writePageList(Collections.singletonList(pPg));
            }
            catch (SqlJetException e) {
                this.error(e);
            }
        }
        SqlJetPager.PAGERTRACE("STRESS %s page %d\n", this.PAGERID(), pPg.getPageNumber());
        pPg.makeClean();
    }
}

