/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;

public class SqlJetPage
implements ISqlJetPage {
    public static final SqlJetMemoryBufferType BUFFER_TYPE = SqlJetUtility.getEnumSysProp("SqlJetPage.BUFFER_TYPE", SqlJetMemoryBufferType.ARRAY);
    protected final ISqlJetMemoryPointer pData;
    private SqlJetMemPage pExtra;
    private int pgno;
    private SqlJetPager pPager;
    private final Set<SqlJetPageFlags> flags = EnumSet.noneOf(SqlJetPageFlags.class);
    int nRef;
    SqlJetPageCache pCache;

    SqlJetPage(int szPage, int pgno) {
        this.pData = SqlJetUtility.memoryManager.allocatePtr(szPage, BUFFER_TYPE);
        this.pgno = pgno;
    }

    @Override
    public void dontRollback() {
        assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
        if (!this.pPager.journalOpen || this.pPager.pagesAlwaysRollback.get(this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        if (SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        assert (this.pPager.pagesInJournal != null);
        this.flags.remove((Object)SqlJetPageFlags.NEED_READ);
        this.pPager.pagesInJournal.set(this.pgno);
        SqlJetPager.PAGERTRACE("DONT_ROLLBACK page %d of %s\n", this.pgno, this.pPager.PAGERID());
    }

    @Override
    public void dontWrite() {
        if (this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        this.pPager.pagesAlwaysRollback.set(this.pgno);
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
            if (this.pPager.dbSize != this.pgno || this.pPager.dbOrigSize >= this.pPager.dbSize) {
                SqlJetPager.PAGERTRACE("DONT_WRITE page %d of %s\n", this.pgno, this.pPager.PAGERID());
                this.flags.add(SqlJetPageFlags.DONT_WRITE);
            }
        }
    }

    @Override
    public ISqlJetMemoryPointer getData() {
        return this.pData;
    }

    @Override
    public SqlJetMemPage getExtra() {
        return this.pPager != null ? this.pExtra : null;
    }

    @Override
    public void setExtra(SqlJetMemPage extra) {
        this.pExtra = extra;
    }

    @Override
    public void move(int pageNumber, boolean isCommit) throws SqlJetException {
        int needSyncPgno = 0;
        assert (this.nRef > 0);
        assert (pageNumber > 0);
        SqlJetPager.PAGERTRACE("MOVE %s page %d (needSync=%b) moves to %d\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), pageNumber);
        this.pPager.getContent(this);
        if (this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC) && !isCommit) {
            needSyncPgno = this.pgno;
            assert (this.pageInJournal() || this.pgno > this.pPager.dbOrigSize);
            assert (this.flags.contains((Object)SqlJetPageFlags.DIRTY));
            assert (this.pPager.needSync);
        }
        this.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
        ISqlJetPage pPgOld = this.pPager.lookup(pageNumber);
        assert (pPgOld == null || pPgOld.getRefCount() >= 1);
        if (pPgOld != null && pPgOld.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            this.flags.add(SqlJetPageFlags.NEED_SYNC);
        }
        if (pPgOld != null) {
            this.pPager.pageCache.drop(pPgOld);
        }
        this.pCache.pCache.rekey(this, pageNumber);
        this.pgno = pageNumber;
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY) && this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            this.removeFromDirtyList();
            this.addToDirtyList();
        }
        this.makeDirty();
        this.pPager.dirtyCache = true;
        this.pPager.dbModified = true;
        if (needSyncPgno != 0) {
            SqlJetPage pPgHdr;
            assert (this.pPager.needSync);
            try {
                pPgHdr = (SqlJetPage)this.pPager.getPage(needSyncPgno);
            }
            catch (SqlJetException e) {
                if (this.pPager.pagesInJournal != null && needSyncPgno <= this.pPager.dbOrigSize) {
                    this.pPager.pagesInJournal.clear(needSyncPgno);
                }
                throw e;
            }
            this.pPager.needSync = true;
            assert (!this.pPager.noSync && !this.pPager.memDb);
            pPgHdr.getFlags().add(SqlJetPageFlags.NEED_SYNC);
            pPgHdr.makeDirty();
            pPgHdr.unref();
        }
    }

    @Override
    public void ref() {
        assert (this.nRef > 0);
        ++this.nRef;
    }

    @Override
    public void unref() throws SqlJetException {
        try {
            this.release();
        }
        finally {
            this.pPager.unlockIfUnused();
        }
    }

    @Override
    public void write() throws SqlJetException {
        int nPagePerSector = this.pPager.sectorSize / this.pPager.pageSize;
        if (nPagePerSector > 1) {
            boolean needSync = false;
            assert (!this.pPager.memDb);
            assert (!this.pPager.doNotSync);
            this.pPager.doNotSync = true;
            int pg1 = (this.pgno - 1 & ~(nPagePerSector - 1)) + 1;
            int nPageCount = this.pPager.getPageCount();
            int nPage = this.pgno > nPageCount ? this.pgno - pg1 + 1 : (pg1 + nPagePerSector - 1 > nPageCount ? nPageCount + 1 - pg1 : nPagePerSector);
            assert (nPage > 0);
            assert (pg1 <= this.pgno);
            assert (pg1 + nPage > this.pgno);
            int ii = 0;
            while (ii < nPage) {
                ISqlJetPage pPage;
                int pg = pg1 + ii;
                if (pg == this.pgno || !SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, pg)) {
                    if ((long)pg != this.pPager.PAGER_MJ_PGNO()) {
                        pPage = this.pPager.getPage(pg);
                        pPage.doWrite();
                        if (pPage.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                            needSync = true;
                        }
                        pPage.unref();
                    }
                } else {
                    pPage = this.pPager.lookup(pg);
                    if (pPage != null) {
                        if (pPage.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                            needSync = true;
                            assert (this.pPager.needSync);
                        }
                        pPage.unref();
                    }
                }
                ++ii;
            }
            if (needSync) {
                assert (!this.pPager.memDb && !this.pPager.noSync);
                ii = 0;
                while (ii < nPage && needSync) {
                    SqlJetPage pPage = (SqlJetPage)this.pPager.lookup(pg1 + ii);
                    if (pPage != null) {
                        pPage.flags.add(SqlJetPageFlags.NEED_SYNC);
                        pPage.unref();
                    }
                    ++ii;
                }
                assert (this.pPager.needSync);
            }
            assert (this.pPager.doNotSync);
            this.pPager.doNotSync = false;
        } else {
            this.doWrite();
        }
    }

    @Override
    public void doWrite() throws SqlJetException {
        SqlJetAssert.assertNull((Object)this.pPager.errCode, this.pPager.errCode);
        SqlJetAssert.assertFalse(this.pPager.readOnly, SqlJetErrorCode.PERM);
        this.pPager.getContent(this);
        this.makeDirty();
        if (this.pageInJournal()) {
            this.pPager.dirtyCache = true;
            this.pPager.dbModified = true;
        } else {
            assert (this.pPager.state != SqlJetPagerState.UNLOCK);
            this.pPager.begin(false);
            assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
            if (!this.pPager.journalOpen && this.pPager.useJournal && this.pPager.getJournalMode() != SqlJetPagerJournalMode.OFF) {
                this.pPager.openJournal();
            }
            this.pPager.dirtyCache = true;
            this.pPager.dbModified = true;
            if (!this.pageInJournal() && this.pPager.journalOpen) {
                if (this.pgno <= this.pPager.dbOrigSize) {
                    assert ((long)this.pgno != this.pPager.PAGER_MJ_PGNO());
                    try {
                        long cksum = this.pPager.cksum(this.pData);
                        SqlJetPager.write32bits(this.pPager.jfd, this.pPager.journalOff, this.pgno);
                        try {
                            this.pPager.jfd.write(this.pData, this.pPager.pageSize, this.pPager.journalOff + 4L);
                        }
                        finally {
                            this.pPager.journalOff += (long)(this.pPager.pageSize + 4);
                        }
                        try {
                            SqlJetPager.write32bitsUnsigned(this.pPager.jfd, this.pPager.journalOff, cksum);
                        }
                        finally {
                            this.pPager.journalOff += 4L;
                        }
                    }
                    catch (Throwable throwable) {
                        SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC));
                        if (!this.pPager.noSync) {
                            this.flags.add(SqlJetPageFlags.NEED_SYNC);
                            this.pPager.needSync = true;
                        }
                        throw throwable;
                    }
                    SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC));
                    if (!this.pPager.noSync) {
                        this.flags.add(SqlJetPageFlags.NEED_SYNC);
                        this.pPager.needSync = true;
                    }
                    ++this.pPager.nRec;
                    assert (this.pPager.pagesInJournal != null);
                    this.pPager.pagesInJournal.set(this.pgno);
                } else {
                    if (!this.pPager.journalStarted && !this.pPager.noSync) {
                        this.flags.add(SqlJetPageFlags.NEED_SYNC);
                        this.pPager.needSync = true;
                    }
                    SqlJetPager.PAGERTRACE("APPEND %s page %d needSync=%b\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC));
                }
            }
        }
        assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
        if (this.pPager.dbSize < this.pgno) {
            this.pPager.dbSize = this.pgno;
            if ((long)this.pPager.dbSize == this.pPager.PAGER_MJ_PGNO() - 1L) {
                ++this.pPager.dbSize;
            }
        }
    }

    private boolean pageInJournal() {
        return SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, this.pgno);
    }

    @Override
    public Set<SqlJetPageFlags> getFlags() {
        return this.flags;
    }

    @Override
    public ISqlJetPager getPager() {
        return this.pPager;
    }

    @Override
    public void setPager(SqlJetPager sqlJetPager) {
        this.pPager = sqlJetPager;
    }

    @Override
    public int getPageNumber() {
        return this.pgno;
    }

    public void setPageNumber(int pgno) {
        this.pgno = pgno;
    }

    @Override
    public int getRefCount() {
        return this.nRef;
    }

    @Override
    public boolean isWriteable() {
        return this.flags.contains((Object)SqlJetPageFlags.DIRTY);
    }

    @Override
    public void removeFromDirtyList() {
        this.pCache.dirtyList.remove(this);
    }

    @Override
    public void unpin() {
        if (this.pCache.bPurgeable) {
            this.pCache.pCache.unpin(this, false);
        }
    }

    @Override
    public void makeClean() {
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            this.removeFromDirtyList();
            this.flags.remove((Object)SqlJetPageFlags.DIRTY);
            this.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
            if (this.nRef == 0) {
                this.unpin();
            }
        }
    }

    private void addToDirtyList() {
        this.pCache.dirtyList.add(0, this);
    }

    private void makeDirty() {
        this.flags.remove((Object)SqlJetPageFlags.DONT_WRITE);
        assert (this.nRef > 0);
        if (!this.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            this.flags.add(SqlJetPageFlags.DIRTY);
            this.addToDirtyList();
        }
    }

    @Override
    public void release() {
        assert (this.nRef > 0);
        --this.nRef;
        if (this.nRef == 0) {
            --this.pCache.nRef;
            if (!this.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
                this.unpin();
            } else {
                this.removeFromDirtyList();
                this.addToDirtyList();
            }
        }
    }
}

