/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetVarintResult32;

public final class SqlJetMemoryPointer
implements ISqlJetMemoryPointer {
    private final ISqlJetMemoryBuffer buffer;
    private int pointer;
    private final int limit;

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer buffer, int pointer) {
        this(buffer, pointer, buffer.getSize());
    }

    public SqlJetMemoryPointer(ISqlJetMemoryBuffer buffer, int pointer, int limit) {
        assert (buffer != null);
        assert (pointer >= 0);
        assert (pointer <= buffer.getSize());
        this.buffer = buffer;
        this.pointer = pointer;
        this.limit = limit;
    }

    @Override
    public final ISqlJetMemoryBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final int getPointer() {
        return this.pointer;
    }

    @Override
    public final void movePointer(int count) {
        assert (this.pointer + count >= 0);
        assert (this.pointer + count <= this.buffer.getSize());
        this.pointer += count;
    }

    @Override
    public ISqlJetMemoryPointer pointer(int pos) {
        return this.buffer.getPointer(this.getAbsolute(pos));
    }

    @Override
    public ISqlJetMemoryPointer pointer(int pos, int limit) {
        return new SqlJetMemoryPointer(this.buffer, this.getAbsolute(pos), this.getAbsolute(pos + limit));
    }

    @Override
    public ISqlJetMemoryPointer getMoved(int count) {
        return new SqlJetMemoryPointer(this.buffer, this.pointer + count, this.limit);
    }

    @Override
    public final int getInt() {
        return this.buffer.getInt(this.pointer);
    }

    @Override
    public final long getLong() {
        return this.buffer.getLong(this.pointer);
    }

    @Override
    public final int getByteUnsigned() {
        return this.buffer.getByteUnsigned(this.pointer);
    }

    @Override
    public final long getIntUnsigned() {
        return this.buffer.getIntUnsigned(this.pointer);
    }

    @Override
    public final int getShortUnsigned() {
        return this.buffer.getShortUnsigned(this.pointer);
    }

    @Override
    public final void putInt(int value) {
        this.buffer.putInt(this.pointer, value);
    }

    @Override
    public final void putLong(long value) {
        this.buffer.putLong(this.pointer, value);
    }

    @Override
    public final void putByteUnsigned(int value) {
        this.buffer.putByteUnsigned(this.pointer, value);
    }

    @Override
    public final void putIntUnsigned(long value) {
        this.buffer.putIntUnsigned(this.pointer, value);
    }

    @Override
    public final void putShortUnsigned(int value) {
        this.buffer.putShortUnsigned(this.pointer, value);
    }

    @Override
    public final int readFromFile(RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (file != null);
        assert (channel != null);
        assert (position >= 0L);
        assert (count > 0);
        assert (this.pointer + count <= this.buffer.getSize());
        return this.buffer.readFromFile(this.pointer, file, channel, position, count);
    }

    @Override
    public final int writeToFile(RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (file != null);
        assert (channel != null);
        assert (position >= 0L);
        assert (count > 0);
        assert (this.pointer + count <= this.buffer.getSize());
        return this.buffer.writeToFile(this.pointer, file, channel, position, count);
    }

    @Override
    public final int getAbsolute(int pointer) {
        return this.pointer + pointer;
    }

    @Override
    public final byte getByte(int pointer) {
        return this.buffer.getByte(this.getAbsolute(pointer));
    }

    @Override
    public final int getByteUnsigned(int pointer) {
        return this.buffer.getByteUnsigned(this.getAbsolute(pointer));
    }

    @Override
    public final int getInt(int pointer) {
        return this.buffer.getInt(this.getAbsolute(pointer));
    }

    @Override
    public final long getIntUnsigned(int pointer) {
        return this.buffer.getIntUnsigned(this.getAbsolute(pointer));
    }

    @Override
    public final long getLong(int pointer) {
        return this.buffer.getLong(this.getAbsolute(pointer));
    }

    @Override
    public final short getShort(int pointer) {
        return this.buffer.getShort(this.getAbsolute(pointer));
    }

    @Override
    public final int getShortUnsigned(int pointer) {
        return this.buffer.getShortUnsigned(this.getAbsolute(pointer));
    }

    @Override
    public final void putByte(int pointer, byte value) {
        this.buffer.putByte(this.getAbsolute(pointer), value);
    }

    @Override
    public final ISqlJetMemoryPointer putByteUnsigned(int pointer, int value) {
        this.buffer.putByteUnsigned(this.getAbsolute(pointer), value);
        return this;
    }

    @Override
    public final void putInt(int pointer, int value) {
        this.buffer.putInt(this.getAbsolute(pointer), value);
    }

    @Override
    public final void putIntUnsigned(int pointer, long value) {
        this.buffer.putIntUnsigned(this.getAbsolute(pointer), value);
    }

    @Override
    public final void putLong(int pointer, long value) {
        this.buffer.putLong(this.getAbsolute(pointer), value);
    }

    @Override
    public final void putShort(int pointer, short value) {
        this.buffer.putShort(this.getAbsolute(pointer), value);
    }

    @Override
    public final void putShortUnsigned(int pointer, int value) {
        this.buffer.putShortUnsigned(this.getAbsolute(pointer), value);
    }

    @Override
    public final int remaining() {
        return this.limit - this.pointer;
    }

    @Override
    public final void copyFrom(int dstPos, ISqlJetMemoryPointer src, int srcPos, int length) {
        this.buffer.copyFrom(this.getAbsolute(dstPos), src.getBuffer(), src.getAbsolute(srcPos), length);
    }

    @Override
    public final void copyFrom(ISqlJetMemoryPointer src, int length) {
        this.buffer.copyFrom(this.pointer, src.getBuffer(), src.getPointer(), length);
    }

    @Override
    public final void fill(int count, byte value) {
        this.buffer.fill(this.pointer, count, value);
    }

    @Override
    public final void fill(int from, int count, byte value) {
        this.buffer.fill(this.getAbsolute(from), count, value);
    }

    @Override
    public final byte[] getBytes() {
        byte[] bytes = new byte[this.remaining()];
        this.buffer.getBytes(this.pointer, bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public final void putBytes(byte[] bytes) {
        this.buffer.putBytes(this.pointer, bytes, 0, bytes.length);
    }

    @Override
    public final int getLimit() {
        return this.limit - this.pointer;
    }

    @Override
    public SqlJetVarintResult getVarint() {
        return this.getVarint(0);
    }

    @Override
    public SqlJetVarintResult getVarint(int offset) {
        long l = 0L;
        int i = 0;
        while (i < 8) {
            int b = this.getByteUnsigned(i + offset);
            l = l << 7 | (long)(b & 0x7F);
            if ((b & 0x80) == 0) {
                byte by = (byte)(i + 1);
                i = by;
                return new SqlJetVarintResult(by, l);
            }
            i = (byte)(i + 1);
        }
        int b = this.getByteUnsigned(8 + offset);
        l = l << 8 | (long)b;
        return new SqlJetVarintResult(9, l);
    }

    @Override
    public SqlJetVarintResult32 getVarint32() {
        return this.getVarint32(0);
    }

    @Override
    public SqlJetVarintResult32 getVarint32(int offset) {
        int b;
        int i = offset;
        int x = this.getByteUnsigned(i);
        if (x < 128) {
            return new SqlJetVarintResult32(1, x);
        }
        int a = this.getByteUnsigned(i);
        if ((a & 0x80) == 0) {
            return new SqlJetVarintResult32(1, a);
        }
        if (((b = this.getByteUnsigned(++i)) & 0x80) == 0) {
            a &= 0x7F;
            return new SqlJetVarintResult32(2, (a <<= 7) | b);
        }
        a <<= 14;
        if (((a |= this.getByteUnsigned(++i)) & 0x80) == 0) {
            b &= 0x7F;
            return new SqlJetVarintResult32(3, (a &= 0x1FC07F) | (b <<= 7));
        }
        b <<= 14;
        if (((b |= this.getByteUnsigned(++i)) & 0x80) == 0) {
            a &= 0x1FC07F;
            return new SqlJetVarintResult32(4, (a <<= 7) | (b &= 0x1FC07F));
        }
        a <<= 14;
        if (((a |= this.getByteUnsigned(++i)) & 0x80) == 0) {
            b &= 0xF01FC07F;
            return new SqlJetVarintResult32(5, (a &= 0xF01FC07F) | (b <<= 7));
        }
        return this.getVarint(offset).to32();
    }

    @Override
    public int putVarint(long v) {
        return this.putVarint(0, v);
    }

    @Override
    public int putVarint(int pointer, long v) {
        if ((v & 0xFF00000000000000L) != 0L) {
            this.putByteUnsigned(pointer + 8, (byte)v);
            v >>= 8;
            int i = 7;
            while (i >= 0) {
                this.putByteUnsigned(pointer + i, (byte)(v & 0x7FL | 0x80L));
                v >>= 7;
                --i;
            }
            return 9;
        }
        int n = 0;
        byte[] buf = new byte[10];
        do {
            buf[n++] = (byte)(v & 0x7FL | 0x80L);
        } while ((v >>= 7) != 0L);
        buf[0] = (byte)(buf[0] & 0x7F);
        assert (n <= 9);
        int i = 0;
        int j = n - 1;
        while (j >= 0) {
            this.putByteUnsigned(pointer + i, buf[j]);
            --j;
            ++i;
        }
        return n;
    }

    @Override
    public int putVarint32(int pointer, int v) {
        if (v < 128) {
            this.putByteUnsigned(pointer, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFFF80) == 0) {
            this.putByteUnsigned(pointer, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFC000) == 0) {
            this.putByteUnsigned(pointer, (byte)(v >> 7 | 0x80));
            this.putByteUnsigned(pointer + 1, (byte)(v & 0x7F));
            return 2;
        }
        return this.putVarint(pointer, v);
    }
}

