/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetAbstractMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteArrayBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetDirectByteBuffer;

public class SqlJetMemoryManager
implements ISqlJetMemoryManager {
    private final SqlJetMemoryBufferType defaultBufferType = SqlJetUtility.getEnumSysProp("SqlJetMemoryManager.defaultBufferType", SqlJetMemoryBufferType.ARRAY);

    @Override
    public ISqlJetMemoryPointer allocatePtr(int size) {
        return this.allocate(size).getPointer(0);
    }

    @Override
    public ISqlJetMemoryPointer allocatePtr(int size, SqlJetMemoryBufferType bufferType) {
        return this.allocate(size, bufferType).getPointer(0);
    }

    @Override
    public ISqlJetMemoryPointer allocatePtr(byte[] bytes) {
        return this.allocate(bytes, this.defaultBufferType).getPointer(0);
    }

    @Override
    public ISqlJetMemoryBuffer allocate(int size) {
        return this.allocate(size, this.defaultBufferType);
    }

    @Override
    public ISqlJetMemoryBuffer allocate(int size, SqlJetMemoryBufferType bufferType) {
        if (size >= 0) {
            SqlJetAbstractMemoryBuffer buffer;
            switch (bufferType) {
                case ARRAY: {
                    buffer = new SqlJetByteArrayBuffer(size);
                    break;
                }
                case BUFFER: {
                    buffer = new SqlJetByteBuffer(size);
                    break;
                }
                case DIRECT: {
                    buffer = new SqlJetDirectByteBuffer(size);
                    break;
                }
                default: {
                    buffer = new SqlJetByteArrayBuffer(size);
                }
            }
            return buffer;
        }
        return null;
    }

    @Override
    public ISqlJetMemoryBuffer allocate(byte[] bytes, SqlJetMemoryBufferType bufferType) {
        if (bytes != null) {
            SqlJetAbstractMemoryBuffer buffer;
            switch (bufferType) {
                case ARRAY: {
                    buffer = new SqlJetByteArrayBuffer(bytes);
                    break;
                }
                case BUFFER: 
                case DIRECT: {
                    buffer = new SqlJetByteBuffer(bytes);
                    break;
                }
                default: {
                    buffer = new SqlJetByteArrayBuffer(bytes);
                }
            }
            return buffer;
        }
        return null;
    }
}

