/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetAbstractMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;

public class SqlJetByteArrayBuffer
extends SqlJetAbstractMemoryBuffer
implements ISqlJetMemoryBuffer {
    private final byte[] buffer;

    public SqlJetByteArrayBuffer(int size) {
        assert (size >= 0);
        this.buffer = new byte[size];
    }

    public SqlJetByteArrayBuffer(byte[] bytes) {
        assert (bytes != null);
        this.buffer = bytes;
    }

    @Override
    public int getSize() {
        return this.buffer.length;
    }

    @Override
    public byte getByte(int pointer) {
        assert (pointer >= 0);
        assert (pointer < this.buffer.length);
        return this.buffer[pointer];
    }

    @Override
    public int getInt(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 4);
        return SqlJetBytesUtility.getInt(this.buffer, pointer);
    }

    @Override
    public long getLong(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 8);
        return SqlJetBytesUtility.getLong(this.buffer, pointer);
    }

    @Override
    public short getShort(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 2);
        return SqlJetBytesUtility.getShort(this.buffer, pointer);
    }

    @Override
    public void putByte(int pointer, byte value) {
        assert (pointer >= 0);
        assert (pointer < this.buffer.length);
        this.buffer[pointer] = value;
    }

    @Override
    public void putInt(int pointer, int value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 4);
        SqlJetBytesUtility.putInt(this.buffer, pointer, value);
    }

    @Override
    public void putLong(int pointer, long value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 8);
        SqlJetBytesUtility.putLong(this.buffer, pointer, value);
    }

    @Override
    public void putShort(int pointer, short value) {
        assert (pointer >= 0);
        assert (pointer <= this.buffer.length - 2);
        SqlJetBytesUtility.putShort(this.buffer, pointer, value);
    }

    @Override
    public int readFromFile(int pointer, RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (pointer >= 0);
        assert (pointer < this.buffer.length);
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        file.seek(position);
        return file.read(this.buffer, pointer, count);
    }

    @Override
    public int writeToFile(int pointer, RandomAccessFile file, FileChannel channel, long position, int count) throws IOException {
        assert (pointer >= 0);
        assert (pointer < this.buffer.length);
        assert (file != null);
        assert (position >= 0L);
        assert (count > 0);
        file.seek(position);
        file.write(this.buffer, pointer, count);
        return count;
    }

    @Override
    public byte[] asArray() {
        return this.buffer;
    }

    @Override
    public void copyFrom(int dstPos, ISqlJetMemoryBuffer src, int srcPos, int count) {
        if (src instanceof SqlJetByteArrayBuffer) {
            SqlJetByteArrayBuffer srcBuf = (SqlJetByteArrayBuffer)src;
            System.arraycopy(srcBuf.buffer, srcPos, this.buffer, dstPos, count);
        } else {
            byte[] b = new byte[count];
            src.getBytes(srcPos, b, 0, count);
            this.putBytes(dstPos, b, 0, count);
        }
    }

    @Override
    public void fill(int from, int count, byte value) {
        Arrays.fill(this.buffer, from, from + count, value);
    }

    @Override
    public void getBytes(int pointer, byte[] bytes, int to, int count) {
        System.arraycopy(this.buffer, pointer, bytes, to, count);
    }

    @Override
    public void putBytes(int pointer, byte[] bytes, int from, int count) {
        System.arraycopy(bytes, from, this.buffer, pointer, count);
    }

    @Override
    public int compareTo(int pointer, ISqlJetMemoryBuffer buffer, int bufferPointer) {
        int bufferCount;
        int count;
        int thisCount = this.getSize() - pointer;
        int n = count = thisCount > (bufferCount = buffer.getSize() - bufferPointer) ? bufferCount : thisCount;
        if (buffer instanceof SqlJetByteArrayBuffer) {
            SqlJetByteArrayBuffer b = (SqlJetByteArrayBuffer)buffer;
            int cmp = SqlJetUtility.memcmp(this.buffer, pointer, b.buffer, bufferPointer, count);
            if (cmp != 0) {
                return cmp;
            }
        } else {
            byte[] b = new byte[thisCount];
            buffer.getBytes(bufferPointer, b, 0, thisCount);
            int cmp = SqlJetUtility.memcmp(this.buffer, pointer, b, bufferPointer, count);
            if (cmp != 0) {
                return cmp;
            }
        }
        if (thisCount != bufferCount) {
            if (thisCount > bufferCount) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

