/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.memory;

import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryBuffer;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetBytesUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;

public abstract class SqlJetAbstractMemoryBuffer
implements ISqlJetMemoryBuffer {
    @Override
    public final ISqlJetMemoryPointer getPointer(int pointer) {
        assert (pointer >= 0);
        assert (pointer <= this.getSize());
        return new SqlJetMemoryPointer(this, pointer);
    }

    @Override
    public final int getByteUnsigned(int pointer) {
        assert (pointer >= 0);
        assert (pointer < this.getSize());
        return SqlJetBytesUtility.toUnsignedByte(this.getByte(pointer));
    }

    @Override
    public final void putByteUnsigned(int pointer, int value) {
        this.putByte(pointer, (byte)SqlJetBytesUtility.toUnsignedByte(value));
    }

    @Override
    public final int getShortUnsigned(int pointer) {
        return SqlJetBytesUtility.toUnsignedShort(this.getShort(pointer));
    }

    @Override
    public final void putShortUnsigned(int pointer, int value) {
        this.putShort(pointer, (short)SqlJetBytesUtility.toUnsignedShort(value));
    }

    @Override
    public final long getIntUnsigned(int pointer) {
        return SqlJetBytesUtility.toUnsignedInt(this.getInt(pointer));
    }

    @Override
    public final void putIntUnsigned(int pointer, long value) {
        this.putInt(pointer, (int)SqlJetBytesUtility.toUnsignedInt(value));
    }
}

