/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTable;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;

public class SqlJetMapTable
implements ISqlJetMapTable {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private final boolean writable;

    public SqlJetMapTable(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    @Override
    public ISqlJetMapTableCursor getCursor() throws SqlJetException {
        return this.mapDb.runSynchronized(engine -> new SqlJetMapTableCursor(this.mapDb, this.btree, this.mapDef, this.writable));
    }

    @Override
    public long put(long key, Object ... values) throws SqlJetException {
        return this.mapDb.write().asLong(mapDb -> this.getCursor().put(key, values));
    }

    @Override
    public Object[] get(long key) throws SqlJetException {
        return this.mapDb.read().as(mapDb -> {
            ISqlJetMapTableCursor cursor = this.getCursor();
            if (cursor.goToKey(key)) {
                return cursor.getValue();
            }
            return null;
        });
    }
}

