/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetTimer;

public class SqlJetNoLockFile
implements ISqlJetFile {
    private static final String SQLJET_LOG_FILES_PROP = "SQLJET_LOG_FILES";
    private static final boolean SQLJET_LOG_FILES = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES", false);
    private static Logger filesLogger = Logger.getLogger("SQLJET_LOG_FILES");
    private static final int SQLJET_DEFAULT_SECTOR_SIZE = 512;
    protected FileChannel channel;
    protected Set<SqlJetFileOpenPermission> permissions;
    protected RandomAccessFile file;
    private File filePath;
    private SqlJetLockType lockType = SqlJetLockType.NONE;

    protected static void OSTRACE(String format, Object ... args) {
        if (SQLJET_LOG_FILES) {
            SqlJetUtility.log(filesLogger, format, args);
        }
    }

    public SqlJetNoLockFile(SqlJetFileSystem fileSystem, RandomAccessFile file, File filePath, Set<SqlJetFileOpenPermission> permissions) {
        this.file = file;
        this.filePath = filePath;
        this.permissions = EnumSet.copyOf(permissions);
        this.channel = file.getChannel();
        SqlJetNoLockFile.OSTRACE("OPEN    %s\n", this.filePath);
    }

    @Override
    public synchronized Set<SqlJetFileOpenPermission> getPermissions() {
        return EnumSet.copyOf(this.permissions);
    }

    @Override
    public synchronized void close() throws SqlJetException {
        if (this.file == null) {
            return;
        }
        this.unlock(SqlJetLockType.NONE);
        try {
            try {
                this.file.close();
                this.channel.close();
            }
            catch (IOException e) {
                throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
            }
        }
        finally {
            this.file = null;
            this.channel = null;
        }
        if (this.filePath != null && this.permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE) && !SqlJetFileUtil.deleteFile(this.filePath)) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE, String.format("Can't delete file '%s'", this.filePath.getPath()));
        }
        SqlJetNoLockFile.OSTRACE("CLOSE   %s\n", this.filePath);
    }

    @Override
    public synchronized int read(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        assert (this.channel != null);
        try {
            SqlJetTimer timer = new SqlJetTimer();
            int read = buffer.readFromFile(this.file, this.channel, offset, amount);
            timer.end();
            SqlJetNoLockFile.OSTRACE("READ %s %5d %7d %s\n", this.filePath, read, offset, timer.format());
            return read < 0 ? 0 : read;
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_READ, (Throwable)e);
        }
    }

    @Override
    public synchronized void write(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        assert (this.channel != null);
        try {
            SqlJetTimer timer = new SqlJetTimer();
            int write = buffer.writeToFile(this.file, this.channel, offset, amount);
            timer.end();
            SqlJetNoLockFile.OSTRACE("WRITE %s %5d %7d %s\n", this.filePath, write, offset, timer.format());
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_WRITE, (Throwable)e);
        }
    }

    @Override
    public synchronized void truncate(long size) throws SqlJetIOException {
        assert (size >= 0L);
        assert (this.file != null);
        try {
            this.file.setLength(size);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_TRUNCATE, (Throwable)e);
        }
    }

    @Override
    public synchronized void sync() throws SqlJetIOException {
        assert (this.file != null);
        try {
            SqlJetNoLockFile.OSTRACE("SYNC    %s\n", this.filePath);
            this.channel.force(true);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_FSYNC, (Throwable)e);
        }
    }

    @Override
    public synchronized long fileSize() throws SqlJetException {
        assert (this.file != null);
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    @Override
    public synchronized SqlJetLockType getLockType() {
        return this.lockType;
    }

    @Override
    public synchronized boolean lock(SqlJetLockType lockType) throws SqlJetIOException {
        return false;
    }

    @Override
    public synchronized boolean unlock(SqlJetLockType lockType) throws SqlJetIOException {
        return false;
    }

    @Override
    public synchronized boolean checkReservedLock() {
        return false;
    }

    @Override
    public int sectorSize() {
        return 512;
    }

    @Override
    public boolean isMemJournal() {
        return false;
    }
}

