/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;

public class SqlJetFileSystemsManager
implements ISqlJetFileSystemsManager {
    private Object lock = new Object();
    private ISqlJetFileSystem defaultFileSystem = null;
    private Map<String, ISqlJetFileSystem> fileSystems = new ConcurrentHashMap<String, ISqlJetFileSystem>();
    private static final SqlJetFileSystemsManager MANAGER = new SqlJetFileSystemsManager();

    private SqlJetFileSystemsManager() {
        try {
            this.register(new SqlJetFileSystem(), true);
        }
        catch (SqlJetException e) {
            e.printStackTrace();
        }
    }

    public static SqlJetFileSystemsManager getManager() {
        return MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetFileSystem find(String name) {
        if (name != null) {
            return this.fileSystems.get(name);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.defaultFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ISqlJetFileSystem fs, boolean isDefault) throws SqlJetException {
        this.checkFS(fs);
        this.fileSystems.put(fs.getName(), fs);
        if (isDefault || this.defaultFileSystem == null) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = fs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ISqlJetFileSystem fs) throws SqlJetException {
        this.checkFS(fs);
        this.fileSystems.remove(fs.getName());
        if (fs == this.defaultFileSystem) {
            Object object = this.lock;
            synchronized (object) {
                this.defaultFileSystem = null;
                this.defaultFileSystem = this.fileSystems.size() > 0 ? this.fileSystems.values().iterator().next() : null;
            }
        }
    }

    private void checkFS(ISqlJetFileSystem fs) throws SqlJetException {
        SqlJetAssert.assertNotNull(fs, SqlJetErrorCode.BAD_PARAMETER, "Prameter 'fs' must be not null");
        SqlJetAssert.assertNotNull(fs.getName(), SqlJetErrorCode.BAD_PARAMETER, "fs.getName() must return not null value");
    }
}

