/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetAssert;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFile;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetMemJournal;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetNoLockFile;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

public class SqlJetFileSystem
implements ISqlJetFileSystem {
    private static final String FS_NAME = SqlJetFileSystem.class.getCanonicalName();
    private static final String SQLJET_TEMP_FILE_PREFIX = "tejlqs_";

    @Override
    public String getName() {
        return FS_NAME;
    }

    @Override
    public ISqlJetFile open(File path, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        File filePath;
        SqlJetAssert.assertNotNull(type, SqlJetErrorCode.BAD_PARAMETER, "File type must not be null to open file");
        SqlJetAssert.assertNotEmpty(permissions, SqlJetErrorCode.BAD_PARAMETER, "Permissions must not be null or empty to open file");
        boolean isExclusive = permissions.contains((Object)SqlJetFileOpenPermission.EXCLUSIVE);
        boolean isDelete = permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE);
        boolean isCreate = permissions.contains((Object)SqlJetFileOpenPermission.CREATE);
        boolean isReadonly = permissions.contains((Object)SqlJetFileOpenPermission.READONLY);
        boolean isReadWrite = permissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
        assert (!(isReadonly && isReadWrite || !isReadWrite && !isReadonly));
        assert (!isCreate || isReadWrite);
        assert (!isExclusive || isCreate);
        assert (!isDelete || isCreate);
        assert (SqlJetFileType.MAIN_DB != type || !isDelete);
        assert (SqlJetFileType.MAIN_JOURNAL != type || !isDelete);
        assert (SqlJetFileType.MASTER_JOURNAL != type || !isDelete);
        if (path != null) {
            try {
                filePath = path.getCanonicalFile();
            }
            catch (IOException e) {
                throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
            }
        }
        assert (isDelete && (!isCreate || SqlJetFileType.MASTER_JOURNAL != type && SqlJetFileType.MAIN_JOURNAL != type));
        try {
            filePath = this.getTempFile();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
        }
        assert (filePath != null);
        if (!(isReadWrite || filePath.isFile() && filePath.canRead())) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        String mode = "rw";
        if (isReadonly && !isReadWrite && !isCreate && !isExclusive) {
            mode = "r";
        } else if (isReadWrite && !isExclusive && filePath.isFile() && !filePath.canWrite() && filePath.canRead()) {
            EnumSet<SqlJetFileOpenPermission> ro = EnumSet.copyOf(permissions);
            ro.remove((Object)SqlJetFileOpenPermission.READWRITE);
            ro.remove((Object)SqlJetFileOpenPermission.CREATE);
            ro.add(SqlJetFileOpenPermission.READONLY);
            return this.open(filePath, type, ro);
        }
        RandomAccessFile file = null;
        try {
            file = SqlJetFileUtil.openFile(filePath, mode);
        }
        catch (FileNotFoundException e) {
            if (isReadWrite && !isExclusive) {
                EnumSet<SqlJetFileOpenPermission> ro = EnumSet.copyOf(permissions);
                ro.remove((Object)SqlJetFileOpenPermission.READWRITE);
                ro.remove((Object)SqlJetFileOpenPermission.CREATE);
                ro.add(SqlJetFileOpenPermission.READONLY);
                return this.open(filePath, type, ro);
            }
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        return type.noLock() ? new SqlJetNoLockFile(this, file, filePath, permissions) : new SqlJetFile(this, file, filePath, permissions);
    }

    @Override
    public File getTempFile() throws IOException {
        return File.createTempFile(SQLJET_TEMP_FILE_PREFIX, null);
    }

    @Override
    public boolean delete(File path, boolean sync) {
        assert (path != null);
        return SqlJetFileUtil.deleteFile(path, sync);
    }

    @Override
    public boolean access(File path, SqlJetFileAccesPermission permission) throws SqlJetException {
        assert (path != null);
        assert (permission != null);
        switch (permission) {
            case EXISTS: {
                return path.exists();
            }
            case READONLY: {
                return path.canRead() && !path.canWrite();
            }
            case READWRITE: {
                return path.canRead() && path.canWrite();
            }
        }
        throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Unhandled SqlJetFileAccesPermission value :" + permission.name());
    }

    @Override
    public long sleep(long microseconds) {
        assert (microseconds > 0L);
        long t = System.currentTimeMillis();
        try {
            Thread.sleep(microseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return System.currentTimeMillis() - t;
    }

    @Override
    public ISqlJetFile memJournalOpen() {
        return new SqlJetMemJournal();
    }

    @Override
    public String getFullPath(File filename) throws SqlJetException {
        assert (filename != null);
        try {
            return filename.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_ACCESS, (Throwable)e);
        }
    }
}

