/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetCursorState;

public class SqlJetBtreeCursors {
    private final List<SqlJetBtreeCursor> pCursor = new LinkedList<SqlJetBtreeCursor>();

    public void saveAllCursors(int iRoot, SqlJetBtreeCursor pExcept) throws SqlJetException {
        for (SqlJetBtreeCursor p : this.pCursor) {
            if (p == pExcept || iRoot != 0 && p.pgnoRoot != iRoot || !p.eState.isValid()) continue;
            p.saveCursorPosition();
        }
    }

    public void remove(ISqlJetBtreeCursor cursor) {
        this.pCursor.remove(cursor);
    }

    public void add(SqlJetBtreeCursor cursor) {
        this.pCursor.add(0, cursor);
    }

    public void close() throws SqlJetException {
        for (SqlJetBtreeCursor pCur : new ArrayList<SqlJetBtreeCursor>(this.pCursor)) {
            pCur.closeCursor();
        }
    }

    public boolean isEmpty() {
        return this.pCursor.isEmpty();
    }

    public void tripAllCursors(SqlJetErrorCode errCode) throws SqlJetException {
        for (SqlJetBtreeCursor p : this.pCursor) {
            p.clearCursor();
            p.eState = SqlJetCursorState.FAULT;
            p.error = errCode;
            p.skip = errCode != null ? 1 : 0;
            p.releaseAllPages();
        }
    }
}

