/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryManager;
import org.tmatesoft.sqljet.core.table.SqlJetScope;

public final class SqlJetUtility {
    private static final String SQLJET_LOG_STACKTRACE_PROP = "SQLJET_LOG_STACKTRACE";
    private static final String SQLJET_PACKAGENAME = "org.tmatesoft.sqljet";
    private static final boolean SQLJET_LOG_STACKTRACE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_STACKTRACE", false);
    public static final ISqlJetMemoryManager memoryManager = new SqlJetMemoryManager();
    private static final Pattern NUMBER_PATTER = Pattern.compile("[-+]?(([0-9]+)|([0-9]*\\.))[0-9]+([eE][-+]?[0-9]+)?");
    private static final Pattern REAL_PATTERN = Pattern.compile("[-+]?[0-9]*\\.[0-9]+([eE][-+]?[0-9]+)?");

    public static void log(Logger logger, String format, Object ... args) {
        StringBuilder s = new StringBuilder();
        s.append(String.format(format, args)).append('\n');
        if (SQLJET_LOG_STACKTRACE) {
            SqlJetUtility.logStackTrace(s);
        }
        logger.info(s.toString());
    }

    private static void logStackTrace(StringBuilder s) {
        StackTraceElement[] stackTrace;
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String l = stackTraceElement.toString();
            if (l.startsWith(SQLJET_PACKAGENAME)) {
                s.append('\t').append(l).append('\n');
            }
            ++n2;
        }
    }

    public static final ISqlJetMemoryPointer pointer(ISqlJetMemoryPointer p) {
        return p.getBuffer().getPointer(p.getPointer());
    }

    public static final ISqlJetMemoryPointer wrapPtr(byte[] bs) {
        ISqlJetMemoryPointer p = memoryManager.allocatePtr(bs.length);
        p.putBytes(bs);
        return p;
    }

    public static String getSysProp(String propName, String defValue) {
        return System.getProperty(propName, defValue);
    }

    public static int getIntSysProp(String propName, int defValue) {
        return Integer.parseInt(System.getProperty(propName, Integer.toString(defValue)));
    }

    public static boolean getBoolSysProp(String propName, boolean defValue) {
        return Boolean.parseBoolean(System.getProperty(propName, Boolean.toString(defValue)));
    }

    public static <T extends Enum<T>> T getEnumSysProp(String propName, T defValue) {
        return Enum.valueOf(defValue.getDeclaringClass(), System.getProperty(propName, defValue.toString()));
    }

    public static final ISqlJetMemoryPointer put4byte(int v) {
        ISqlJetMemoryPointer b = memoryManager.allocatePtr(4);
        b.putInt(0, v);
        return b;
    }

    public static final void memcpy(byte[] dest, byte[] src, int length) {
        System.arraycopy(src, 0, dest, 0, length);
    }

    public static final void memcpy(byte[] dest, int dstPos, byte[] src, int srcPos, int length) {
        System.arraycopy(src, srcPos, dest, dstPos, length);
    }

    public static final <T extends SqlJetCloneable> T memcpy(T src) throws SqlJetException {
        try {
            return (T)src.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)e);
        }
    }

    public static int strlen(ISqlJetMemoryPointer s, int from) {
        int p = from;
        while (p < s.remaining() && s.getByteUnsigned(p) != 0) {
            ++p;
        }
        return p - from;
    }

    public static boolean bitSetTest(BitSet bitSet, int index) {
        if (bitSet == null) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        return bitSet.get(index);
    }

    public static final int memcmp(byte[] a1, int from1, byte[] a2, int from2, int count) {
        int i = 0;
        while (i < count) {
            Byte b2;
            Byte b1 = a1[from1 + i];
            int c = b1.compareTo(b2 = Byte.valueOf(a2[from2 + i]));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer a1, ISqlJetMemoryPointer a2, int count) {
        int i = 0;
        while (i < count) {
            int b2;
            int b1 = a1.getByteUnsigned(i);
            int c = b1 - (b2 = a2.getByteUnsigned(i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer a1, int a1offs, ISqlJetMemoryPointer a2, int a2offs, int count) {
        int i = 0;
        while (i < count) {
            int b2;
            int b1 = a1.getByteUnsigned(a1offs + i);
            int c = b1 - (b2 = a2.getByteUnsigned(a2offs + i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    public static byte[] addZeroByteEnd(byte[] b) {
        byte[] r = new byte[b.length + 1];
        SqlJetUtility.memcpy(r, b, b.length);
        r[b.length] = 0;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ISqlJetMemoryPointer buf) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = buf;
        synchronized (iSqlJetMemoryPointer) {
            return new String(buf.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ISqlJetMemoryPointer buf, SqlJetEncoding enc) {
        if (buf == null || enc == null) {
            return null;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer = buf;
        synchronized (iSqlJetMemoryPointer) {
            byte[] bytes = buf.getBytes();
            String s = new String(bytes, enc.getCharset());
            int p = s.indexOf(0);
            return p < 0 ? s : s.substring(0, p);
        }
    }

    public static ISqlJetMemoryPointer fromString(String s, SqlJetEncoding enc) {
        return SqlJetUtility.wrapPtr(s.getBytes(enc.getCharset()));
    }

    public static int varintLen(long v) {
        int i = 0;
        while ((v >>= 7) != 0L && ++i < 9) {
        }
        return i;
    }

    public static final short fromUnsigned(int value) {
        return (short)(value & 0xFFFF);
    }

    public static final int fromUnsigned(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static final ISqlJetMemoryPointer put4byteUnsigned(long v) {
        ISqlJetMemoryPointer b = memoryManager.allocatePtr(4);
        b.putIntUnsigned(v);
        return b;
    }

    public static final long absolute(long i) {
        return i == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(i);
    }

    public static final Object[] addValueToArray(Object[] array1, Object value) {
        Object[] a = new Object[array1.length + 1];
        System.arraycopy(array1, 0, a, 0, array1.length);
        a[a.length - 1] = value;
        return a;
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e) {
        return EnumSet.of(e);
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        return EnumSet.of(e1, e2);
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        return EnumSet.of(e1, e2, e3);
    }

    public static final Object[] adjustNumberTypes(Object[] key) {
        if (key == null) {
            return null;
        }
        int i = 0;
        while (i < key.length) {
            key[i] = SqlJetUtility.adjustNumberType(key[i]);
            ++i;
        }
        return key;
    }

    public static final SqlJetScope adjustScopeNumberTypes(SqlJetScope scope) {
        SqlJetScope.SqlJetScopeBound leftBound = scope.getLeftBound();
        SqlJetScope.SqlJetScopeBound rightBound = scope.getRightBound();
        if (leftBound != null) {
            leftBound = new SqlJetScope.SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(leftBound.getValue()), leftBound.isInclusive());
        }
        if (rightBound != null) {
            rightBound = new SqlJetScope.SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(rightBound.getValue()), rightBound.isInclusive());
        }
        return new SqlJetScope(leftBound, rightBound);
    }

    public static final Object adjustNumberType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return ((Number)value).longValue();
            }
            if (value instanceof Float) {
                return Double.valueOf(((Float)value).toString());
            }
        }
        return value;
    }

    public static ISqlJetMemoryPointer streamToBuffer(InputStream stream) throws SqlJetException {
        try {
            byte[] b = new byte[stream.available()];
            stream.read(b);
            stream.reset();
            return SqlJetUtility.wrapPtr(b);
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    public static Object[] copyArray(Object[] array) {
        if (array == null) {
            return null;
        }
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        return NUMBER_PATTER.matcher(s).matches();
    }

    public static boolean isRealNumber(String s) {
        return SqlJetUtility.isNumber(s) && REAL_PATTERN.matcher(s).matches();
    }

    public static ISqlJetMemoryPointer fromByteBuffer(ByteBuffer b) {
        return new SqlJetByteBuffer(b).getPointer(0);
    }

    public static ISqlJetMemoryPointer getMoved(ISqlJetMemoryPointer preceding, ISqlJetMemoryPointer ptr, int offset) {
        if (ptr.getPointer() + offset >= 0) {
            return ptr.getMoved(offset);
        }
        assert (preceding != null);
        int getFromPreceding = -(ptr.getPointer() + offset);
        int ptrLength = ptr.getLimit();
        int precedingLength = preceding.getLimit() - preceding.getPointer();
        ISqlJetMemoryPointer newPtr = memoryManager.allocatePtr(ptrLength + getFromPreceding);
        newPtr.copyFrom(0, preceding, precedingLength - getFromPreceding, getFromPreceding);
        newPtr.copyFrom(getFromPreceding, ptr, 0, ptrLength);
        return newPtr;
    }
}

