/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetBooleanTransaction;
import org.tmatesoft.sqljet.core.table.ISqlJetConsumer;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;

public abstract class SqlAbstractJetMutex {
    public abstract void enter();

    public abstract boolean attempt();

    public abstract void leave();

    public abstract boolean held();

    public final <T> T run(ISqlJetTransaction<T, SqlAbstractJetMutex> op) throws SqlJetException {
        this.enter();
        try {
            T t = op.run(this);
            return t;
        }
        finally {
            this.leave();
        }
    }

    public final boolean runBool(ISqlJetBooleanTransaction<SqlAbstractJetMutex> op) throws SqlJetException {
        this.enter();
        try {
            boolean bl = op.run(this);
            return bl;
        }
        finally {
            this.leave();
        }
    }

    public final void runVoid(ISqlJetConsumer<SqlAbstractJetMutex> op) throws SqlJetException {
        this.enter();
        try {
            op.run(this);
        }
        finally {
            this.leave();
        }
    }
}

