#!/usr/bin/env python3

"""This module represents the main module of the application used mainly for testing of the new features.
.. module:: xtractor
    :platform: linux
    :synopsis: Represents main module of the application (testing)
.. moduleauthor:: Martin Bazik
"""


import os
import re
import sys
import getopt
from device import Device
from device import App
from adb import ADB


def usage():
    """How to use this script
    """
      
    print("-o,--output [vystup_subor]\n"
    "-i,--ip [ip_adresa] - ip adresa zariadenia pre ladenie po sieti\n"
    "-h,--help - vypíše pomoc")

def printHelp():
    """Prints out script commands
    """

    print("Global commands:\n"
    "\thelp - prints out help\n"
    "\tchoose app - used for selection of the application\n"
    "\tdevice info - prints out info about the device\n"
    "\tlist apps - lists all the present applications with details\n"
    "\tsort apps - sorts applications\n"
    "\tchange device - changes currently used device\n"
    "\tpull full - downloads all the files on the device connected to any application\n"
    "\texit - closes the application\n\n"
    "Commands for individual applications\n"
    "\tapp info - prints details of the application\n"
    "\tlist all files - lists all the files\n"
    "\tlist files - lists filtered files\n"
    "\tsort files - sorts (filters) files\n"
    "\tfind files - searches (filters) for the file name\n"
    "\ttime interval - looks for the files within the given interval\n"
    "\tpull all - downloads all the files of the appication\n"
    "\tpull filter - downloads filtered files\n"
    "\tprint logs - prints logs connected to the application\n"
    "\tsave logs - saves logs connected to the application\n"
    "\treset filter - resets filters used on the files\n"
    "\treset - deselects the application")


if __name__ == "__main__":
    try:
        opts, args = getopt.getopt(sys.argv[1:], "ho:i:", ["help","output=","ip="])
    except getopt.GetoptError as err:
        # print help information and exit:
        print(err) # will print something like "option -a not recognized"
        usage()
        sys.exit(2)

    # Default output directory
    outputFolder = "output"
    ip = None

    # Parses arguments
    for o, a in opts:
        if o == "-a":
            all = True
        elif o in ("-h", "--help"):
            usage()
            sys.exit()
        elif o in ("-o", "--output"):
            outputFolder = a
        elif o in ("-i", "--ip"):
            ip = a
        else:
            assert False, "unhandled option"

    # Preparing phase
    try:
        adb = ADB()
    except ValueError as err:
        print("Adb was not found!")
        sys.exit()
        
    # If ip address was defined, it tries to connect device
    if(ip):
        try:
            adb.connect(ip)
        except ValueError as err:
            print(err)
            
    
    adb.choose()
    try:
        device = Device(adb)
        device.setOutputDir(outputFolder)
        device.getResources()
    except ValueError as err:
        print(err)
        if(err == "Invalid dir"):
            print("Using alternative directory \"output\"")
            device.setOutputDir("output")
        else:
            sys.exit()

    app = None

    # choice contains given command
    choice = ""

    # Working loop
    while(True):
        found = False
        
        try:
            # No app is chosen
            if(not app):
                choice = input("Write your command: ")
            else:
                choice = input("Write your command for "+ app.getID() +": ")
                found = True
                if(choice == "app info"):
                    app.printInfo()
                    print()
                elif(choice == "list all files"):
                    app.printFiles("default")
                elif(choice == "list files"):
                    app.printFiles("filter")
                elif(choice == "sort files"):
                    app.setKeySortFiles()
                    app.setGradientSortFiles()
                    app.sortFiles()
                elif(choice == "find files"):
                    app.findFiles()
                elif(choice == "time interval"):
                    app.findTimeInterval()
                elif(choice == "pull all"):
                    device.pullFiles("all")
                elif(choice == "pull filter"):
                    device.pullFiles("filter")
                elif(choice == "reset filter"):
                    app.resetFilterFiles()
                elif(choice == "reset"):
                    app = None
                elif(choice == "print logs"):
                    app.printLogs()
                elif(choice == "save logs"):
                    device.saveLogs()
                else:
                    found = False
            if(found):
                pass
            elif(choice == "help"):
                printHelp()
            elif(choice == "choose app"):
                app = device.findApp()
            elif(choice == "device info"):
                device.printInfo()
            elif(choice == "list apps"):
                device.printApps()
            elif(choice == "sort apps"):
                device.setKeySortApps()
                device.setGradientSortApps()
                device.sortApps()
            elif(choice == "pull full"):
                device.pullFiles("full")
            elif(choice == "change device"):
                adb.choose()
                device = Device(adb)
                try:
                    device = Device(adb)
                    device.setOutputDir(outputFolder)
                    device.getResources()
                except ValueError as err:
                    print(err)
                    if(err == "Invalid dir"):
                        print("Using alternative directory \"output\"")
                        device.setOutputDir("output")
                    else:
                        sys.exit()
                app = None

            elif(choice == "exit"):
                sys.exit(0)
            else:
                printHelp()
        except ValueError as err:
            print(err)
            sys.exit()
