/*
 * main.cpp
 *
 *  Created on: 15. 12. 2016
 *      Author: nosko
 */

#include <iostream>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <cstdlib>
#include <fstream>
#include <vector>
#include <algorithm>
#include <cmath>

#include "hdrlib.hpp"

#include "python_spec.hpp"

#include "hdrlib_tonemap_intf.hpp"
#include "hdrlib_tonemap_durand.hpp"

int main (int argc, char *argv[])
{
	if (argc != 7 && argc != 8)
	{
		std::cout << "Wrong parameter count" << std::endl;
		return -1;
	}

	int rbeDisabled = 0;

	if(argc == 8)
		rbeDisabled = 1;

	std::string s0 = argv[1];
	std::string s1 = argv[2];
	std::string s2 = argv[3];

	uint32_t t0 = strtol(argv[4], NULL, 10);
	uint32_t t1 = strtol(argv[5], NULL, 10);
	uint32_t t2 = strtol(argv[6], NULL, 10);

	//std::string sOut = argv[7];

	cv::Mat ldr0Loaded(hdr::imageRead(s0));
	cv::Mat ldr1Loaded(hdr::imageRead(s1));
	cv::Mat ldr2Loaded(hdr::imageRead(s2));
	hdr::LdrMat ldr0;
	hdr::LdrMat ldr1;
	hdr::LdrMat ldr2;

	if (ldr0Loaded.empty() || ldr0Loaded.empty() || ldr0Loaded.empty())
	{
		std::cout << "Chyba nacitani obrazku!!!" << std::endl;
	}


	cv::Mat inverseVector = hdr::arrayToCvMat(pixelMapping, 256);

	if (ldr0Loaded.type() == CV_8UC1){
		//std::cout << (uint32_t)ldr0Loaded.at<uint8_t>(1040, 1225) << std::endl;
		hdr::linearize(ldr0Loaded, inverseVector);
		//std::cout << (uint32_t)ldr0Loaded.at<uint8_t>(1040, 1225) << std::endl;
	}
	if (ldr1Loaded.type() == CV_8UC1){
		//std::cout << (uint32_t)ldr1Loaded.at<uint8_t>(1040, 1225) << std::endl;
		hdr::linearize(ldr1Loaded, inverseVector);
		//std::cout << (uint32_t)ldr1Loaded.at<uint8_t>(1040, 1225) << std::endl;
	}
	if (ldr2Loaded.type() == CV_8UC1){
		//std::cout << (uint32_t)ldr2Loaded.at<uint8_t>(1040, 1225) << std::endl;
		hdr::linearize(ldr2Loaded, inverseVector);
		//std::cout << (uint32_t)ldr2Loaded.at<uint8_t>(1040, 1225) << std::endl;
	}


 	if (ldr0Loaded.type() == CV_8UC1)
	{
		cv::Mat tmp;
		hdr::debayer(ldr0Loaded).convertTo(tmp, CV_32FC3);
		ldr0 = hdr::LdrMat(tmp, t0);
	}else if(ldr0Loaded.type() == CV_16UC3){
		cv::Mat tmp;
		ldr0Loaded.convertTo(tmp, CV_32FC3, 0.00390625);
		ldr0 = hdr::LdrMat(tmp, t0);
	}else{
		cv::Mat tmp;
		ldr0Loaded.convertTo(tmp, CV_32FC3);
		ldr0 = hdr::LdrMat(tmp, t0);
	}

	if (ldr1Loaded.type() == CV_8UC1)
	{
		cv::Mat tmp;
		hdr::debayer(ldr1Loaded).convertTo(tmp, CV_32FC3);
		ldr1 = hdr::LdrMat(tmp, t1);
	}else if(ldr1Loaded.type() == CV_16UC3){
		cv::Mat tmp;
		ldr1Loaded.convertTo(tmp, CV_32FC3, 0.00390625);
		ldr1 = hdr::LdrMat(tmp, t1);
	}else{
		cv::Mat tmp;
		ldr1Loaded.convertTo(tmp, CV_32FC3);
		ldr1 = hdr::LdrMat(tmp, t1);
	}

	if (ldr2Loaded.type() == CV_8UC1)
	{
		cv::Mat tmp;
		hdr::debayer(ldr2Loaded).convertTo(tmp, CV_32FC3);
		ldr2 = hdr::LdrMat(tmp, t2);
	}else if(ldr2Loaded.type() == CV_16UC3){
		cv::Mat tmp;
		ldr2Loaded.convertTo(tmp, CV_32FC3, 0.00390625);
		ldr2 = hdr::LdrMat(tmp, t2);
	}else{
		cv::Mat tmp;
		ldr2Loaded.convertTo(tmp, CV_32FC3);
		ldr2 = hdr::LdrMat(tmp, t2);
	}




	std::vector<float> ghostExposureRatios;
	if(rbeDisabled){
		ghostExposureRatios.push_back(ldr1.getExposureTime()/ldr0.getExposureTime());
		ghostExposureRatios.push_back(ldr2.getExposureTime()/ldr1.getExposureTime());
	}else{
		ghostExposureRatios.push_back(getExpRatio(ldr0.getExposureTime(), ldr1.getExposureTime()));
		ghostExposureRatios.push_back(getExpRatio(ldr1.getExposureTime(), ldr2.getExposureTime()));
	}
	std::vector<float> exposureRatios;
	if(rbeDisabled){
		exposureRatios.push_back(ldr2.getExposureTime() / ldr0.getExposureTime());
		exposureRatios.push_back(ldr2.getExposureTime() / ldr1.getExposureTime());
		exposureRatios.push_back(ldr2.getExposureTime() / ldr2.getExposureTime());
	}else{
		exposureRatios.push_back(getExpRatio(ldr2.getExposureTime(), ldr0.getExposureTime()));
		exposureRatios.push_back(getExpRatio(ldr2.getExposureTime(), ldr1.getExposureTime()));
		exposureRatios.push_back(getExpRatio(ldr2.getExposureTime(), ldr2.getExposureTime()));
	}

/*
	std::cout << "ghostExposureRatios" << std::endl;
	for (std::vector<float>::iterator it = ghostExposureRatios.begin(); it != ghostExposureRatios.end(); it++)
	{
		std::cout << *it << std::endl;
	}


	std::cout << "exposureRatios" << std::endl;
	for (std::vector<float>::iterator it = exposureRatios.begin(); it != exposureRatios.end(); it++)
	{
	    std::cout << (*it) << std::endl;
	}
*/

	// 1. vytvorenie sekvencie ldr snimkov
	std::vector<hdr::LdrMat> ldrSeq;
	ldrSeq.push_back(ldr0);
	ldrSeq.push_back(ldr1);
	ldrSeq.push_back(ldr2);
	
	
	//simple merge
	hdr::SimpleMerge simpleMerge = hdr::SimpleMerge();
	simpleMerge.setSequence(ldrSeq);
	simpleMerge.setParameters(exposureRatios);
	simpleMerge.apply();
	simpleMerge.writeImages("results/nodeghost/");
	
	hdr::tmo::TonemapDurand durand = hdr::tmo::TonemapDurand(simpleMerge.getImage());
	durand.prepare(15, 2, 2.0);
	durand.apply();
	durand.writeImages("results/nodeghost/");
	
	//Prediction
	hdr::OrderingMerge orderingMerge = hdr::OrderingMerge();
	orderingMerge.setSequence(ldrSeq);
	orderingMerge.setParameters(exposureRatios);
	orderingMerge.apply();
	orderingMerge.writeImages("results/ordering/");
	
	durand = hdr::tmo::TonemapDurand(orderingMerge.getImage());
	durand.prepare(15, 2, 2.0);
	durand.apply();
	durand.writeImages("results/ordering/");
	
	//HISTOGRAM
	hdr::HistogramMerge histogramMerge = hdr::HistogramMerge();
	histogramMerge.setSequence(ldrSeq);
	histogramMerge.setParameters(exposureRatios);
	histogramMerge.apply();
	histogramMerge.writeImages("results/MTB/");
	
	durand = hdr::tmo::TonemapDurand(histogramMerge.getImage());
	durand.prepare(15, 2, 2.0);
	durand.apply();
	durand.writeImages("results/MTB/");
	
	//MULTIHISTOGRAM
	hdr::MultiHistogramMerge multiHistogramMerge = hdr::MultiHistogramMerge();
	multiHistogramMerge.setSequence(ldrSeq);
	multiHistogramMerge.setParameters(exposureRatios);
	multiHistogramMerge.apply();
	multiHistogramMerge.writeImages("results/multihistogram/");
	
	durand = hdr::tmo::TonemapDurand(multiHistogramMerge.getImage());
	durand.prepare(15, 2, 2.0);
	durand.apply();
	durand.writeImages("results/multihistogram/");

	return 0;
}

