/*
 * hdrlib_histogram_merge.cpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */


#include "hdrlib_ordering_merge.hpp"
#include "hdrlib_core.hpp"

void hdr::OrderingMerge::setSequence(std::vector<LdrMat> seq)
{
	this->sequence = seq;
}

void hdr::OrderingMerge::apply()
{
	uint32_t w, h;
	cv::Mat varianceMat;

	assert(this->sequence.size() == 3);
	//assert(this->exposureRatios.size() == 3);

	hdrImage = cv::Mat(sequence.at(0).size(), CV_32FC3);

	ghost = computeGhost();

	merge(ghost);
}

void hdr::OrderingMerge::setParameters(std::vector<float> exposureRatios){
	this->exposureRatios = exposureRatios;
}

void hdr::OrderingMerge::writeImages(std::string path)
{
	cv::Mat charMatrix = cv::Mat(ghost.size(), CV_8UC1);
	
	for(int y = 0; y < ghost.rows; y++){
		for(int x = 0; x < ghost.cols; x++){
			charMatrix.at<unsigned char>(y,x) = (unsigned char)ghost.at<float>(y,x);
		}
	}
	
	cv::imwrite(path+"ghostmap.jpg", ghost);
	cv::imwrite(path+"HDR.jpg", hdrImage);	//TODO TMO
	cv::imwrite(path+"HDR.exr", hdrImage);
	
	
}

cv::Mat hdr::OrderingMerge::computeGhost()
{
	int imageCount = sequence.size();
	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	
	LdrMat lumaMatrix[imageCount];
	
	cv::Mat ghost = cv::Mat(sequence.at(0).size(), CV_32FC1);

	for(int i = 0; i < imageCount; i++){
		lumaMatrix[i] = sequence.at(i).getLumaLdrMat();
	}
		
	for(int y = 0; y < height; y++){
		for(int x = 0; x < width; x++){
			int error = 0;

			for(int i = 0; i < imageCount-1; i++){
				float darkerPixel = lumaMatrix[i].at<float>(y,x);
				float brighterPixel = lumaMatrix[i+1].at<float>(y,x);
			
				if(brighterPixel < darkerPixel){
						error++; 
				}
			}

			if(error == 0){
				ghost.at<float>(y,x) = 255.0;
			}else{
				ghost.at<float>(y,x) = 0.0;
			}

		}
	}
	return ghost;	
}

void hdr::OrderingMerge::merge(cv::Mat& ghost)
{
	uint32_t w, h;

	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	int imageCount = sequence.size();
	
	int noGhostmap = 0;
    
    //pokud neni dodana ghostmapa, naalokuje se prazdna matice (aby to nebylo nutne osetrovat v kodu) 
    if(ghost.empty()){
    	noGhostmap = 1;
    	ghost = cv::Mat(height, width, CV_8UC1, cv::Scalar(255.0));
    }

	for (uint32_t y = 0; y < height; y++)
	{
		for (uint32_t x = 0; x < width; x++)
		{
			for (uint32_t chan = 0; chan < 3; chan++)
			{
				float totalWeight = 0.0;
				float finalPixel = 0.0;
				float bitmask = ghost.at<float>(y,x);


				if(bitmask != 0.0){
				
					for(int i = 0; i < imageCount; i++){
						float pixel = sequence.at(i).at<cv::Vec3f>(y,x)[chan];
					
						float weight = weightTablesTriangle[i][(unsigned int)pixel];
						
						finalPixel += exposureRatios.at(i) * pixel * weight;
						totalWeight += weight;

					}
				}
				else{
					int i = 1;	//referencni obraz
					float pixel = sequence.at(i).at<cv::Vec3f>(y,x)[chan];
				
					float weight = weightTablesTriangle[i][(unsigned int)pixel];
					
					finalPixel += exposureRatios.at(i) * pixel * weight;
					totalWeight += weight;

				}
				
				if (totalWeight > 0)
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = finalPixel / totalWeight;
				}
				else
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = 0;
				}
				
			}
		}
	}

}

cv::Mat hdr::OrderingMerge::getImage()
{
	return hdrImage;
}
