/*
 * hdrlib_multihistogram_merge.cpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */


#include "hdrlib_multihistogram_merge.hpp"
#include "hdrlib_core.hpp"
#include <string> 

void hdr::MultiHistogramMerge::setSequence(std::vector<LdrMat> seq)
{
	this->sequence = seq;
}

void hdr::MultiHistogramMerge::apply()
{
	uint32_t w, h;
	cv::Mat varianceMat;

	assert(this->sequence.size() == 3);
	//assert(this->exposureRatios.size() == 3);

	hdrImage = cv::Mat(sequence.at(0).size(), CV_32FC3);

	computeGhost(sequence.at(0).cols, sequence.at(0).rows);

	merge(ghostLo, ghostHi);
}

void hdr::MultiHistogramMerge::setParameters(std::vector<float> exposureRatios){
	this->exposureRatios = exposureRatios;
}

void hdr::MultiHistogramMerge::writeImages(std::string path)
{
	cv::Mat charMatrixLo = cv::Mat(ghostLo.size(), CV_8UC1);
	cv::Mat charMatrixHi = cv::Mat(ghostHi.size(), CV_8UC1);
	
	for(int y = 0; y < ghostLo.rows; y++){
		for(int x = 0; x < ghostLo.cols; x++){
			charMatrixLo.at<unsigned char>(y,x) = (unsigned char)ghostLo.at<float>(y,x);
			charMatrixHi.at<unsigned char>(y,x) = (unsigned char)ghostHi.at<float>(y,x);
		}
	}
	
	cv::imwrite(path+"ghostmapLo.jpg", charMatrixLo);
	cv::imwrite(path+"ghostmapHi.jpg", charMatrixHi);

	for(int i = 0; i < sequence.size(); i++){
		cv::imwrite(path+"histogram"+std::to_string(i)+".jpg", histogramImages[i]);
	}
	
	cv::imwrite(path+"histogramDiffs.jpg", diffHistogramImage);
	cv::imwrite(path+"HDR.jpg", hdrImage);	//TODO TMO
	cv::imwrite(path+"HDR.exr", hdrImage);
	
	
}

int hdr::MultiHistogramMerge::computeGhost(int blockSizeX, int blockSizeY)
{
	int imageCount = sequence.size();
	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	int histDivider = 8;
	
	cv::Mat roiImageMatrix[imageCount];
	LdrMat lumaMatrix[imageCount];
	cv::Mat charMatrix[imageCount];
	
	ghostLo = cv::Mat(sequence.at(0).size(), CV_32FC1);
	ghostHi = cv::Mat(sequence.at(0).size(), CV_32FC1);
	diffHistogramImage = cv::Mat(height, width, CV_8UC3, cv::Scalar(0,0,0));
	
	for(int i = 0; i < imageCount; i++){
		lumaMatrix[i] = sequence.at(i).getLumaLdrMat();
		charMatrix[i] = cv::Mat(sequence.at(0).size(), CV_8UC1);
		histogramImages[i] = cv::Mat(height, width, CV_8UC3, cv::Scalar(0,0,0));
	}
	
	for(int i = 0; i < imageCount; i++){
		for(int y = 0; y < sequence.at(i).rows; y++){
			for(int x = 0; x < sequence.at(i).cols; x++){
				charMatrix[i].at<unsigned char>(y,x) = (unsigned char)lumaMatrix[i].at<float>(y,x);
			}
		}
	}
    
    if(blockSizeX != 0 && blockSizeY != 0){
	    blockSizeX = MIN(blockSizeX, width);
		blockSizeY = MIN(blockSizeY, height);
	}else{
		blockSizeX = width;
		blockSizeY = height;
	}
	
	for(int roiy = 0; (roiy+blockSizeY) <= height; roiy+=blockSizeY){
		for(int roix = 0; (roix+blockSizeX) <= width; roix+=blockSizeX){
		//printf("alive at x: %u y:%u\n", roix, roiy);	
			for(int i = 0; i < imageCount; i++){
				cv::Mat roi(charMatrix[i], cv::Rect(roix,roiy,blockSizeX,blockSizeY));//(480,100,32,32));
				roiImageMatrix[i] = roi;
			}
			
			
			//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
			// HISTOGRAM
			CvHistogram *hist[imageCount];
			unsigned int median[imageCount][histDivider];

			for(int chan = 0; chan < imageCount; chan++){
				int numBins = 255;
				float range[] = {0.0, 255.0};
				float *ranges[] = { range };
				hist[chan] = cvCreateHist(1, &numBins, CV_HIST_ARRAY, ranges, 1);
				cvClearHist(hist[chan]);
				
				IplImage* histogramSource = new IplImage(roiImageMatrix[chan]);
				
				cvCalcHist(&histogramSource, hist[chan], 0, NULL);
				
			//		IplImage* histImg = DrawHistogram(hist[chan], numBins, 1, 4);
			//		cvNamedWindow( "Histogram window", CV_WINDOW_AUTOSIZE );
			//		cvShowImage( "Histogram window", histImg);
			//		int key = cv::waitKey(0); 
					
				unsigned int pixelCount = (blockSizeX * blockSizeY);
				//printf("1/2 pixelCount:%d from %d\n",pixelCount, (roiImageMatrix[chan].getWidth() * roiImageMatrix[chan].getHeight()) >> 1);
				unsigned int acc = 0;
				unsigned int currentGroup = 0;
				unsigned int groupLimit = pixelCount / histDivider;
				//printf("chan %d, groupLimit %d, totalPixels %d\n", chan, groupLimit, pixelCount);
				for( int i = 0; i < 8; i++ ){
					median[chan][i] = 255;
				}
				for( int i = 0; i < numBins; i++ ){
					//printf("acc %d, next:%d\t", acc, groupLimit*i);
					acc += (unsigned int)cvQueryHistValue_1D(hist[chan], i);
					if (acc > groupLimit*(currentGroup+1)){
						//printf("currentGroup %d, groupLimit %d, acc %d\n", currentGroup, groupLimit*i, acc);
					    median[chan][currentGroup] = i;
					    median[chan][currentGroup] += (unsigned char)range[0];	//korekce, protoze histogram nezacina na hodnote 0, ale na range[0]
					    currentGroup++;
					    //acc -= (unsigned int)cvQueryHistValue_1D(hist[chan], i);
					    //i--;
					}    
				}
				delete(histogramSource);
				cvReleaseHist(&hist[chan]);
			//		printf("image %d median: %d\n", chan, median[chan]);
			}
	
		// \HISTOGRAM &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
			
			for(int y = 0; y < blockSizeY; y++){
				for(int x = 0; x < blockSizeX; x++){
					unsigned char bitmask = 0;
					int pixelGroups[3];					
					unsigned char pixel;
					
					for(int chan = 0; chan < imageCount; chan++){
						pixel = roiImageMatrix[chan].at<unsigned char>(y,x);
						
						pixelGroups[chan] = 0;
						for(int z = 0; z < histDivider; z++){
						//debugImages	
							//if(x+roix >= 442 && x+roix <= 444 && y+roiy == 722)
							//	printf("   pixel: %d, median[chan][z] %d, group=%d\n", pixel, median[chan][z], z);
							if(pixel < median[chan][z]){
									
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[0] = colorMap[z][0];
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[1] = colorMap[z][1];
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[2] = colorMap[z][2];
								break;
							}else if(z == histDivider-1){
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[0] = colorMap[z][0];
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[1] = colorMap[z][1];
								histogramImages[chan].at<cv::Vec3b>(y+roiy,x+roix)[2] = colorMap[z][2];
							}
							
							pixelGroups[chan]++;
						}
					}
								
					//TODO presuny mezi biny histogramu
					
					if( (abs(pixelGroups[0] - pixelGroups[1]) > 1) ){		//TODO oddelit ERROR, kde se vahuje *0.2
						ghostLo.at<float>(y+roiy,x+roix) = 0.0;
					}else if(std::abs( (long)median[0][pixelGroups[0]] - pixel) <= 1){
						ghostLo.at<float>(y+roiy,x+roix) = 51.0;	// priblizne *0.2
					}else{
						ghostLo.at<float>(y+roiy,x+roix) = 255.0;
					}
					if( (abs(pixelGroups[2] - pixelGroups[1]) > 1) ){
						ghostHi.at<float>(y+roiy,x+roix) = 0.0;
					}else if(std::abs( (long)median[2][pixelGroups[2]] - pixel) <= 1){
						ghostHi.at<float>(y+roiy,x+roix) = 51.0;	// priblizne *0.2
					}else{
						ghostHi.at<float>(y+roiy,x+roix) = 255.0;
					}	
					
					int difference = MAX(abs(pixelGroups[0] - pixelGroups[1]), abs(pixelGroups[2] - pixelGroups[1]));
					
					if(difference > 1){
					diffHistogramImage.at<cv::Vec3b>(y+roiy,x+roix)[0] = colorMap[difference][0];
					diffHistogramImage.at<cv::Vec3b>(y+roiy,x+roix)[1] = colorMap[difference][1];
					diffHistogramImage.at<cv::Vec3b>(y+roiy,x+roix)[2] = colorMap[difference][2];
					}

				}
			}//end pixel
	
 		}
	}//end for ROI

	return 0;	
}

void hdr::MultiHistogramMerge::merge(cv::Mat& ghostLo, cv::Mat& ghostHi)
{
	uint32_t w, h;

	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	int imageCount = sequence.size();
	
	int noGhostmap = 0;
    
    //pokud neni dodana ghostmapa, naalokuje se prazdna matice (aby to nebylo nutne osetrovat v kodu) 
    if(ghostLo.empty() || ghostHi.empty()){
    	noGhostmap = 1;
    	ghostLo = cv::Mat(height, width, CV_8UC1, cv::Scalar(255.0));
    	ghostHi = cv::Mat(height, width, CV_8UC1, cv::Scalar(255.0));
    }

	for (uint32_t y = 0; y < height; y++)
	{
		for (uint32_t x = 0; x < width; x++)
		{
		
			float totalWeight = 0.0;
			float finalPixel = 0.0;
			float bitmaskLo = ghostLo.at<float>(y,x);
			float bitmaskHi = ghostHi.at<float>(y,x);
		
			
			for (uint32_t chan = 0; chan < imageCount; chan++)
			{
				float pixel = 0;
				float weight = 0;
				float ghostWeight = 0.0;
				
				//referencni obraz je zapocitan vzdy
				pixel = sequence.at(1).at<cv::Vec3f>(y,x)[chan];
				weight = weightTablesTriangle[1][(unsigned int)pixel];	//pouzivaji trojuhelnikove vahy
				finalPixel += exposureRatios.at(1) * pixel * weight;
				totalWeight += weight;
				
				if(bitmaskLo == 51.0){
					ghostWeight = 0.2;
				}else if(bitmaskLo == 255.0){
					ghostWeight = 1.0;
				}else{
					ghostWeight = 0.0;
				}
				
				pixel = sequence.at(0).at<cv::Vec3f>(y,x)[chan];
				weight = weightTablesTriangle[1][(unsigned int)pixel];				//pouzivaji trojuhelnikove vahy
				finalPixel += exposureRatios.at(0) * pixel * weight * ghostWeight;
				totalWeight += weight;
				
				if(bitmaskHi == 51.0){
					ghostWeight = 0.2;
				}else if(bitmaskHi == 255.0){
					ghostWeight = 1.0;
				}else{
					ghostWeight = 0.0;
				}
			
				pixel = sequence.at(2).at<cv::Vec3f>(y,x)[chan];
				weight = weightTablesTriangle[1][(unsigned int)pixel];
				finalPixel += exposureRatios.at(2) * pixel * weight * ghostWeight;
				totalWeight += weight;
				
				if (totalWeight > 0)
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = finalPixel / totalWeight;
				}
				else
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = 0;
				}
				
			}
		}
	}

}

cv::Mat hdr::MultiHistogramMerge::getImage()
{
	return hdrImage;
}
