/*
 * hdrlib_histogram_merge.cpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */


#include "hdrlib_merge.hpp"
#include "hdrlib_core.hpp"

void hdr::SimpleMerge::setSequence(std::vector<LdrMat> seq)
{
	this->sequence = seq;
}

void hdr::SimpleMerge::apply()
{
	uint32_t w, h;
	cv::Mat varianceMat;

	assert(this->sequence.size() == 3);
	//assert(this->exposureRatios.size() == 3);

	hdrImage = cv::Mat(sequence.at(0).size(), CV_32FC3);

	merge();
}

void hdr::SimpleMerge::setParameters(std::vector<float> exposureRatios){
	this->exposureRatios = exposureRatios;
}

void hdr::SimpleMerge::writeImages(std::string path)
{
	
	cv::imwrite(path+"HDR.jpg", hdrImage);	//TODO TMO
	cv::imwrite(path+"HDR.exr", hdrImage);
		
}

void hdr::SimpleMerge::merge()
{
	uint32_t w, h;

	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	int imageCount = sequence.size();

	for (uint32_t y = 0; y < height; y++)
	{
		for (uint32_t x = 0; x < width; x++)
		{
			for (uint32_t chan = 0; chan < 3; chan++)
			{
				float totalWeight = 0.0;
				float finalPixel = 0.0;
		
				for(int i = 0; i < imageCount; i++){
					float pixel = sequence.at(i).at<cv::Vec3f>(y,x)[chan];
				
					float weight = weightTablesTriangle[i][(unsigned int)pixel];
					
					finalPixel += exposureRatios.at(i) * pixel * weight;
					totalWeight += weight;
				}
				
				if (totalWeight > 0)
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = finalPixel / totalWeight;
				}
				else
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = 0;
				}
				
			}
		}
	}

}

cv::Mat hdr::SimpleMerge::getImage()
{
	return hdrImage;
}
