/*
 * hdrlib_histogram_merge.cpp
 *
 *  Created on: 3. 11. 2017
 *      Author: nosko
 */


#include "hdrlib_histogram_merge.hpp"
#include "hdrlib_core.hpp"

void hdr::HistogramMerge::setSequence(std::vector<LdrMat> seq)
{
	this->sequence = seq;
}

void hdr::HistogramMerge::apply()
{
	uint32_t w, h;
	cv::Mat varianceMat;

	assert(this->sequence.size() == 3);
	//assert(this->exposureRatios.size() == 3);

	hdrImage = cv::Mat(sequence.at(0).size(), CV_32FC3);

	ghost = computeGhost(sequence.at(0).cols, sequence.at(0).rows);

	merge(ghost);
}

void hdr::HistogramMerge::setParameters(std::vector<float> exposureRatios){
	this->exposureRatios = exposureRatios;
}

void hdr::HistogramMerge::writeImages(std::string path)
{
	cv::Mat charMatrix = cv::Mat(ghost.size(), CV_8UC1);
	
	for(int y = 0; y < ghost.rows; y++){
		for(int x = 0; x < ghost.cols; x++){
			charMatrix.at<unsigned char>(y,x) = (unsigned char)ghost.at<float>(y,x);
		}
	}
	
	cv::imwrite(path+"ghostmap.jpg", ghost);
	cv::imwrite(path+"HDR.jpg", hdrImage);	//TODO TMO
	cv::imwrite(path+"HDR.exr", hdrImage);
	
	
}

cv::Mat hdr::HistogramMerge::computeGhost(int blockSizeX, int blockSizeY)
{
	int imageCount = sequence.size();
	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	
	cv::Mat roiImageMatrix[imageCount];
	LdrMat lumaMatrix[imageCount];
	cv::Mat charMatrix[imageCount];
	
	cv::Mat ghost = cv::Mat(sequence.at(0).size(), CV_32FC1);

	for(int i = 0; i < imageCount; i++){
		lumaMatrix[i] = sequence.at(i).getLumaLdrMat();
		charMatrix[i] = cv::Mat(ghost.size(), CV_8UC1);
	}
	
	for(int i = 0; i < imageCount; i++){
		for(int y = 0; y < sequence.at(i).rows; y++){
			for(int x = 0; x < sequence.at(i).cols; x++){
				charMatrix[i].at<unsigned char>(y,x) = (unsigned char)lumaMatrix[i].at<float>(y,x);
			}
		}
	}
    
    if(blockSizeX != 0 && blockSizeY != 0){
	    blockSizeX = MIN(blockSizeX, width);
		blockSizeY = MIN(blockSizeY, height);
	}else{
		blockSizeX = width;
		blockSizeY = height;
	}
	
	for(int roiy = 0; (roiy+blockSizeY) <= height; roiy+=blockSizeY){
		for(int roix = 0; (roix+blockSizeX) <= width; roix+=blockSizeX){
		//printf("alive at x: %u y:%u\n", roix, roiy);	
			for(int i = 0; i < imageCount; i++){
				cv::Mat roi(charMatrix[i], cv::Rect(roix,roiy,blockSizeX,blockSizeY));//(480,100,32,32));
				roiImageMatrix[i] = roi;
			}
			
			
			//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
			// HISTOGRAM
			CvHistogram *hist[imageCount];
			unsigned int median[imageCount];

			for(int chan = 0; chan < imageCount; chan++){
				int numBins = 255;
				float range[] = {0.0, 255.0};
				float *ranges[] = { range };
				hist[chan] = cvCreateHist(1, &numBins, CV_HIST_ARRAY, ranges, 1);
				cvClearHist(hist[chan]);
				
				IplImage* histogramSource = new IplImage(roiImageMatrix[chan]);
				
				cvCalcHist(&histogramSource, hist[chan], 0, NULL);
				
			//		IplImage* histImg = DrawHistogram(hist[chan], numBins, 1, 4);
			//		cvNamedWindow( "Histogram window", CV_WINDOW_AUTOSIZE );
			//		cvShowImage( "Histogram window", histImg);
			//		int key = cv::waitKey(0); 
					
				unsigned int pixelCount = (blockSizeX * blockSizeY) >> 1;
				unsigned int acc = 0;
				median[chan] = 255;
				for( int i = 0; i < numBins; ++i ){

					acc += (unsigned int)cvQueryHistValue_1D(hist[chan], i);
					if (acc > pixelCount){
						median[chan] = i;
						median[chan] += range[0];	//mozna korekce, pokud histogram nezacina na hodnote 0, ale na range[0]
						break;
					}    
				}
				delete(histogramSource);
				cvReleaseHist(&hist[chan]);
			//		printf("image %d median: %d\n", chan, median[chan]);
			}
	
		// \HISTOGRAM &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
		
		
			for(int y = 0; y < blockSizeY; y++){
				for(int x = 0; x < blockSizeX; x++){
					int overMedianCount = 0;
					int underMedianCount = 0;
					unsigned char bitmask = 0;
					unsigned char lastResult = 0;
						if(roiImageMatrix[0].at<unsigned char>(y,x) >= median[0]){
							lastResult = 1;
						}
					for(int chan = 0; chan < imageCount; chan++){
						unsigned char pixel = roiImageMatrix[chan].at<unsigned char>(y,x);
						if(x >= 152 && x <= 156 && y == 1042)
						printf("pixel: %d\n", pixel);

						
						if(lastResult == 1){			
							if(pixel >= MAX(0, int(median[chan])-2)){//(pixel>>3)
								overMedianCount++;
								bitmask |= (1<<(chan));
								lastResult = 1;
							}else lastResult = 0;
						}else{
							if(pixel >= MIN(252, int(median[chan])+2)){ //((255-pixel)>>3)
								overMedianCount++;
								bitmask |= (1<<(chan));
								lastResult = 1;
							}else lastResult = 0;
						
						}
					}

					if(overMedianCount == 0 || overMedianCount == 3){
					//if(((bitmask == 0) || (bitmask == pow(2,imageCount)-1))){//if(error == 0){
						ghost.at<float>(y+roiy,x+roix) = 255.0;
					}else{
						ghost.at<float>(y+roiy,x+roix) = 0.0;
					}

				}
			}//end pixel
	
 		}
	}//end for ROI

	return ghost;	
}

void hdr::HistogramMerge::merge(cv::Mat& ghost)
{
	uint32_t w, h;

	int width = sequence.at(0).cols;
	int height = sequence.at(0).rows;
	int imageCount = sequence.size();
	
	int noGhostmap = 0;
    
    //pokud neni dodana ghostmapa, naalokuje se prazdna matice (aby to nebylo nutne osetrovat v kodu) 
    if(ghost.empty()){
    	noGhostmap = 1;
    	ghost = cv::Mat(height, width, CV_8UC1, cv::Scalar(255.0));
    }

	for (uint32_t y = 0; y < height; y++)
	{
		for (uint32_t x = 0; x < width; x++)
		{
			for (uint32_t chan = 0; chan < imageCount; chan++)
			{
				float totalWeight = 0.0;
				float finalPixel = 0.0;
				float bitmask = ghost.at<float>(y,x);


				if(bitmask != 0.0){
				
					for(int i = 0; i < imageCount; i++){
						float pixel = sequence.at(i).at<cv::Vec3f>(y,x)[chan];
					
						float weight = weightTablesTriangle[1][(unsigned int)pixel];
						
						finalPixel += exposureRatios.at(i) * pixel * weight;
						totalWeight += weight;

					}
				}
				else{
					int i = 1;	//referencni obraz
					float pixel = sequence.at(i).at<cv::Vec3f>(y,x)[chan];
				
					float weight = weightTablesTriangle[1][(unsigned int)pixel];
					
					finalPixel += exposureRatios.at(i) * pixel * weight;
					totalWeight += weight;

				}
				
				if (totalWeight > 0)
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = finalPixel / totalWeight;
				}
				else
				{
					hdrImage.at<cv::Vec3f>(y, x)[chan] = 0;
				}
				
			}
		}
	}

}

cv::Mat hdr::HistogramMerge::getImage()
{
	return hdrImage;
}
