#!/bin/bash

#
# File:   tile.sh
# Author: Pavel Najman <najman.pavel at gmail.com>
#
# Created on May 28, 2017, 8:12 AM
#

function make_all {
	cd ..
	make all > /dev/null
	cd tests
}

function run_test_nsp_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3

	W=${TILE_SIZE}
	H=${TILE_SIZE}
	
	../test_nsp/dist/Release_No_SSE/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${W} ${H} ${TILE_SIZE} 1
}

function run_test_sep_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3

	W=${TILE_SIZE}
	H=${TILE_SIZE}
	
	../test_sep/dist/Release_No_SSE/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${W} ${H} ${TILE_SIZE} 1
}

function run_test_nsp_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$3

	../test_nsp/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} 1
}

function run_test_sep_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$3

	../test_sep/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} 1
}

NUM_SOCKETS=1
NUM_THREADS=$1

if [ -z "$1" ] 
then
	echo "Usage: ./tile.sh NUM_THREADS"
	exit 1
fi

make_all
	
RESOLUTIONS=()

NSP_NO_SSE_RESULTS=()
SEP_NO_SSE_RESULTS=()
NSP_NO_SSE_NO_BARRIER_RESULTS=()
SEP_NO_SSE_NO_BARRIER_RESULTS=()

RES_OUT=results/TILES.out

echo "tile-size	separable	non-separable	separable-redundant	non-separable-redundant" | tee $RES_OUT

SIZES="128 184 256 368 512 728 1024 1448 2048 2896 4096 5792 8192 11584 16384"

I=0
for TILE_SIZE in $SIZES 
do
	if (( TILE_SIZE/2 < NUM_THREADS ))
	then
		continue
	fi

	RESOLUTIONS[$I]=$TILE_SIZE

	echo -n "$TILE_SIZE"

	TMP=$(run_test_sep_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	SEP_NO_SSE_RESULTS[$I]=$TMP
	
	TMP=$(run_test_nsp_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	NSP_NO_SSE_RESULTS[$I]=$TMP

	TMP=$(run_test_sep_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	SEP_NO_SSE_NO_BARRIER_RESULTS[$I]=$TMP
	
	TMP=$(run_test_nsp_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo "	$TMP"
	NSP_NO_SSE_NO_BARRIER_RESULTS[$I]=$TMP
	I=$(( I+1 ))
done

LEN=$I

for ((  I=0; I < LEN; I+=1 ))
do
	echo "${RESOLUTIONS[$I]}	${SEP_NO_SSE_RESULTS[$I]}	${NSP_NO_SSE_RESULTS[$I]}	${SEP_NO_SSE_NO_BARRIER_RESULTS[$I]}	${NSP_NO_SSE_NO_BARRIER_RESULTS[$I]}" >> $RES_OUT
done

exit 0
