#!/bin/bash

#
# File:   threads.sh
# Author: Pavel Najman <najman.pavel at gmail.com>
#
# Created on July 25, 2017, 10:08 AM
#

function make_all {
	cd ..
	make all > /dev/null
	cd tests

}

function run_test_nsp_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3

	W=${TILE_SIZE}
	H=${TILE_SIZE}
	
	../test_nsp/dist/Release_No_SSE/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${W} ${H} ${TILE_SIZE} 1
}

function run_test_sep_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3

	W=${TILE_SIZE}
	H=${TILE_SIZE}
	
	../test_sep/dist/Release_No_SSE/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${W} ${H} ${TILE_SIZE} 1
}

function run_test_nsp_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$3

	../test_nsp/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} 1
}

function run_test_sep_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$3

	../test_sep/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} 1
}

NUM_SOCKETS=1
MAX_THREADS=$1
TILE_SIZE=$2

if [ -z "$1" ]
then
	echo "Usage: ./threads.sh MAX_THREADS [TILE_SIZE (default 512)]"
	exit 1
fi

if [ -z "$2" ]
then
	TILE_SIZE=512
fi
	
if (( TILE_SIZE/2 < NUM_THREADS ))
then
	echo "Error: TILE_SIZE too small! It has to be at least 2*MAX_THREADS."
	exit 1
fi

make_all
	
THREADS=()

NSP_NO_SSE_RESULTS=()
SEP_NO_SSE_RESULTS=()
NSP_NO_SSE_NO_BARRIER_RESULTS=()
SEP_NO_SSE_NO_BARRIER_RESULTS=()

RES_OUT=results/THREADS.out

echo "number-of-threads	separable	non-separable	separable-redundant	non-separable-redundant" | tee $RES_OUT

for (( I=0, NUM_THREADS=1; NUM_THREADS <= MAX_THREADS; NUM_THREADS+=1, I+=1 ))
do

	THREADS[$I]=$NUM_THREADS

	echo -n "$NUM_THREADS"

	TMP=$(run_test_sep_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	SEP_NO_SSE_RESULTS[$I]=$TMP
	
	TMP=$(run_test_nsp_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	NSP_NO_SSE_RESULTS[$I]=$TMP
	
	TMP=$(run_test_sep_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo -n "	$TMP"
	SEP_NO_SSE_NO_BARRIER_RESULTS[$I]=$TMP
	
	TMP=$(run_test_nsp_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE)
	echo "	$TMP"
	NSP_NO_SSE_NO_BARRIER_RESULTS[$I]=$TMP
done

for (( I=0, NUM_THREADS=1; NUM_THREADS <= MAX_THREADS; NUM_THREADS+=1, I+=1 ))
do
	echo "${THREADS[$I]}	${SEP_NO_SSE_RESULTS[$I]}	${NSP_NO_SSE_RESULTS[$I]}	${SEP_NO_SSE_NO_BARRIER_RESULTS[$I]}	${NSP_NO_SSE_NO_BARRIER_RESULTS[$I]}" >> $RES_OUT
done

exit 0
