#!/bin/bash

#
# File:   image.sh
# Author: Pavel Najman <najman.pavel at gmail.com>
#
# Created on May 28, 2017, 8:23 AM
#

function make_all {
	cd ..
	make all > /dev/null
	cd tests
}

function run_test_nsp_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$4
	METHOD=$5

	../test_nsp/dist/Release_No_SSE/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} ${METHOD}
}

function run_test_sep_no_SSE {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$4
	METHOD=$5

	../test_sep/dist/Release_No_SSE/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} ${METHOD}
}

function run_test_nsp_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$4
	METHOD=$5

	../test_nsp/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_nsp ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} ${METHOD}
}

function run_test_sep_no_SSE_no_barrier {
	NUM_SOCKETS=$1
	NUM_THREADS=$2
	TILE_SIZE=$3
	IMAGE_SIZE=$4
	METHOD=$5

	../test_sep/dist/Release_No_SSE_No_Barrier/GNU-Linux/test_sep ${NUM_SOCKETS} ${NUM_THREADS} ${IMAGE_SIZE} ${IMAGE_SIZE} ${TILE_SIZE} ${METHOD}
}

NUM_SOCKETS=1
NUM_THREADS=$1
TILE_SIZE=$2
METHOD=$3

if [ -z "$1" ] || [ -z "$2" ]
then
	echo "Usage: ./image.sh NUM_THREADS TILE_SIZE"
	exit 1
fi

if (( TILE_SIZE/2 < NUM_THREADS ))
then
	echo "Error: TILE_SIZE too small. It has to be at least 2*NUM_THREADS."
	exit 1
fi

if [ -z "$3" ]
then
	METHOD=0
fi

make_all

if (( METHOD == 0 ))
then
	RES_OUT=results/IMAGES.out
else
	RES_OUT=results/TILES_IN_IMAGES.out
fi
	
echo "image-size	separable	non-separable	separable-redundant	non-separable-redundant" | tee $RES_OUT

SIZES="1024 2048 3072 4096 5120 8192 11264 16384 23552 32768"

for IMAGE_SIZE in $SIZES
do
	echo -n "$IMAGE_SIZE"
	echo -n "	$TILE_SIZE"

	SEP_NO_SSE_RESULT=$(run_test_sep_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE $IMAGE_SIZE $METHOD)
	echo -n "	$SEP_NO_SSE_RESULT"
	
	NSP_NO_SSE_RESULT=$(run_test_nsp_no_SSE ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE $IMAGE_SIZE $METHOD)
	echo -n "	$NSP_NO_SSE_RESULT"

	SEP_NO_SSE_NO_BARRIER_RESULT=$(run_test_sep_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE $IMAGE_SIZE $METHOD)
	echo -n "	$SEP_NO_SSE_NO_BARRIER_RESULT"

	NSP_NO_SSE_NO_BARRIER_RESULT=$(run_test_nsp_no_SSE_no_barrier ${NUM_SOCKETS} $NUM_THREADS $TILE_SIZE $IMAGE_SIZE $METHOD)
	echo "	$NSP_NO_SSE_NO_BARRIER_RESULT"

	echo "${IMAGE_SIZE}	${SEP_NO_SSE_RESULT}	${NSP_NO_SSE_RESULT}	${SEP_NO_SSE_NO_BARRIER_RESULT}	${NSP_NO_SSE_NO_BARRIER_RESULT}" >> $RES_OUT
done

exit 0
